#!/bin/csh -f
#
# 5799-WZQ (C) COPYRIGHT = NONE
# LICENSED MATERIALS - PROPERTY OF IBM
#
# $Header:which.csh 12.0$ 
# $ACIS:which.csh 12.0$ 
# $Source: /ibm/acis/usr/src/ucb/RCS/which.csh,v $ 

#
# Copyright (c) 1980 Regents of the University of California.
# All rights reserved.  The Berkeley software License Agreement
# specifies the terms and conditions for redistribution.
#
#	@(#)which.csh	5.2 (Berkeley) 7/29/85
#
#	which : tells you which program you get
#
set prompt = "% "
if ( -f ~/.cshrc) then
	source ~/.cshrc
endif
set noglob
foreach arg ( $argv )
    set alius = `alias $arg`
    switch ( $#alius )
	case 0 :
	    breaksw
	case 1 :
	    set arg = $alius[1]
	    breaksw
        default :
	    echo ${arg}: "	" aliased to $alius
	    continue
    endsw
    unset found
    if ( $arg:h != $arg:t ) then
	if ( -e $arg ) then
	    echo $arg
	else
	    echo $arg not found
	endif
	continue
    else
	foreach i ( $path )
	    if ( -x $i/$arg && ! -d $i/$arg ) then
		echo $i/$arg
		set found
		break
	    endif
	end
    endif
    if ( ! $?found ) then
	echo no $arg in $path
    endif
end
