/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:rvice.cs.c 12.0$ */
/* $ACIS:rvice.cs.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/afsint/RCS/rvice.cs.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvice.cs.c 12.0$";
#endif

#include "../h/types.h"
#include "../h/socket.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../netinet/in.h"
#include "../h/time.h"
#include "../rpc/types.h"
#include "../rpc/xdr.h"

#define R_INTERNALS	1
#include "../afs/osi.h"
#include "../afs/r.h"
#undef R_INTERNALS

#include	"../afsint/rvaux.h"
#include	"../afsint/rvice.h"

#ifndef NULL
#define NULL		0
#endif

int RViceConnectFS(z_conn, UserName, WorkStation, VenusName)
	register struct r_connection *z_conn;
	char * UserName, *WorkStation, *VenusName;
{
	register struct r_packet *z_pb;
	static int z_op = VICECONNECTFS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_wrapstring(&z_pb->xdrs, &UserName))
	     || (!xdr_wrapstring(&z_pb->xdrs, &WorkStation))
	     || (!xdr_wrapstring(&z_pb->xdrs, &VenusName))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceFetch(z_conn, Fid, BidFid, Request, Bulk, AccessList, Status)
	register struct r_connection *z_conn;
	struct ViceFid * Fid, *BidFid;
	long Request;
	struct BD * Bulk;
	struct BBS * AccessList;
	struct ViceStatus * Status;
{
	register struct r_packet *z_pb;
	static int z_op = VICEFETCH;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_ViceFid(&z_pb->xdrs, BidFid))
	     || (!xdr_long(&z_pb->xdrs, &Request))
	     || (!xdr_BD(&z_pb->xdrs, Bulk))
	     || (!xdr_BBS(&z_pb->xdrs, AccessList))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_BBS(&z_pb->xdrs, AccessList))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceStore(z_conn, Fid, Requst, AccessList, Bulk, Status, Length)
	register struct r_connection *z_conn;
	struct ViceFid * Fid;
	long Requst, Length;
	struct CBS * AccessList;
	struct BD * Bulk;
	struct ViceStatus * Status;
{
	register struct r_packet *z_pb;
	static int z_op = VICESTORE;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_long(&z_pb->xdrs, &Requst))
	     || (!xdr_CBS(&z_pb->xdrs, AccessList))
	     || (!xdr_BD(&z_pb->xdrs, Bulk))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))
	     || (!xdr_long(&z_pb->xdrs, &Length))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceRemove(z_conn, Did, Name, Status)
	register struct r_connection *z_conn;
	struct ViceFid * Did;
	char * Name;
	struct ViceStatus * Status;
{
	register struct r_packet *z_pb;
	static int z_op = VICEREMOVE;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Did))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceCreate(z_conn, Did, BidFid, Name, Status, Fid, DirStatus)
	register struct r_connection *z_conn;
	struct ViceFid * Did, *BidFid, *Fid;
	char * Name;
	struct ViceStatus * Status, *DirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = VICECREATE;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Did))
	     || (!xdr_ViceFid(&z_pb->xdrs, BidFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_ViceStatus(&z_pb->xdrs, DirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceRename(z_conn, OldDid, OldName, NewDid, NewName, OldDirStatus, NewDirStatus)
	register struct r_connection *z_conn;
	struct ViceFid * OldDid, *NewDid;
	char * OldName, *NewName;
	struct ViceStatus * OldDirStatus;
	ViceStatus * NewDirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = VICERENAME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, OldDid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &OldName))
	     || (!xdr_ViceFid(&z_pb->xdrs, NewDid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &NewName))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, OldDirStatus))
	     || (!xdr_ViceStatus(&z_pb->xdrs, NewDirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceSymLink(z_conn, Did, NewName, OldName, Status, Fid, DirStatus)
	register struct r_connection *z_conn;
	struct ViceFid * Did, *Fid;
	char * NewName, *OldName;
	struct ViceStatus * Status, *DirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = VICESYMLINK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Did))
	     || (!xdr_wrapstring(&z_pb->xdrs, &NewName))
	     || (!xdr_wrapstring(&z_pb->xdrs, &OldName))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_ViceStatus(&z_pb->xdrs, DirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceLink(z_conn, Did, Name, Fid, Status, DirStatus)
	register struct r_connection *z_conn;
	struct ViceFid * Did, *Fid;
	char * Name;
	struct ViceStatus * Status, *DirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = VICELINK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Did))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))
	     || (!xdr_ViceStatus(&z_pb->xdrs, DirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceMakeDir(z_conn, Did, Name, Status, NewDid, DirStatus)
	register struct r_connection *z_conn;
	struct ViceFid * Did, *NewDid;
	char * Name;
	struct ViceStatus * Status, *DirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = VICEMAKEDIR;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Did))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))
	     || (!xdr_ViceFid(&z_pb->xdrs, NewDid))
	     || (!xdr_ViceStatus(&z_pb->xdrs, DirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceRemoveDir(z_conn, Did, Name, Status)
	register struct r_connection *z_conn;
	struct ViceFid * Did;
	char * Name;
	struct ViceStatus * Status;
{
	register struct r_packet *z_pb;
	static int z_op = VICEREMOVEDIR;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Did))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceRemoveCallBack(z_conn, Fid)
	register struct r_connection *z_conn;
	struct ViceFid * Fid;
{
	register struct r_packet *z_pb;
	static int z_op = VICEREMOVECALLBACK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceSetLock(z_conn, Fid, Type)
	register struct r_connection *z_conn;
	struct ViceFid * Fid;
	long Type;
{
	register struct r_packet *z_pb;
	static int z_op = VICESETLOCK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_long(&z_pb->xdrs, &Type))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceReleaseLock(z_conn, Fid)
	register struct r_connection *z_conn;
	struct ViceFid * Fid;
{
	register struct r_packet *z_pb;
	static int z_op = VICERELEASELOCK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceGetRootVolume(z_conn, Volume)
	register struct r_connection *z_conn;
	struct BBS * Volume;
{
	register struct r_packet *z_pb;
	static int z_op = VICEGETROOTVOLUME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_BBS(&z_pb->xdrs, Volume))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_BBS(&z_pb->xdrs, Volume))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceNewConnection(z_conn)
	register struct r_connection *z_conn;
{
	register struct r_packet *z_pb;
	static int z_op = VICENEWCONNECTION;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceGetVolumeStatus(z_conn, Vid, Status, Name, OfflineMsg, MOTD)
	register struct r_connection *z_conn;
	long Vid;
	struct VolumeStatus * Status;
	struct BBS * Name, *OfflineMsg, *MOTD;
{
	register struct r_packet *z_pb;
	static int z_op = VICEGETVOLUMESTATUS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &Vid))
	     || (!xdr_VolumeStatus(&z_pb->xdrs, Status))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, MOTD))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_VolumeStatus(&z_pb->xdrs, Status))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, MOTD))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceSetVolumeStatus(z_conn, Vid, Status, Name, OfflineMsg, MOTD)
	register struct r_connection *z_conn;
	long Vid;
	struct VolumeStatus * Status;
	struct BBS * Name, *OfflineMsg, *MOTD;
{
	register struct r_packet *z_pb;
	static int z_op = VICESETVOLUMESTATUS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &Vid))
	     || (!xdr_VolumeStatus(&z_pb->xdrs, Status))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, MOTD))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_VolumeStatus(&z_pb->xdrs, Status))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, MOTD))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceDisconnectFS(z_conn)
	register struct r_connection *z_conn;
{
	register struct r_packet *z_pb;
	static int z_op = VICEDISCONNECTFS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceGetTime(z_conn, Seconds, USeconds)
	register struct r_connection *z_conn;
	u_long * Seconds, *USeconds;
{
	register struct r_packet *z_pb;
	static int z_op = VICEGETTIME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_u_long(&z_pb->xdrs, Seconds))
	     || (!xdr_u_long(&z_pb->xdrs, USeconds))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceGetMessage(z_conn, MessageNumber, Message)
	register struct r_connection *z_conn;
	long MessageNumber;
	struct BBS * Message;
{
	register struct r_packet *z_pb;
	static int z_op = VICEGETMESSAGE;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &MessageNumber))
	     || (!xdr_BBS(&z_pb->xdrs, Message))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_BBS(&z_pb->xdrs, Message))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceGetStatistics(z_conn, Statistics)
	register struct r_connection *z_conn;
	ViceStatistics * Statistics;
{
	register struct r_packet *z_pb;
	static int z_op = VICEGETSTATISTICS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceStatistics(&z_pb->xdrs, Statistics))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatistics(&z_pb->xdrs, Statistics))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceCheckToken(z_conn, id, token)
	register struct r_connection *z_conn;
	long id;
	struct CBS * token;
{
	register struct r_packet *z_pb;
	static int z_op = VICECHECKTOKEN;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &id))
	     || (!xdr_CBS(&z_pb->xdrs, token))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceGetVolumeInfo(z_conn, Vid, Info)
	register struct r_connection *z_conn;
	char * Vid;
	struct VolumeInfo * Info;
{
	register struct r_packet *z_pb;
	static int z_op = VICEGETVOLUMEINFO;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Vid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_VolumeInfo(&z_pb->xdrs, Info))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceEnableGroup(z_conn, GroupName)
	register struct r_connection *z_conn;
	char * GroupName;
{
	register struct r_packet *z_pb;
	static int z_op = VICEENABLEGROUP;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_wrapstring(&z_pb->xdrs, &GroupName))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceDisableGroup(z_conn, GroupName)
	register struct r_connection *z_conn;
	char * GroupName;
{
	register struct r_packet *z_pb;
	static int z_op = VICEDISABLEGROUP;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_wrapstring(&z_pb->xdrs, &GroupName))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceSetRootVolume(z_conn, Volume)
	register struct r_connection *z_conn;
	char * Volume;
{
	register struct r_packet *z_pb;
	static int z_op = VICESETROOTVOLUME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Volume))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceFetchP(z_conn, Fid, BidFid, Request, Bulk, AccessList, OptionalData, Status)
	register struct r_connection *z_conn;
	struct ViceFid * Fid, *BidFid;
	long Request;
	struct BD * Bulk;
	struct BBS * AccessList, *OptionalData;
	struct ViceStatus * Status;
{
	register struct r_packet *z_pb;
	static int z_op = VICEFETCHP;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_ViceFid(&z_pb->xdrs, BidFid))
	     || (!xdr_long(&z_pb->xdrs, &Request))
	     || (!xdr_BD(&z_pb->xdrs, Bulk))
	     || (!xdr_BBS(&z_pb->xdrs, AccessList))
	     || (!xdr_BBS(&z_pb->xdrs, OptionalData))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_BBS(&z_pb->xdrs, AccessList))
	     || (!xdr_BBS(&z_pb->xdrs, OptionalData))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceStoreP(z_conn, Fid, Request, AccessList, OptionalData, Bulk, Status, Length)
	register struct r_connection *z_conn;
	struct ViceFid * Fid;
	long Request, Length;
	struct CBS * AccessList;
	struct BBS * OptionalData;
	struct BD * Bulk;
	struct ViceStatus * Status;
{
	register struct r_packet *z_pb;
	static int z_op = VICESTOREP;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))
	     || (!xdr_long(&z_pb->xdrs, &Request))
	     || (!xdr_CBS(&z_pb->xdrs, AccessList))
	     || (!xdr_BBS(&z_pb->xdrs, OptionalData))
	     || (!xdr_BD(&z_pb->xdrs, Bulk))
	     || (!xdr_ViceStatus(&z_pb->xdrs, Status))
	     || (!xdr_long(&z_pb->xdrs, &Length))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatus(&z_pb->xdrs, Status))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceRemoveCallBackBulk(z_conn, fids, nfids)
	register struct r_connection *z_conn;
	struct ViceFid * fids;
	long nfids;
{
	register struct r_packet *z_pb;
	static int z_op = VICEREMOVECALLBACKBULK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_array(&z_pb->xdrs, (caddr_t *) &fids, (u_int *) &nfids, FIDS_MAXSIZE, sizeof(*fids), xdr_ViceFid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int RViceExtendLock(z_conn, Fid)
	register struct r_connection *z_conn;
	struct ViceFid * Fid;
{
	register struct r_packet *z_pb;
	static int z_op = VICEEXTENDLOCK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_ViceFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}


int AFS_FetchData(z_conn, Fid, Bulk, Segment, OptionalData, OutStatus, CallBack)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	BD * Bulk;
	long Segment;
	BBS * OptionalData;
	AFSFetchStatus * OutStatus;
	AFSCallBack * CallBack;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_FETCHDATA;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))
	     || (!xdr_BD(&z_pb->xdrs, Bulk))
	     || (!xdr_long(&z_pb->xdrs, &Segment))
	     || (!xdr_BBS(&z_pb->xdrs, OptionalData))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_BBS(&z_pb->xdrs, OptionalData))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_pb->xdrs, CallBack))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_FetchACL(z_conn, Fid, AccessList, OutStatus)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	AFSAccessList * AccessList;
	AFSFetchStatus * OutStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_FETCHACL;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))
	     || (!xdr_AFSAccessList(&z_pb->xdrs, AccessList))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSAccessList(&z_pb->xdrs, AccessList))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_FetchStatus(z_conn, Fid, OutStatus, CallBack)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	AFSFetchStatus * OutStatus;
	AFSCallBack * CallBack;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_FETCHSTATUS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))
	     || (!xdr_AFSCallBack(&z_pb->xdrs, CallBack))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_StoreData(z_conn, Fid, InStatus, Segment, Length, Bulk, OptionalData, OutStatus)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	AFSStoreStatus * InStatus;
	long Segment, Length;
	BD * Bulk;
	BBS * OptionalData;
	AFSFetchStatus * OutStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_STOREDATA;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_pb->xdrs, InStatus))
	     || (!xdr_long(&z_pb->xdrs, &Segment))
	     || (!xdr_long(&z_pb->xdrs, &Length))
	     || (!xdr_BD(&z_pb->xdrs, Bulk))
	     || (!xdr_BBS(&z_pb->xdrs, OptionalData))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_StoreACL(z_conn, Fid, InStatus, AccessList, OutStatus)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	AFSStoreStatus * InStatus;
	AFSAccessList * AccessList;
	AFSFetchStatus * OutStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_STOREACL;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_pb->xdrs, InStatus))
	     || (!xdr_AFSAccessList(&z_pb->xdrs, AccessList))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_StoreStatus(z_conn, Fid, InStatus, OutStatus)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_STORESTATUS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))
	     || (!xdr_AFSStoreStatus(&z_pb->xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_RemoveFile(z_conn, DirFid, Name, OutStatus)
	register struct r_connection *z_conn;
	AFSFid * DirFid;
	char * Name;
	AFSFetchStatus * OutStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_REMOVEFILE;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, DirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_CreateFile(z_conn, DirFid, Name, InStatus, OutFid, OutFidStatus, OutDirStatus, CallBack)
	register struct r_connection *z_conn;
	AFSFid * DirFid, *OutFid;
	char * Name;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
	AFSCallBack * CallBack;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_CREATEFILE;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, DirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_AFSStoreStatus(&z_pb->xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFid(&z_pb->xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_pb->xdrs, CallBack))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_Rename(z_conn, OldDirFid, OldName, NewDirFid, NewName, OutOldDirStatus, OutNewDirStatus)
	register struct r_connection *z_conn;
	AFSFid * OldDirFid, *NewDirFid;
	char * OldName, *NewName;
	AFSFetchStatus * OutOldDirStatus, *OutNewDirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_RENAME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, OldDirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &OldName))
	     || (!xdr_AFSFid(&z_pb->xdrs, NewDirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &NewName))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutOldDirStatus))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutNewDirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_Symlink(z_conn, DirFid, Name, LinkContents, InStatus, OutFid, OutFidStatus, OutDirStatus)
	register struct r_connection *z_conn;
	AFSFid * DirFid, *OutFid;
	char * Name, *LinkContents;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_SYMLINK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, DirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_wrapstring(&z_pb->xdrs, &LinkContents))
	     || (!xdr_AFSStoreStatus(&z_pb->xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFid(&z_pb->xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutDirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_Link(z_conn, DirFid, Name, ExistingFid, OutFidStatus, OutDirStatus)
	register struct r_connection *z_conn;
	AFSFid * DirFid, *ExistingFid;
	char * Name;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_LINK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, DirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_AFSFid(&z_pb->xdrs, ExistingFid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutDirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_MakeDir(z_conn, DirFid, Name, InStatus, OutFid, OutFidStatus, OutDirStatus, CallBack)
	register struct r_connection *z_conn;
	AFSFid * DirFid, *OutFid;
	char * Name;
	AFSStoreStatus * InStatus;
	AFSFetchStatus * OutFidStatus, *OutDirStatus;
	AFSCallBack * CallBack;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_MAKEDIR;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, DirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))
	     || (!xdr_AFSStoreStatus(&z_pb->xdrs, InStatus))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFid(&z_pb->xdrs, OutFid))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutFidStatus))
	     || (!xdr_AFSFetchStatus(&z_pb->xdrs, OutDirStatus))
	     || (!xdr_AFSCallBack(&z_pb->xdrs, CallBack))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_RemoveDir(z_conn, DirFid, Name, OutDirStatus)
	register struct r_connection *z_conn;
	AFSFid * DirFid;
	char * Name;
	AFSFetchStatus * OutDirStatus;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_REMOVEDIR;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, DirFid))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Name))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_AFSFetchStatus(&z_pb->xdrs, OutDirStatus))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_SetLock(z_conn, Fid, Type)
	register struct r_connection *z_conn;
	AFSFid * Fid;
	ViceLockType Type;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_SETLOCK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))
	     || (!xdr_ViceLockType(&z_pb->xdrs, &Type))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_ExtendLock(z_conn, Fid)
	register struct r_connection *z_conn;
	AFSFid * Fid;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_EXTENDLOCK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_ReleaseLock(z_conn, Fid)
	register struct r_connection *z_conn;
	AFSFid * Fid;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_RELEASELOCK;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_AFSFid(&z_pb->xdrs, Fid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_GetStatistics(z_conn, Statistics)
	register struct r_connection *z_conn;
	ViceStatistics * Statistics;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_GETSTATISTICS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_ViceStatistics(&z_pb->xdrs, Statistics))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_GiveUpCallBacks(z_conn, Fids_Array, NumOfFids, CallBacks_Array, NumOfCallBacks)
	register struct r_connection *z_conn;
	AFSFid * Fids_Array;
	long NumOfFids, NumOfCallBacks;
	AFSCallBack * CallBacks_Array;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_GIVEUPCALLBACKS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_array(&z_pb->xdrs, (caddr_t *) &Fids_Array, (u_int *) &NumOfFids, FIDS_ARRAY_MAXSIZE, sizeof(*Fids_Array), xdr_AFSFid))
	     || (!xdr_array(&z_pb->xdrs, (caddr_t *) &CallBacks_Array, (u_int *) &NumOfCallBacks, CALLBACKS_ARRAY_MAXSIZE, sizeof(*CallBacks_Array), xdr_AFSCallBack))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_GetVolumeInfo(z_conn, Volumeid, Volumeinfo)
	register struct r_connection *z_conn;
	char * Volumeid;
	VolumeInfo * Volumeinfo;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_GETVOLUMEINFO;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_wrapstring(&z_pb->xdrs, &Volumeid))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_VolumeInfo(&z_pb->xdrs, Volumeinfo))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_GetVolumeStatus(z_conn, Volumeid, Volumestatus, Name, OfflineMsg, Motd)
	register struct r_connection *z_conn;
	long Volumeid;
	VolumeStatus * Volumestatus;
	BBS * Name, *OfflineMsg, *Motd;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_GETVOLUMESTATUS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &Volumeid))
	     || (!xdr_VolumeStatus(&z_pb->xdrs, Volumestatus))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, Motd))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_VolumeStatus(&z_pb->xdrs, Volumestatus))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, Motd))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_SetVolumeStatus(z_conn, Volumeid, Volumestatus, Name, OfflineMsg, Motd)
	register struct r_connection *z_conn;
	long Volumeid;
	VolumeStatus * Volumestatus;
	BBS * Name, *OfflineMsg, *Motd;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_SETVOLUMESTATUS;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &Volumeid))
	     || (!xdr_VolumeStatus(&z_pb->xdrs, Volumestatus))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, Motd))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_VolumeStatus(&z_pb->xdrs, Volumestatus))
	     || (!xdr_BBS(&z_pb->xdrs, Name))
	     || (!xdr_BBS(&z_pb->xdrs, OfflineMsg))
	     || (!xdr_BBS(&z_pb->xdrs, Motd))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_GetRootVolume(z_conn, VolumeName)
	register struct r_connection *z_conn;
	BBS * VolumeName;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_GETROOTVOLUME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_BBS(&z_pb->xdrs, VolumeName))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_BBS(&z_pb->xdrs, VolumeName))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_CheckToken(z_conn, ViceId, token)
	register struct r_connection *z_conn;
	long ViceId;
	CBS * token;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_CHECKTOKEN;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))
	     || (!xdr_long(&z_pb->xdrs, &ViceId))
	     || (!xdr_CBS(&z_pb->xdrs, token))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

int AFS_GetTime(z_conn, Seconds, USeconds)
	register struct r_connection *z_conn;
	u_long * Seconds, *USeconds;
{
	register struct r_packet *z_pb;
	static int z_op = AFS_GETTIME;
	int z_result;

	z_pb = r_AllocSendPacket(r_packetSize);
	if (z_pb == 0) goto fail;
	if ((!xdr_int(&z_pb->xdrs, &z_op))) {
		z_result = RXGEN_CC_MARSHAL;
		goto fail;
	}

	z_pb = r_SendPacket(z_conn, z_pb);
	if (z_pb == (struct r_packet *) 0) goto fail;
	if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
	if ((!xdr_u_long(&z_pb->xdrs, Seconds))
	     || (!xdr_u_long(&z_pb->xdrs, USeconds))) {
		z_result = RXGEN_CC_UNMARSHAL;
		goto fail;
	}

	r_FreePacket(z_pb);
	return z_result;
fail:
	if (z_pb != 0) r_FreePacket(z_pb);
	return -1;
}

