
/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pcif.h 12.0$ */
/* $ACIS:pcif.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/pcif.h,v $ */

#ifndef _PCIF_
#define _PCIF_

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char    *rcsidpcif = "$Header:pcif.h 12.0$";
#endif

#define R_WIND1 0		/* window pointer 1 in ROMP memory */
#define R_WIND2 1		/* window pointer 2 in ROMP memory */
#define R_WIND3 2		/* window pointer 3 in ROMP memory */
#define R_WIND4 3		/* window pointer 4 in ROMP memory */
#define P_WIND128 4		/* 128k window into PC memory */
#define P_WIND512 5		/* 512k window into PC memory */
#define P_CTRL	6		/* PCIF control register */
#define P_STAT	7		/* PCIF status register */
#define P_BASE	8		/* base address register */
#define P_ECCR	9		/* ECC register */
#define P_CONF	10		/* PCIF configuration register */
#define R_DIAG	11		/* ROMP diagnostics */
#define R_CLOCK 12		/* ROMP clock register */
#define R_CTRL	13		/* ROMP control register */
#define R_INTR	14		/* PC -> ROMP interrupt register */
#define R_STAT	15		/* ROMP status register */

/* Bit definitions for the PCIF control register */

#define P_BUF1	0x00		/* buffer mode for window 1 */
#define P_BUF2	0x01		/* buffer mode for window 2 */
#define P_BUF3	0x02		/* buffer mode for window 3 */
#define P_BUF4	0x03		/* buffer mode for window 4 */
#define P_ECCON 0x04		/* ECC enable */
#define P_DIAG	0x05		/* diagnostic mode on */
#define P_2WIND 0x06		/* use 2 windows */
#define P_4WIND 0x07		/* use 4 windows */

/* Bit definitions for the PCIF status register */
#define P_OIP	0x80		/* ROMP operation in progress */
#define P_ECCE	0x40		/* ECC error */
#define P_ICA	0x20		/* illegal ROMP address */
#define P_IAP	0x10		/* illegal adderss mapping */
#define P_PCT	0x08		/* PC time-out */
#define P_MBE	0x04		/* multiple bit error */
#define P_PBP	0x02		/* PC bus preemption */
#define P_OK	0x00		/* everything is O.K. */

/*  Bit definitions for the PCIF configuration regester */
#define P_ATM	0x80		/* AT mode (ROMP present) */
#define P_TCE	0x40		/* timeout count enabled */
#define P_PAR	0x20		/* parity mode enabled */

/*  Bit definitions for the  ROMP clock register */
#define R_CPOR	0x00		/* clock POR */
#define R_RSET	0x01		/* ROMP reset */
#define R_DBS	0x02		/* debug stop */
#define R_STEP	0x03		/* ROMP step */
#define R_ISE	0x04		/* instruction step enable */
#define R_FRW	0x05		/* regester file read/write */
#define R_SCAN	0x06		/* ROMP scangate in */
#define R_T1T3	0x07		/* ROMP T1,T3 disable */

/* Bit definitions for the ROMP control register */
#define R_HOLD	0x00		/* PC Hold RSC */
#define R_IPLC	0x01		/* IPL Complete */
#define R_MM	0x02		/* Master Mode */
#define R_INTL	0x04		/* Interleaved mode */
#define R_IREQ	0x06		/* PC Interrupt request */
#define R_IENAB 0x07		/* PC Interrupt enable */

/* Bit definitions for the PC -> ROMP interrupt register */
#define R_INT0	0x00		/* level 0 interrupt request */
#define R_INT1	0x01		/* level 1 interrupt request */
#define R_INT2	0x02		/* level 2 interrupt request */
#define R_INT3	0x03		/* level 3 interrupt request */
#define R_INT4	0x04		/* level 4 interrupt request */
#define R_INT5	0x05		/* level 5 interrupt request */
#define R_INT6	0x06		/* level 6 interrupt request */
#define R_INT7	0x07		/* trap    interrupt request */

/* Bit definitions for the ROMP status register */
#define R_IPLR	0x80		/* IPL ready */
#define R_CLKST 0x40		/* Clock stopped */
#define R_WAIT	0x20		/* ROMP wait */
#define R_FAIL	0x10		/* ROMP failure */
#define R_SYNC	0x08		/* ROMP sync */
#define R_ICMP	0x04		/* Instruction Complete */
#define R_DGO	0x02		/* ROMP  DGO */
#define R_STOP	0x01		/* ROMP Stop */


#define SETBIT(reg,bit) IOOUT((reg),(bit|8))	/* set a reg bit on */
#define RSETBIT(reg,bit) IOOUT((reg),(bit))	/* set a reg bit off */
#define RSETALL(reg) IOOUT((reg),0x10)	/* reset all bits */


#define BIOS_STAT_FAIL	0x00FF	/* BIOS return codes for HD and FD */
#define BIOS_STAT_ERR	0x00E0
#define BIOS_WR_FAULT  	0x00CC
#define BIOS_UNDEF_ERR	0x00BB
#define BIOS_NOT_RDY	0x00AA
#define BIOS_TO			0x0080
#define BIOS_SEEK_FAIL	0x0040
#define BIOS_CTRL_FAIL	0x0020
#define BIOS_ECC_OK		0x0011
#define BIOS_CRC_ERR	0x0010
#define BIOS_DMA_ARB	0x000F
#define BIOS_CTRL_AM	0x000E
#define BIOS_INVAL_SEC	0x000D
#define BIOS_INVAL_MED	0x000C
#define BIOS_BAD_TRACK	0x000B
#define BIOS_BAD_SECTOR	0x000A
#define BIOS_DMA_BNDRY	0x0009
#define BIOS_DMA_OVRUN	0x0008
#define BIOS_PARAM_FAIL	0x0007
#define BIOS_DSKT_CHG	0x0006
#define BIOS_RESET_FAIL	0x0005
#define BIOS_REC_NFND	0x0004
#define BIOS_WRT_PROT   0x0003
#define BIOS_BAD_ADDR	0x0002
#define BIOS_BAD_CMD	0x0001

#define BIOS_ERROR		0x8000
#define BIOS_RET_OK    	0x1000

#define PC_MAST_8259	0x20	/* master 8259 interrupt controller */
#define PC_MAST_MASK	0x21	/* master 8259 interrupt mask */
#define PC_SLAVE_8259	0xa0	/* slave 8259 interrupt controller */
#define PC_SLAVE_MASK	0xa1	/* slave 8259 interrupt mask */
#define PC_ALL_INTS 	0xffff	/* slave 8259 interrupt mask */

#include "../pc_code/cbcb.h"

struct kbdata {
	u_char          kbsc;
	u_char          kbstatus;
	u_char          cmd_dest;	/* destination (port address)	 */
	u_char          cmd_code;	/* keyboard command code	 */
	u_char          fwd_int;/* kbd interrupt forwarding flag:	    */
	/* 1 = interrupts forwarded from PS/2     */
	/* 0 = interrupts not forwarded from PS/2 */
};

struct msdata {
	u_char          status;	/* mouse data presence, yes = 1, no = 0	 */
	u_char          type;	/* data report (0) or command response (1) */
	u_char          exit_stat;	/* command exit status (CY)		 */
	/* success = 0, failure = 1		 */
	u_char          error;	/* command error code (AH), no error =0	 */
	u_char          report[3];	/* data report or command bytes
					 * requested */
};

struct pcms_cmd {
	u_char          cmd;	/* mouse command code (AL)	 */
	u_char          param;	/* command parameter (BH)	 */
};

struct pcspk_cmd {		/* speaker command	 */
	u_char          vol;	/* volume (either 0 or nonzero) */
	u_char          freqhigh;	/* frequency MSB	 */
	u_char          freqlow;/* frequency LSB	 */
	u_short         duration;
};

struct spkdata {
	u_char          status;
};

struct pc_dpl {			/* disk parameter list for FD and HD */
	u_short         op_code;/* operation code */
	u_short         drive;	/* drive number (0,1) FD   (80,81) HD */
	u_short         head;	/* head or track number */
	u_short         cyl;	/* cylinder number */
	u_short         sector;	/* sector number */
	u_short         number;	/* number of sectors to operate on */
	u_long          atr_addr[32];	/* tcw entries */
	u_short         atr_cnt[32];
};

struct pc_stat {
	u_short         return_code;
	u_short         pad;
	int             badblock;
};

struct mask_int {
	char            master;
	char            slave;
};

struct int_vec {
	char            vec_map[16];
};
/*
 * WINDOW SIZES & COUNTS
 */
#define	PCIF_SIZE	(1024*1024)
#define	PCIF_512K_SIZE	(512*1024)
#define	PCIF_128K_SIZE	(128*1024)
#define PCIF_NUMBER_128K (3)
#define	PCIF_64K_SIZE	(64*1024)
#define PCIF_NUMBER_64K (2)

/*
 * Window offsets from PCIF base address
 */
#define PCIF_512_FW_OFFSET	0
#define PCIF_128_FW_OFFSET	(PCIF_512_FW_OFFSET+PCIF_512K_SIZE)
#define PCIF_128_HW_OFFSET	(PCIF_128_FW_OFFSET+PCIF_128K_SIZE)
#define PCIF_128_B_OFFSET	(PCIF_128_HW_OFFSET+PCIF_128K_SIZE)
#define PCIF_IO_HW_OFFSET	(PCIF_128_B_OFFSET+PCIF_128K_SIZE)
#define PCIF_IO_B_OFFSET	(PCIF_IO_HW_OFFSET+PCIF_64K_SIZE)

/* PS/2 Control Registers */
#define	PCIF_POS_REG	0x102

struct pcif_reg {
	char            romp_wind1;	/* window pointer 1 in ROMP memory */
	char            romp_wind2;	/* window pointer 2 in ROMP memory */
	char            romp_wind3;	/* window pointer 3 in ROMP memory */
	char            romp_wind4;	/* window pointer 4 in ROMP memory */
	char            pc_wind128;	/* Romp to PC 128K window pointer  */
	char            pc_wind512;	/* Romp to PC 512K window pointer  */
	char            pcif_ctrl;	/* PCIF control regester	    */
	char            pcif_stat;	/* PCIF status register 	    */
	char            pcif_base;	/* base address regester 	    */
	char            pcif_ecc;	/* ECC regester 		    */
	char            pcif_conf;	/* PCIF configuration regester     */
	char            pcif_reserved;	/* This register is reserved       */
	char            romp_clock;	/* ROMP clock regester 	    */
	char            romp_ctrl;	/* ROMP control register 	    */
	char            romp_intr;	/* PC -> ROMP interrupt register   */
	char            romp_stat;	/* ROMP status register 	    */
};


#ifdef KERNEL

extern int      pcif_addr, pcif_512_fw, pcif_128_fw, pcif_128_hw, pcif_128_b, pcif_io_b, pcif_io_hw;

extern struct postconfig config;	/* configuration at 0x800 */
extern ushort   mem_size;
extern ushort   pcif_base;
extern long     cbcb_addr;
extern ushort   equip;
extern ushort   ega_info;
extern struct cbcb *cbcb;
extern struct pcif_reg *pcif_reg;
extern char    *pcvec_map;
int pc_copy_in;				/* bytes copied in from PC */
int pc_copy_out;			/* bytes copied out to PC */
#endif KERNEL

#define KBIRQ 0x01
#define MSIRQ 0x01
#define HDIRQ 0x05
#define FDIRQ 0x06
#define UBIRQ 0x03
#define TRIRQ 0x02

#define KBSTAT_HOT_KEY	0x03	/* hot key occurence */

/* These are provided for x_emul */

#define W2SAVE_SCREEN_SC	0x82	/* fake scan code to save screen */
#define W2RESTORE_SCREEN_SC	0x83	/* fake scan code to restore screen */
#endif
