/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1974
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:param.c 12.0$ */
/* $ACIS:param.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/conf/RCS/param.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header:param.c 12.0$";
#endif

/*
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)param.c	7.1 (Berkeley) 6/5/86
 */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/socket.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#ifndef VFS
#include "../h/inode.h"
#else !VFS
#include "../h/vnode.h"
#endif !VFS
#include "../h/file.h"
#include "../h/callout.h"
#include "../h/clist.h"
#include "../h/cmap.h"
#include "../h/mbuf.h"
#ifndef VFS
#include "../h/quota.h"
#endif !VFS
#include "../h/kernel.h"
#ifdef VFS
#include "../ufs/inode.h"
#include "../ufs/quota.h"
#include "../specfs/fifo.h"

#include "../h/map.h"
#endif VFS

/*
 * System parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DHZ=xx -DTIMEZONE=x -DDST=x -DMAXUSERS=xx
 * (Actually, the above comment is wrong; HZ is no longer part of the
 * config grammer so HZ is defined here.  There really should be a
 * param.c.machine or some other way of picking up HZ; perhaps a param.c
 * and a param_machdep.c.machine that then becomes part of the kernel?)
 */

#ifdef vax
#define HZ 100
#endif
#ifdef ibm032
#define HZ 100
#endif
#ifdef	ibm370
#define	HZ	10
#endif

#ifdef VICE
#ifndef VICE_CLIENTS
#define VICE_CLIENTS 0
#endif
#endif

int	hz = HZ;
int	tick = 1000000 / HZ;
int	tickadj = 240000 / (60 * HZ);		/* can adjust 240ms in 60s */
struct	timezone tz = { TIMEZONE, DST };
#ifdef VICE
#define	NPROC (20 + 10 * MAXUSERS + VICE_CLIENTS)
#else
#define	NPROC (20 + 8 * MAXUSERS)
#endif
int	nproc = NPROC;
#ifdef VICE
#define	NTEXT	(36 + 4 * MAXUSERS)
int	ntext = NTEXT;
#define NINODE (((NPROC + 16 + MAXUSERS) + 8*VICE_CLIENTS) + 32)
int	ninode = NINODE;
int	nchsize = NINODE * 11 / 10;
int	nfile = NTEXT + 16 * (NPROC + 16 + MAXUSERS + 4*VICE_CLIENTS) / 10 + 32;
int	nrmt_wd = (NPROC / 2);
#else VICE
int	ntext = 36 + MAXUSERS;
#define NINODE ((NPROC + 16 + MAXUSERS) + 32)
int	ninode = NINODE;
int	nchsize = NINODE * 11 / 10;
int	nfile = 16 * (NPROC + 16 + MAXUSERS) / 10 + 32;
#endif VICE
int	ncallout = 16 + NPROC;
int	nclist = 60 + 12 * MAXUSERS;
#ifdef VFS
int	nport = NPROC / 2;
int	ncsize = (NPROC + 16 + MAXUSERS) + 32; /* name cache size */
#endif VFS
int     nmbclusters = NMBCLUSTERS;
#ifdef QUOTA
int	nquota = (MAXUSERS * 9)/7 + 3;
int	ndquot = NINODE + (MAXUSERS * NMOUNT) / 4;
#endif

#ifdef VFS
#ifdef INET
#define	NETSLOP	20			/* for all the lousy servers*/
#else
#define	NETSLOP	0
#endif
#endif VFS

/*
 * These are initialized at bootstrap time
 * to values dependent on memory size
 */
int	nbuf, nswbuf;

/*
 * These have to be allocated somewhere; allocating
 * them here forces loader errors if this file is omitted
 * (if they've been externed everywhere else; hah!).
 */
struct	proc *proc, *procNPROC;
struct	text *text, *textNTEXT;
struct	inode *inode, *inodeNINODE;
struct	file *file, *fileNFILE;
struct 	callout *callout;
struct	cblock *cfree = 0; /* XXX Hack to fix NCS symbol move */
#ifdef NCS
#ifndef VFS
#undef KERNEL
#include "../h/mount.h"
struct mount mount[NMOUNT] = 0;
#define KERNEL
#endif !VFS
struct timeval time = {0,0};
#endif NCS		   /* XXX end of Hack */
struct	buf *buf, *swbuf;
#ifdef VFS
short	*swsize;
int	*swpf;
#endif VFS
char	*buffers;
struct	cmap *cmap, *ecmap;
struct	namecache *namecache;
#ifdef QUOTA
struct	quota *quota, *quotaNQUOTA;
struct	dquot *dquot, *dquotNDQUOT;
#endif
int	procSIZE = sizeof (struct proc);
int	userSIZE = sizeof (struct user);
int	textSIZE = sizeof (struct text);
#ifdef VFS
/* initialize SystemV named-pipe (and pipe()) information structure */
struct fifoinfo fifoinfo = {
      FIFOBUF,
      FIFOMAX,
      FIFOBSZ,
      FIFOMNB
};
#endif VFS
int maxuprc = MAXUPRC;
