/*
 * USC-ACSC UNIX Monitor
 *
 * $Header:thread.h 12.2$
 * $ACIS:thread.h 12.2$
 * $Source: /ibm/acis/usr/sys/os2code/RCS/thread.h,v $
 * Copyright University of Southern California, 1988
 */

/* time critical threads */
#define PRI_KEY_THREAD  31
#define	PRI_VGA_THREAD	30
#define PRI_MOUSE_THREAD  10
#define	PRI_FD_THREAD	5
#define	PRI_MAIN_THREAD	12
#define	PRI_HD_THREAD	16
#define	PRI_MC_THREAD	15
#define	PRI_CLOCK_THREAD	14

/* main process thread */
#define PRI_MAIN_LOOP	31

#define	SINGLE_THREAD	2
#define	THIS_THREAD	0
#define	TIME_CRITICAL	3
#define REGULAR		2
#define IDLE_TIME	1

/* Macro to set the priority of a thread. 
 * All threads are assumed to be time critical.
 */
#define SET_THREAD_PRIORITY(p)	DOSSETPRTY(SINGLE_THREAD,TIME_CRITICAL,p,\
								THIS_THREAD)
#define SET_MEDIUM_PRIORITY(p)	DOSSETPRTY(SINGLE_THREAD,REGULAR,p, \
								THIS_THREAD)
#define SET_LOW_PRIORITY(p)	DOSSETPRTY(SINGLE_THREAD,REGULAR,p, \
								THIS_THREAD)

/*
 * disable sleep wakup for now...
 */
#define MAIN_POLL	1
#define POLL_MOUSE	1
