/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:aout.h 12.0$ */
/* $ACIS:aout.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/aout.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char    *rcsidaout = "$Header:aout.h 12.0$";
#endif

/*
 * Format of an a.out header
 */

struct AOUT
{				/* a.out header */
	long            a_magic;/* magic number */
	long            a_text;	/* size of text segment */
	long            a_data;	/* size of initialized data */
	long            a_bss;	/* size of uninitialized data */
	long            a_syms;	/* size of symbol table */
	long            a_entry;/* entry point */
	long            a_trsize;	/* size of text relocation */
	long            a_drsize;	/* size of data relocation */
};

#define OMAGIC	 0407
#define N_BADMAG(x) ((x).a_magic != OMAGIC)
#define N_TXTOFF   sizeof(struct exec)
#define N_SYMOFF(x) (N_TXTOFF + (x).a_text + (x).a_data + (x).a_trsize + (x).a_drsize)
#define N_STROFF(x) (N_SYMOFF(x) + (x).a_syms)
