/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:mc.h 12.1$ */
/* $ACIS:mc.h 12.1$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/mc.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidmc = "$Header:mc.h 12.1$";
#endif

/*
 * commands to driver
 */
#define MC_CMD_OPEN		1
#define MC_CMD_CLOSE		2
#define MC_CMD_XMIT		3
#define MC_CMD_RCVEN		4
#define MC_CMD_CANRCV		5
#define MC_CMD_NOP		6

#define MC_CMD_MAX		6
#define MAXMCLEN	MAX_PAC_LEN		/* max packet length */

#define MC_OPEN_STATE		1
#define MC_XMIT_ENABLE		2	/* transmit int enable */
#define MC_RECV_ENABLE		4	/* recv int enable */
#define MC_XMIT_BUSY		8	/* transmit busy */
#define MC_RECV_BUSY		0x10	/* receive busy */
#define MC_XMIT_DONE		0x20	/* xmit done */
#define MC_RECV_DONE		0x40	/* recv done (data available) */

#define MC_RESULT_NONE	0
#define MC_RESULT_OK	1
#define MC_RESULT_BAD	2

#define MC_RCV_INTR	1
#define MC_XMIT_INTR	2

struct mcdev {
char	state;		/* if opened or not */
char	cmd;		/* command from unix */

char	unit;		/* which unit we are */
char	result;		/* result for init, etc. commands */

char	addr[6];	/* pseudo ethernet address */
char	xstatus;	/* transmit status */
char	xmask;		/* who we will xmit to */

char	xcounter;	/* for timing out bad transmits */
char	xfill;		/* align */
u_short xlen;		/* transmit length */
u_short xlength;	/* "" byte swapped */
u_char	xbuff[MAXMCLEN];	/* the xmit data */
char	rstatus;	/* receive status */
char	rfill;
u_short	rlen;		/* receive length */
u_short rlength;	/*  "" byte swapped */
u_char	rbuff[MAXMCLEN];	/* receive data */
};


#define MCIRQ	13	/* our IRQ level on romp level 4 */

#define MCDEBUG  0x80000L

#if NCPU > 2
#define MCFAR far
#else
#define MCFAR
#endif
