/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:trace.h 12.0$ */
/* $ACIS:trace.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/trace.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidtrace = "$Header:trace.h 12.0$";
#endif

/*
 * tracing data structures and information 
 * we log all interesting events into the tracebuffer
 */

#define TRACE_DATA	12	/* number of bytes of data allowed */

struct tracebuf
{
	u_char	type;		/* type of entry */
	u_char	fill;		/* make sure its aligned */
	u_short	time;		/* timestamp (from CMOS clock) */
				/* in seconds? */
	u_char info[TRACE_DATA];	/* the actual data */
};

#ifdef DEBUG
#define TRACE(type, info, size) if (tracing&(1<<(type))) trace(type, (char far *) info, size)
#else
#define TRACE(type, info, size)
#endif /* DEBUG */

/* type codes for trace structure above */
#define TRACE_CBCBQ	1	/* CBCB command queued */
#define TRACE_INT	2	/* deliver interrupt */
#define TRACE_QINT	3	/* queue interrupt */
#define TRACE_CBCB	4	/* CBCB command executed */
#define TRACE_DISK	5	/* DISK I/O */
#define TRACE_OPDISK	6	/* optical DISK I/O */
#define TRACE_UB	7	/* ethernet */
#define TRACE_TAPE	8	/* tape drive */
#define TRACE_CBCBI	9	/* CBCB interrupt info */
#define TRACE_HDWINT	10	/* Hardware int info */
#define TRACE_KBDINT	11	/* keyboard int */
#define TRACE_ASY	12	/* ASY int */

#ifdef PC_CODE
extern struct tracebuf far *trace_ptr; /* start of the buffer */
extern struct tracebuf far *trace_buf; /* start of the buffer */
extern struct tracebuf far *trace_last; /* last entry in the buffer */
extern u_short tracing;		/* indicates if we're tracing or not */
#endif /* PC_CODE */
