/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:getchar.c 12.0$ */
/* $ACIS:getchar.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/getchar.c,v $ */

#ifndef lint
static char *rcsid = "$Header:getchar.c 12.0$";
#endif

#include "sari.h"
#include "com.h"

/*
 * getchar routine that uses the COM1 serial line interface.
 * this version was written before the actual keyboard driver
 * was written as it is much simpler.
 */

getchar()
{
	register int c;
	static init = 0;

	if (!init) {
		init_kbd();
		++init;
	}
	while ((in(COM1_LSR) & 01) == 0);
	c = in(COM1_RXB) & 0177;
	if (c == '\r')
		c = '\n';
	putchar(c);
	return (c);
}


LOCAL init_kbd()
{
	register int x;

	if (in(COM1_LCR) != 0)
		return;		       /* already set up ! don't change it */
	out(COM1_LCR, 0x80);	       /* enable for output to set baud rate */
	out(COM1_LSB, 0x18);	       /* 4800 baud */
	out(COM1_MSB, 0x00);	       /* set msb */
	out(COM1_LCR, 0x3e);	       /* 7 bits etc. */
	out(COM1_IER, 0x00);	       /* disable interrupts */
	x = in(COM1_RXB);
}
