/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:tty_conf.c 12.0$ */
/* $ACIS:tty_conf.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/sys/RCS/tty_conf.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header:tty_conf.c 12.0$";
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 */

/*      tty_conf.c      6.2     83/09/25        */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/ioctl.h"
#include "../h/tty.h"
#include "../h/conf.h"

int	nodev();
int	nulldev();

int	ttyopen(),ttylclose(),ttread(),ttwrite(),nullioctl(),ttstart();
int	ttymodem(), nullmodem(), ttyinput(), ttselect();

#include "bk.h"
#if NBK > 0
int	bkopen(),bkclose(),bkread(),bkinput(),bkioctl();
#endif NBK

#include "tb.h"
#if NTB > 0
int     tbopen(),tbclose(),tbread(),tbinput(),tbioctl(),tbselect();
#endif

#ifdef ibm032
#include "ap.h"
/* this is for the 3812 printer. */
#if NAP >0
int apopen(),apclose(),apread(),apwrite(),apioctl(),aprcvint(),apxmtint();
#endif

#include "ms.h"
#if NMS > 0
int	msdopen(),msdclose(),msdread(),msdinput(),msdioctl(),msdselect();
#endif
#endif

#include "sl.h"
#if NSL > 0
int	slopen(),slclose(),slinput(),sltioctl(),slstart();
#endif

struct	linesw linesw[] =
{
	/* l_open, l_close, l_read, l_write, l_ioctl,
	   l_rint, l_rend, l_meta, l_start, l_modem,
	   l_select					 */
	{
	ttyopen, ttylclose, ttread, ttwrite, nullioctl,	/* 0- OTTYDISC */
	ttyinput, nodev, nulldev, ttstart, ttymodem,
	ttselect,
	},
#if NBK > 0
	{
	bkopen, bkclose, bkread, ttwrite, bkioctl,	/* 1- NETLDISC */
	bkinput, nodev, nulldev, ttstart, nullmodem,
	ttselect,
	},
#else NBK
	{
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,
	nodev,
	},
#endif NBK
	{
	ttyopen, ttylclose, ttread, ttwrite, nullioctl,	/* 2- NTTYDISC */
	ttyinput, nodev, nulldev, ttstart, ttymodem,
	ttselect,
	},
#if NTB > 0
	{
	tbopen, tbclose, tbread, nodev, tbioctl,
	tbinput, nodev, nulldev, ttstart, nullmodem,	/* 3- TABLDISC */
	tbselect,				   },
#else
	{ nodev, nodev, nodev, nodev, nodev,
	  nodev, nodev, nodev, nodev, nodev,
	  nodev,				   },
#endif
	{ nodev, nodev, nodev, nodev, nodev,		/* 4- */
	  nodev, nodev, nodev, nodev, nodev,
	  nodev,				   },
#if defined(ibm032) && NMS > 0
	{ msdopen, msdclose, msdread, nodev, msdioctl,
	  msdinput, nodev, nulldev, ttstart, nullmodem,	/* 5 */
	  msdselect},
#else
	{ nodev, nodev, nodev, nodev, nodev,
	  nodev, nodev, nodev, nodev, nodev,
	  nodev },
#endif
	{ nodev, nodev, nodev, nodev, nodev,		/* 6 */
	  nodev, nodev, nodev, nodev, nodev,
	  nodev,				   },
#if defined(ibm032) && NAP >0 
	{apopen,apclose,apread,apwrite,apioctl,		/* 7 */
	 aprcvint,nodev,nodev,apxmtint,nodev,
	 ttselect},
#else
	{ nodev, nodev, nodev, nodev, nodev,
	  nodev, nodev, nodev, nodev, nodev,
	  nodev },
#endif
#if NSL > 0
	slopen, slclose, nodev, nodev, sltioctl,
	slinput, nodev, nulldev, slstart, nulldev,	/* 8- SLIPDISC */
#else
	nodev, nodev, nodev, nodev, nodev,
	nodev, nodev, nodev, nodev, nodev,
#endif
};

int	nldisp = sizeof (linesw) / sizeof (linesw[0]);

/*
 * Do nothing specific version of line
 * discipline specific ioctl command.
 */
/*ARGSUSED*/
nullioctl(tp, cmd, data, flags)
	struct tty *tp;
	char *data;
	int flags;
{

#ifdef lint
	tp = tp; data = data; flags = flags;
#endif
	return (-1);
}
