/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:part.h 12.0$ */
/* $ACIS:part.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/part.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidpart_atr = "$Header:part.h 12.0$";
#endif

#define BRPT_OFFSET 446

#define YorN(x) 	( x ? "Y" : "N" )

#define ND	2 /* maximum number of drives */
#define NP	4 /* maximum number of partitions */

#define NSYSTEMS 7

#define BOOTRECORD_BLOCK 0

#ifdef SWAPH			/* not depenent on other define changes */
#undef SWAPH
#undef SWAPW
#endif

#define SWAPH(n) ((((n)>>8)&0xff) | (((n)&0xff) << 8))
#define SWAPW(n) (SWAPH((n)>>16) | (SWAPH((n)) << 16))

/*
 * following structure describes the boot record partition table
 * entry on block zero of a hard disk.
 * Note that the high order bits of the cylinder number are stored
 * in the sector number.
 */
							
struct brpt_entry {			/* BOOT RECORD PARTITION TABLE ENTRY */
  	char 	boot_ind;		/* bootable indicator */
  	char 	start_hd;		/* starting head */
  	char 	start_sect;		/* starting sector */
  	char 	start_cyl;		/* starting cylinder */
  	char 	sys_ind; 		/* system indicator */
  	char 	end_hd;			/* ending head */
  	char 	end_sect;		/* ending sector */
  	char 	end_cyl; 		/* ending cylinder */
  	u_int  	rel_sect;		/* starting sector */
  	u_int  	num_sect;		/* partition length in sectors */
  	};

struct bootrecord {					/* BOOT RECORD */
  	struct brpt_entry t_entry[4]; 	/* one entry for each partition */
  	char signature[2];				/* boot record signature */
  	};

/*
 * following is software version of above partition table entry 
 * used internally by fdisk.
 */
struct partdata {			/* partition information (usable!) */
  	u_short	sysno;			/* index into array "systems" */
  	char	bootable;		/* bootable indicator */
	char	sysind;			/* system indicator  */
  	u_short	start;			/* starting cylinder */
  	char	starthead;		/*  ...	      head   */
  	char	startsect;		/*  ...       sector */
  	u_short	end;			/* ending cylinder   */
  	char	endhead;		/*  ...       head   */
  	char	endsect;		/*  ...       sector */
	u_int	relsect;		/* starting sector   */
	u_int	numsect;		/* partition length  */
  	};

struct system {				/* relevant operating system info */
  	char *name;				/* system name */
  	char id;				/* unique system identifier */
  	};
	
struct {
	struct {
		char    bootid;		/* field indicating partition is bootable */
	    char    shsc[3];	/* head, sector, cyl where partition starts */
	    char    sysid;		/* system ID field */
	    char    ehsc[3];	/* head, sector, cyl where partition ends */
	    long    relsect;	/* number of sectors preceeding partition */
	    long    numsect;	/* number of sectors allocated to a partition */
	    } pt[4];
       	u_short signature;
} ptable;

