/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:user.h 12.0$ */
/* $ACIS:user.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/h/RCS/user.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsiduser = "$Header:user.h 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)user.h	7.1 (Berkeley) 6/4/86
 */

#if defined(KERNEL) || defined(STANDALONE) || defined(STANDUTIL)
#include "../machine/pcb.h"
#include "dmap.h"
#include "time.h"
#include "resource.h"
#include "namei.h"
#else
#include <machine/pcb.h>
#include <sys/dmap.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/namei.h>
#endif

#ifdef VICE
typedef long Fid[3];	/* Vice II file identifier */
#endif

/*
 * Per process structure containing data that
 * isn't needed in core when the process is swapped out.
 */
 
#define	MAXCOMLEN	16		/* <= MAXNAMLEN, >= sizeof(ac_comm) */
 
struct	user {
	struct	pcb u_pcb;
	struct	proc *u_procp;		/* pointer to proc structure */
	int	*u_ar0;			/* address of users saved R0 */
	char	u_comm[MAXCOMLEN + 1];

/* syscall parameters, results and catches */
	int	u_arg[8];		/* arguments to current system call */
	int	*u_ap;			/* pointer to arglist */
	label_t	u_qsave;		/* for non-local gotos on interrupts */
	union {				/* syscall return values */
		struct	{
			int	R_val1;
			int	R_val2;
		} u_rv;
#define	r_val1	u_rv.R_val1
#define	r_val2	u_rv.R_val2
		off_t	r_off;
		time_t	r_time;
	} u_r;
	char	u_error;		/* return error code */
#ifdef ibm032
	char	u_calltype;
#endif
	char	u_eosys;		/* special action on end of syscall */

/* 1.1 - processes and protection */
#if !defined(VFS)
	uid_t	u_uid;			/* effective user id */
	uid_t	u_ruid;			/* real user id */
	gid_t	u_gid;			/* effective group id */
	gid_t	u_rgid;			/* real group id */
	gid_t	u_groups[NGROUPS];	/* groups, 0 terminated */
#else !VFS
	/*
	 * NOTE we are assumint a struct ucred * is the same as 2 uid_t
	 * (uid_t is short, struct ucred * is a long i
	 */
	struct ucred *u_cred;	/* user credentials (uid, gid, etc) */
	gid_t	u_dummy_group[NGROUPS+2];	/* two for u_gid & u_rgid */
#define u_uid		u_cred->cr_uid
#define u_gid		u_cred->cr_gid
#define u_groups	u_cred->cr_groups
#define u_ruid		u_cred->cr_ruid
#define u_rgid		u_cred->cr_rgid
#endif !VFS

/* 1.2 - memory management */
	size_t	u_tsize;		/* text size (clicks) */
	size_t	u_dsize;		/* data size (clicks) */
	size_t	u_ssize;		/* stack size (clicks) */
	struct	dmap u_dmap;		/* disk map for data segment */
	struct	dmap u_smap;		/* disk map for stack segment */
	struct	dmap u_cdmap, u_csmap;	/* shadows of u_dmap, u_smap, for
					   use of parent during fork */
	label_t u_ssave;		/* label variable for swapping */
	size_t	u_odsize, u_ossize;	/* for (clumsy) expansion swaps */
	time_t	u_outime;		/* user time at last sample */

/* 1.3 - signal management */
	int	(*u_signal[NSIG])();	/* disposition of signals */
	int	u_sigmask[NSIG];	/* signals to be blocked */
	int	u_sigonstack;		/* signals to take on sigstack */
	int	u_sigintr;		/* signals that interrupt syscalls */
	int	u_oldmask;		/* saved mask from before sigpause */
	int	u_code;			/* ``code'' to trap */
	struct	sigstack u_sigstack;	/* sp & on stack state variable */
#define	u_onstack	u_sigstack.ss_onstack
#define	u_sigsp		u_sigstack.ss_sp

/* 1.4 - descriptor management */
	struct	file *u_ofile[NOFILE];	/* file structures for open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	int	u_lastfile;		/* high-water mark of u_ofile */
#define	UF_EXCLOSE 	0x1		/* auto-close on exec */
#define	UF_MAPPED 	0x2		/* mapped from device */
#ifdef VFS
#define UF_FDLOCK	0x4		/* file desc locked (SysV style) */
	struct	vnode *u_cdir;		/* current directory */
	struct	vnode *u_rdir;		/* root directory of current process */
#else VFS
	struct	inode *u_cdir;		/* current directory */
	struct	inode *u_rdir;		/* root directory of current process */
#endif VFS
	struct	tty *u_ttyp;		/* controlling tty pointer */
	dev_t	u_ttyd;			/* controlling tty dev */
	short	u_cmask;		/* mask for file creation */

/* 1.5 - timing and statistics */
	struct	rusage u_ru;		/* stats for this proc */
	struct	rusage u_cru;		/* sum of stats for reaped children */
	struct	itimerval u_timer[3];
	int	u_XXX[3];
	struct	timeval u_start;
	short	u_acflag;

	struct uprof {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;

/* 1.6 - resource controls */
	struct	rlimit u_rlimit[RLIM_NLIMITS];
	struct	quota *u_quota;		/* user's quota structure */
	int	u_qflags;		/* per process quota flags */

#if (1) || !defined(VFS)
	/* 
	 * not needed for NFS, but kept to maintained for 
	 * common structure sizes (I hate recommpiling ps!!).
	 */
/* namei & co. */
	struct nameicache {		/* last successful directory search */
		int nc_prevoffset;	/* offset at which last entry found */
		ino_t nc_inumber;	/* inum of cached directory */
		dev_t nc_dev;		/* dev of cached directory */
		time_t nc_time;		/* time stamp for cache entry */
	} u_ncache;
	struct	nameidata u_nd;
#endif !VFS 
#if (1) || defined(VICE)
	/* ITC remote file system support */
	struct  rmt_wd *u_rmt_wd;	/* current directory, if remote */
	struct  rmtWd {			/* Current directory-new file system */
	    dev_t dev;			/* Mounted file system of the cwd */
	    long fid[3];		/* Vice II file identifier for cwd */
	} u_rmtWd;
	struct  file *u_textfile;	/* file object for a text segment */
	char	u_rmt_requested;	/* For namei, iget, etc: caller
					   can deal with remote files */
	char u_rmt_follow1 /*:1*/;	/* Follow symbolic link if it is last
					   component of first pathname of
					   a system call */
	char u_rmt_follow2 /*:1*/;	/* ... of second pathname ... */
	dev_t	u_rmt_dev;		/* Venus is listening on this device */
	struct	buf *u_rmt_path_buf;	/* buffer containing the pathname
					   looked up during the namei */
	char	*u_rmt_path;		/* pointer into u_rmt_path_buf to the
					   uninterpreted part of the path */
	long	u_rmt_pag;		/* Process authentication group */
#endif
#if	defined(ibm032)
	long	u_floatmask;		/* Floating point hardware in use */
					/* (see ../machine/float.h) */
#endif	/* defined(ibm032) */
	int	u_stack[1];
};

#if (1) || defined(VFS)
struct ucred {
	u_short	cr_ref;		/* reference count */
	uid_t	cr_uid;		/* effective user id */
	gid_t	cr_gid;		/* effective group id */
	gid_t	cr_groups[NGROUPS];	/* groups, 0 terminated */
	uid_t	cr_ruid;	/* real user id */
	gid_t	cr_rgid;	/* real group id */
};
#ifdef KERNEL
#define crhold(cr)	(cr)->cr_ref++
struct ucred *crget();
struct ucred *crcopy();
struct ucred *crdup();
#endif KERNEL
#endif VFS

/* u_eosys values */
#define	JUSTRETURN	1
#define	RESTARTSYS	2
#define NORMALRETURN	3

/* u_error codes */
#ifdef KERNEL
#include "errno.h"
#else
#include <errno.h>
#endif

#ifdef KERNEL
extern	struct user u;
extern	struct user swaputl;
extern	struct user forkutl;
extern	struct user xswaputl;
extern	struct user xswap2utl;
extern	struct user pushutl;
extern	struct user vfutl;
#endif
