/*
 * asy structure that uses the PS/2 as a dma controller for asy input
 * and output.
 * the buffer structure has read and write pointers that are used to
 * keep the separate processors out of each other's way.
 * if the read and write pointers are equal then the buffer is empty.
 */

#define MAX_BUFFER	32	/* max buffer space */
#define MAX_ASY		2	/* max asy lines supported */

struct buffer
{
u_char	read_index;		/* index for reading */
u_char	max_count;		/* actual max buffer size */
u_char	write_index;		/* index for writing */
u_char	fill1;			/* fill */
u_char	status;			/* current status */
#define SOFT_OVERFLOW	0x01	/* overflow (software) */
#define HARD_OVERFLOW	0x02	/* overflow (hardware) */
u_char	fill2;
u_char	buffer[MAX_BUFFER];
};

struct asy {
char	irq;		/* irq level used */
char	flags;		/* if its in use etc. */
struct buffer in_buff;
struct buffer out_buff;
} ;

#define ASYPUT(bp,c) { int x = bp->write_index;	\
	buffer[x] = c;	\
	if (++x >= bp->max_count)	\
		x = 0;		/* its circular */	\
	if (x == bp->read_index)	\
		bp->status |= SOFT_OVERFLOW;	\
	else	\
		bp->write_index = x;	/* its ok */	\
	}

#define ASYGET(bp,c) { int x = bp->read_index;	\
	if (x == bp->write_index)	\
		c = -1; 	\
	else {	\
		c = bp->buffer[x]	\
		if (++x >= bp->max_count)	\
			x = 0;	/* its circular */	\
		bp->read_index = x;	\
	}	\
	}
