/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:perror.c 12.0$ */
/* $ACIS:perror.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/perror.c,v $ */

#ifndef lint
static char *rcsid = "$Header:perror.c 12.0$";
#endif

#define	SYS_NERR	18

char *sys_errlist[SYS_NERR] = {
	"BAD FILE DESCRIPTOR",
	"RELATIVE SEEK NOT SUPPORTED",
	"INVALID DRIVE SPECIFICATION",
	"UNKNOWN DEVICE SPECIFIED",
	"INVALID UNIT SPECIFICATION",
	"DIRECTORY SEARCH FOR FILE FAILED",
	"DEVICE I/O ERROR",
	"UNDEFINED DRIVER COMMAND",
	"BAD SECTOR ERROR",
	"WRITE CHECK ERROR",
	"UNCORRECTABLE ECC ERROR",
	"HARD ERROR",
	"UNKNOWN DRIVE TYPE",
	"INVALID PARTITION NUMBER",
	"SUPER BLOCK READ ERROR",
	"CAN'T WRITE FILES YET... SORRY",
	"WRITE EXCEEDS PARTITION SIZE LIMIT",
	"BAD BLOCK ENTRY NOT FOUND IN BBT",
};


extern int errno;

perror(s)
	register char *s;
{
	if (errno < 1 || errno > SYS_NERR)
		printf("%s : unknown error number (%d)\n", s, errno);
	else
		printf("%s : %s\n", s, sys_errlist[errno - 1]);
}

