# makefile for ksh generated by mkold and hand modified
#########################################
# *** RDS makefile standards applied ***
#########################################
ROOT = /usr
# for RDS: set INSDIR = $(ROOT)/usr/lbin, else $(ROOT)/bin
INSDIR  = $(ROOT)/bin
TESTDIR = .
ETC     = $(ROOT)/etc

INC    = $(ROOT)/usr/include
INCSYS = $(ROOT)/usr/include/sys
SHELL  = /bin/sh
MAKE   = $(ROOT)/bin/make
AR     = $(ROOT)/bin/ar
CC     = $(ROOT)/bin/cc
LD     = $(ROOT)/bin/ld
INS    = $(ROOT)/etc/install
STRIP  = $(ROOT)/bin/strip
SIZE   = $(ROOT)/bin/size
RANLIB = $(ROOT)/bin/ranlib
# RDS: determine location of mcs
MCS    = `if [ -x /bin/uts ]; then if /bin/uts; then echo "$(ROOT)/bin/mcs"; else echo "$(ROOT)/usr/bin/mcs"; fi; else echo "$(ROOT)/usr/bin/mcs"; fi`

LDFLAGS = 
CFLAGS  = -O -I$(INC)
LIBS    =

Ins   = $(TESTDIR)/install
Inc   = $(TESTDIR)/include
Sh    = $(TESTDIR)/sh
SHLIB = $(TESTDIR)/shlib

RDONLY = ./readonly
# For RDS: SH=ksh SUID= , else SUID=suid_exec
SH     = ksh
SUID   = suid_exec

all:	$(SH) $(SUID)

$(SH):	sh_config.h arith.o args.o builtin.o cmd.o ctype.o \
		defs.o edit.o echo.o error.o expand.o fault.o history.o \
		io.o jobs.o macro.o main.o msg.o name.o print.o service.o \
		string.o stak.o test.o word.o xec.o emacs.o vi.o libsh.a
	$(CC) $(CFLAGS) -o $(TESTDIR)/$(SH) arith.o args.o builtin.o cmd.o \
		ctype.o defs.o edit.o echo.o error.o expand.o fault.o  \
		history.o io.o jobs.o macro.o main.o msg.o name.o print.o \
		service.o string.o stak.o test.o word.o xec.o emacs.o \
		vi.o libsh.a $(LIBS)
	if	test -x $(MCS);\
	then	$(MCS) -d $(SH)  2> /dev/null;\
	fi

sh_config.h:
		-chmod 755 $(Ins)/compile $(Ins)/config $(Ins)/shellmagic $(Ins)/gen_rdonly
		$(Ins)/config > $(TESTDIR)/newconfig
		if	test -r sh_config.h && \
			cmp -s $(TESTDIR)/newconfig sh_config.h;\
		then	rm $(TESTDIR)/newconfig	 ;\
		else	mv $(TESTDIR)/newconfig sh_config.h;\
		fi

$(RDONLY):
		$(Ins)/gen_rdonly 2> /dev/null

arith.o:	$(Sh)/arith.c $(Inc)/streval.h sh_config.h \
		$(Inc)/defs.h $(Inc)/stak.h $(Inc)/shnodes.h \
		$(Inc)/brkincr.h $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/arith.c

args.o:	$(Sh)/args.c $(Inc)/builtins.h $(Inc)/sym.h $(Inc)/jobs.h \
		$(Inc)/terminal.h $(Inc)/defs.h $(Inc)/stak.h \
		$(Inc)/shnodes.h $(Inc)/brkincr.h $(Inc)/name.h \
		$(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/args.c

builtin.o:	$(Sh)/builtin.c $(Inc)/sym.h $(Inc)/jobs.h \
		$(Inc)/terminal.h $(Inc)/builtins.h $(Inc)/history.h \
		$(Inc)/defs.h $(Inc)/stak.h $(Inc)/shnodes.h \
		$(Inc)/brkincr.h $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/builtin.c

cmd.o:	$(Sh)/cmd.c $(Inc)/test.h $(Inc)/builtins.h $(Inc)/history.h \
		$(Inc)/sym.h $(Inc)/defs.h $(Inc)/stak.h \
		$(Inc)/shnodes.h $(Inc)/brkincr.h $(Inc)/name.h \
		$(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/cmd.c

ctype.o:	$(RDONLY) $(Sh)/ctype.c
	$(RDONLY) -I. -I$(Inc) $(CFLAGS) -DKSHELL $(Sh)/ctype.c

defs.o:	$(Sh)/defs.c $(Inc)/timeout.h $(Inc)/edit.h $(Inc)/history.h \
		$(Inc)/sym.h $(Inc)/jobs.h $(Inc)/terminal.h \
		$(Inc)/defs.h $(Inc)/stak.h $(Inc)/shnodes.h \
		$(Inc)/brkincr.h $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/defs.c

edit.o:	$(Sh)/edit.c $(Inc)/edit.h $(Inc)/history.h $(Inc)/sym.h \
		$(Inc)/builtins.h $(Inc)/terminal.h $(Inc)/defs.h \
		$(Inc)/stak.h $(Inc)/shnodes.h $(Inc)/brkincr.h \
		$(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/edit.c

echo.o:	$(Sh)/echo.c $(Inc)/defs.h $(Inc)/stak.h $(Inc)/shnodes.h \
		$(Inc)/brkincr.h $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/echo.c

error.o:	$(Sh)/error.c $(Inc)/history.h $(Inc)/jobs.h \
		$(Inc)/terminal.h $(Inc)/defs.h $(Inc)/stak.h \
		$(Inc)/shnodes.h $(Inc)/brkincr.h $(Inc)/name.h \
		$(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/error.c

expand.o:	$(Sh)/expand.c sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/expand.c

fault.o:	$(Sh)/fault.c $(Inc)/timeout.h $(Inc)/sym.h $(Inc)/jobs.h \
		$(Inc)/terminal.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/fault.c

history.o:	$(Sh)/history.c $(Inc)/history.h $(Inc)/builtins.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/history.c

io.o:	$(Sh)/io.c $(Inc)/history.h $(Inc)/sym.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/io.c

jobs.o:	$(Sh)/jobs.c $(Inc)/history.h $(Inc)/jobs.h $(Inc)/terminal.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/jobs.c

macro.o:	$(Sh)/macro.c $(Inc)/builtins.h $(Inc)/sym.h $(Inc)/terminal.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/macro.c

main.o:	$(Sh)/main.c $(Inc)/builtins.h $(Inc)/timeout.h \
		$(Inc)/history.h $(Inc)/sym.h $(Inc)/jobs.h \
		$(Inc)/terminal.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/main.c

msg.o:	$(RDONLY) $(Sh)/msg.c $(Inc)/history.h $(Inc)/timeout.h $(Inc)/test.h \
		$(Inc)/builtins.h $(Inc)/sym.h
	$(RDONLY) -I. -I$(Inc) $(CFLAGS) -DKSHELL $(Sh)/msg.c

name.o:	$(Sh)/name.c $(Inc)/timeout.h $(Inc)/history.h \
		$(Inc)/builtins.h $(Inc)/sym.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/name.c

print.o:	$(Sh)/print.c $(Inc)/builtins.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/print.c

service.o:	$(Sh)/service.c $(Inc)/history.h $(Inc)/builtins.h \
		$(Inc)/sym.h $(Inc)/jobs.h $(Inc)/terminal.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/service.c

string.o:	$(Sh)/string.c $(Inc)/sym.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/string.c

stak.o:	$(Sh)/stak.c
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/stak.c

test.o:	$(Sh)/test.c $(Inc)/sym.h $(Inc)/test.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/test.c

word.o:	$(Sh)/word.c $(Inc)/test.h $(Inc)/builtins.h $(Inc)/sym.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/word.c

xec.o:	$(Sh)/xec.c $(Inc)/builtins.h $(Inc)/test.h $(Inc)/sym.h \
		$(Inc)/jobs.h $(Inc)/terminal.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/xec.c

emacs.o:	$(Sh)/emacs.c $(Inc)/edit.h $(Inc)/history.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/emacs.c

vi.o:	$(Sh)/vi.c $(Inc)/terminal.h $(Inc)/edit.h $(Inc)/history.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(Sh)/vi.c

libsh.a:	adjust.o assign.o assnum.o cannon.o chkid.o convert.o \
		findnod.o gettree.o strmatch.o growaray.o gsort.o \
		linknod.o namscan.o rjust.o strdata.o streval.o tilde.o \
		unassign.o utos.o valup.o optget.o
	$(AR) cr libsh.a adjust.o assign.o assnum.o cannon.o chkid.o \
		convert.o findnod.o gettree.o strmatch.o growaray.o gsort.o \
		linknod.o namscan.o rjust.o strdata.o streval.o tilde.o \
		unassign.o utos.o valup.o optget.o
		if	test -x	 $(RANLIB);\
		then	$(RANLIB) libsh.a > /dev/null 2>&1;\
		fi

adjust.o:	$(SHLIB)/adjust.c $(Inc)/name.h $(Inc)/flags.h sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/adjust.c

assign.o:	$(SHLIB)/assign.c $(Inc)/name.h $(Inc)/flags.h sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/assign.c

assnum.o:	$(SHLIB)/assnum.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/assnum.c

cannon.o:	$(SHLIB)/cannon.c sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/cannon.c

chkid.o:	$(SHLIB)/chkid.c sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/chkid.c

convert.o:	$(SHLIB)/convert.c
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/convert.c

findnod.o:	$(SHLIB)/findnod.c $(Inc)/name.h $(Inc)/flags.h sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/findnod.c

gettree.o:	$(SHLIB)/gettree.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/gettree.c

strmatch.o:	$(SHLIB)/strmatch.c
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/strmatch.c

growaray.o:	$(SHLIB)/growaray.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/growaray.c

gsort.o:	$(SHLIB)/gsort.c
	$(CC) -I$(Inc) $(CFLAGS) -c $(SHLIB)/gsort.c

linknod.o:	$(SHLIB)/linknod.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/linknod.c

namscan.o:	$(SHLIB)/namscan.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/namscan.c

rjust.o:	$(SHLIB)/rjust.c
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/rjust.c

strdata.o:	$(RDONLY) $(SHLIB)/strdata.c $(Inc)/streval.h sh_config.h
	$(RDONLY) $(CFLAGS) -I. -I$(Inc) -DKSHELL $(SHLIB)/strdata.c

streval.o:	$(SHLIB)/streval.c $(Inc)/streval.h sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/streval.c

tilde.o:	$(SHLIB)/tilde.c sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/tilde.c

unassign.o:	$(SHLIB)/unassign.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/unassign.c

utos.o:	$(SHLIB)/utos.c
	$(CC) -I$(Inc) $(CFLAGS) -c $(SHLIB)/utos.c

valup.o:	$(SHLIB)/valup.c $(Inc)/name.h $(Inc)/flags.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/valup.c

optget.o:	$(SHLIB)/optget.c sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -DKSHELL -c $(SHLIB)/optget.c

suid_exec:	suid_exec.o
	$(CC) $(CFLAGS) -o $(TESTDIR)/suid_exec suid_exec.o

suid_exec.o :	$(Sh)/suid_exec.c sh_config.h
	$(CC) -I. -I$(Inc) $(CFLAGS) -c $(Sh)/suid_exec.c

clobber :	clean
		rm -f $(TESTDIR)/$(SH) $(TESTDIR)/suid_exec sh_config.h \
			$(RDONLY) libsh.a core

clean :
	rm -f *.o

install : all strip
	-mv $(INSDIR)/$(SH) $(INSDIR)/OLD$(SH)
	-mv $(INSDIR)/r$(SH) $(INSDIR)/OLDr$(SH)
	$(INS) -o -m 555 -u bin -g root -f $(INSDIR) $(TESTDIR)/$(SH)
	ln -f $(INSDIR)/$(SH) $(INSDIR)/r$(SH)
	rm -f $(TESTDIR)/$(SH)
	-rm -f $(INSDIR)/OLD$(SH) $(INSDIR)/OLDr$(SH)
	if test -x $(TESTDIR)/suid_exec;\
	then	-rm -f $(ETC)/suid_exec;\
		$(INS) -o -m 4511 -u root -g root -f $(ETC) $(TESTDIR)/suid_exec;\
		rm -f $(TESTDIR)/suid_exec;\
	fi

size: all
	$(SIZE)  $(TESTDIR)/$(SH) 
	if test -x $(TESTDIR)/suid_exec;\
	then	$(SIZE)	 $(TESTDIR)/suid_exec;\
	fi

strip: all
	$(STRIP)  $(SH)
	if test -x $(TESTDIR)/suid_exec;\
	then	$(STRIP)  $(TESTDIR)/suid_exec;\
	fi


