/* m- file for Ardent Titans.
   Copyright (C) 1987 Free Software Foundation, Inc.

#ifndef __P3__
#define __P2__ 1
#endif

This file is part of GNU Emacs.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Emacs General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU Emacs, but only under the conditions described in the
GNU Emacs General Public License.   A copy of this license is
supposed to have been given to you along with GNU Emacs so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  */

/* The following three symbols give information on
 the size of various data types.  */

#define SHORTBITS 16		/* Number of bits in a short */

#define INTBITS 32		/* Number of bits in an int */

#define LONGBITS 32		/* Number of bits in a long */

/* allow emacs as large as 64 megabytes *

#define VALBITS 26
#define GCTYPEBITS 5
   
/* Define BIG_ENDIAN iff lowest-numbered byte in a word
   is the most significant byte.  */

#define BIG_ENDIAN

/* Define NO_ARG_ARRAY if you cannot take the address of the first of a
 * group of arguments and treat it as an array of the arguments.  */

#define NO_ARG_ARRAY

/* Define WORD_MACHINE if addresses and such have
 * to be corrected before they can be used as byte counts.  */

#undef WORD_MACHINE

/* Define how to take a char and sign-extend into an int.
   On machines where char is signed, this is a no-op.  */

#define SIGN_EXTEND_CHAR(c) (c)

/* Now define a symbol for the cpu type, if your compiler
   does not define it automatically:
   Ones defined so far include vax, m68000, ns16000, pyramid,
   orion, tahoe, APOLLO and many others */

#ifndef titan			/* C compiler defines this */
#	define titan
#endif
 
/* Use type int rather than a union, to represent Lisp_Object */
/* This is desirable for most machines.  */

#define NO_UNION_TYPE

/* Define EXPLICIT_SIGN_EXTEND if XINT must explicitly sign-extend
   the 24-bit bit field into an int.  In other words, if bit fields
   are always unsigned.

   If you use NO_UNION_TYPE, this flag does not matter.  */

#define EXPLICIT_SIGN_EXTEND

/* Data type of load average, as read out of kmem.  */

#define LOAD_AVE_TYPE long

/* Convert that into an integer that is 100 for a load average of 1.0  */

#define LOAD_AVE_CVT(x) (int) (((double) (x)) * 100. / 65536.)

/* Define CANNOT_DUMP on machines where unexec does not work.
   Then the function dump-emacs will not be defined
   and temacs will do (load "loadup") automatically unless told otherwise.  */

/* #define CANNOT_DUMP */

/* Define VIRT_ADDR_VARIES if the virtual addresses of
   pure and impure space as loaded can vary, and even their
   relative order cannot be relied on.

   Otherwise Emacs assumes that text space precedes data space,
   numerically.  */

/* #define VIRT_ADDR_VARIES */

/* Define C_ALLOCA if this machine does not support a true alloca
   and the one written in C should be used instead.
   Define HAVE_ALLOCA to say that the system provides a properly
   working alloca function and it should be used.
   Define neither one if an assembler-language alloca
   in the file alloca.s should be used.  */

#define C_ALLOCA
/* #define HAVE_ALLOCA */

/* Define NO_REMAP if memory segmentation makes it not work well
   to change the boundary between the text section and data section
   when Emacs is dumped.  If you define this, the preloaded Lisp
   code will not be sharable; but that's better than failing completely.  */

#define NO_REMAP

/*
 *	Define HAVE_TERMIO if the system provides sysV-style ioctls
 *	for terminal control.
 */

/* Ardent supports both termcap and terminfo; hence either define HAVE_TERMIO,
   (gets you terminfo) or undefine it, (gets you termcap) as you wish. Note:
   Ardent also supplies captoinfo, which translates from termcap to terminfo,
   which lets you be even more terminal library independant. */

#define HAVE_TERMIO /* */

/* Give alloca some direction */
#define STACK_DIRECTION -1

/* undo various usg5-3 defines */

/* Unlike most SYSV's, Titan supports ^Z */
#ifdef NOMULTIPLEJOBS		
#undef NOMULTIPLEJOBS
#endif /* */

/* Titan can support interrupt driven i/o; use it if you'd like to. */
/*
#ifdef INTERRUPT_INPUT
#undef INTERRUPT_INPUT
#endif /* */

/* Titan supports timeval; x11term.c seems to need timeval, hence
   I suggest you use it. */
#ifndef HAVE_TIMEVAL	
#define HAVE_TIMEVAL
#endif /* */

/* Titan supports ptys */
#ifndef HAVE_PTYS
#define HAVE_PTYS
#define SYSV_PTYS
#define HAS_DEVPTY
#endif   /* */

/* Titan does not support select on pipes, so force socket usage */
#ifndef SKTPAIR
#define SKTPAIR
#endif   /* */

#ifndef HAVE_SOCKETS
#define HAVE_SOCKETS
#endif /* HAVE_SOCKETS */

/* Titan does NOT put networking library in libnsl_s.a; it's in libc */
#ifdef LIBX10_SYSTEM
#undef LIBX10_SYSTEM
#endif /* */
#ifdef LIBX11_SYSTEM
#undef LIBX11_SYSTEM
#endif /* */

/* ardent specific defines */

#define START_FILES /lib/crt0.o
#define C_OPTIMIZE_SWITCH -O1 
#define C_SWITCH_MACHINE -I/usr/X11/include 
#define LD_SWITCH_MACHINE   

#define HAVE_SELECT

/* The titan only defines utimes in the BSD environment */
#define MISSING_UTIMES

/* setenv is a useful thing to have */
#define MAINTAIN_ENVIRONMENT

/* (loadst.c) Titan does not have this */
#undef DKSTAT_HEADER_FILE

/* RMS asked that I create an unextitan, as unexec.c has too many ifdefs already */
#define UNEXEC unextitan.o 
#define TEXT_END _etext
#define DATA_END _edata
#define DATA_SECTION_ALIGNMENT pagemask
#define TEXT_START 0x400000
#ifdef __P3__
#define DATA_START 0x10000000
#else
#define DATA_START 0x10003000
#endif
#define DATA_SEG_BITS 0x10000000

/* -NW: titan cc performs lint; emacs is not lint free; -NW kills warnings  */
#define C_DEBUG_SWITCH -g -NW	

/* The standard definitions of these macros would work ok,
   but these are faster because the constants are short.  */

#define XUINT(a) (((unsigned)(a) << INTBITS-VALBITS) >> INTBITS-VALBITS)
/*#define XPNTR(a) (XUINT(a) == 0 ? 0 : (XUINT (a) | DATA_SEG_BITS))*/

#define XSET(var, type, ptr) \
   ((var) = ((int)(type) << VALBITS) + (((unsigned) (ptr) << INTBITS-VALBITS) >> INTBITS-VALBITS))

#define XSETINT(a, b)  XSET(a, XTYPE(a), b)
#define XSETUINT(a, b) XSET(a, XTYPE(a), b)
#define XSETPNTR(a, b) XSET(a, XTYPE(a), b)

#define XMARKBIT(a) ((a) < 0)
/*(a < 0) returns 1, not MARKBIT, so XSETMARKBIT has to be redefined.*/
#define XSETMARKBIT(a,b) ((a) = ((b) ? (a)|MARKBIT : (a) & ~MARKBIT))
#define XUNMARK(a) ((a) = (((a) << INTBITS-GCTYPEBITS-VALBITS) >> INTBITS-GCTYPEBITS-VALBITS))
#define PURESIZE 400000

#define DONT_DELETE_MAILFILE

#define BSTRING
#define BROKEN_FIONREAD

#define USE_STREAMS
#define HAVE_UNIX_DOMAIN
#define USG_SYS_TIME
#undef random
