#!/usr/bin/perl

eval "exec /usr/bin/perl -S $0 $*"
    if $running_under_some_shell;

format top =
User      Revision  File
--------  --------  ----------------------------------------------------
.
format mailmsg =
@<<<<<<<  @<<<<<<<  @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$who      $revision $filename
.

if ($#ARGV < 0) {
    $dirs = '/usr/src';
#    $interactive = 0;
    $interactive = 1;
}
else {
    $dirs = join(' ', @ARGV);
    @ARGV = ();
    $interactive = 1;
}

open(stdin,
    "find $dirs -name *,v -print | /usr/bin/xargs /usr/bin/rlog -L -h 2>/dev/null |") || 
    die "Can't open pipe, stopped";

if ( ! $interactive ) {
    $tmpout = "/tmp/RCS$$";
    open(mailmsg, ">$tmpout") ||
	die "Can't open temp file for writing, stopped";
}
else {
    open(mailmsg, ">-");
}

while (<>) {
    if ( /^RCS file: / ) {
	($xx,$filename) = split(/:/);
    }
    if ( /^locks: / ) {
	$_ = <>;
	while (!/^access/) {
	    ($who,$revision) = split(/:/);
	    $users{$who} = 1;
	    $_ = <>;
	}
	write(mailmsg);
    }
}

close(mailmsg);

if (! $interactive) {
    $users = join(' ', keys(users));
    system "mailx -s 'Files you have checked out' $users <$tmpout";
    unlink($tmpout);
}
