/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
#if !defined( lint) && !defined(_NOIDENT)
static char rcsid[] = "@(#)$RCSfile: bdiff.c,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/19 01:19:33 $";
#endif
 /*
  * COMPONENT_NAME: (CMDFILES) commands that manipulate files
  *
  * FUNCTIONS: bdiff
  *
  * ORIGINS: 3, 27
  *
  * This module contains IBM CONFIDENTIAL code. -- (IBM
  * Confidential Restricted when combined with the aggregated
  * modules for this product)
  * OBJECT CODE ONLY SOURCE MATERIALS
  * (C) COPYRIGHT International Business Machines Corp. 1985, 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * bdiff.c     1.7  com/cmd/files,3.1,9021 9/11/89 14:37:19";
 */

#include	<sys/types.h>
#include	<sys/limits.h>
#include	<stdio.h>
#include	<locale.h>
#include	<macros.h>
#include	<fatal.h>

#include "bdiff_msg.h"

nl_catd	catd;
#define MSGSTR(num, str) catgets(catd, MS_BDIFF, num, str)


char *satoi();


#define TMP_FILE_MODE 0644
struct stat Statbuf;
char Error[128];      /* error msg string */

int seglim = 3500;	/* Default set to upper limit on size of files */
                        /* bdiff can handle. */

FILE *fdfopen();
char diff[]  =  "diff";
char tempskel[] = "/tmp/bdXXXXXX";  /* used to generate temp file names */
char tempfile[PATH_MAX];
char otmp[PATH_MAX], ntmp[PATH_MAX];
int linenum;

/*
 * NAME: bdiff file1 file2 [n] [-s]
 *                                                                    
 * FUNCTION: Uses diff to find differences in very large files
 *           n   number of lines per segment
 *           -s  suppresses error messages
 *       This program segments two files into pieces of <= seglim lines
 *	 (which is passed as a third argument or defaulted to some number)
 *	 and then executes diff upon the pieces. The output of
 *	 'diff' is then processed to make it look as if 'diff' had
 *	 processed the files whole. The reason for all this is that seglim
 *	 is a reasonable upper limit on the size of files that diff can
 *	 process.
 *	 NOTE -- by segmenting the files in this manner, it cannot be
 *	 guaranteed that the 'diffing' of the segments will generate
 *	 a minimal set of differences.
 *	 This process is most definitely not equivalent to 'diffing'
 *	 the files whole, assuming 'diff' could handle such large files.
 *
 *	 'diff' is executed by a child process, generated by forking,
 *	 and communicates with this program through pipes.
 */
main(argc,argv)
int argc;
char *argv[];
{
	FILE *poldfile, *pnewfile, *maket();
	char oline[BUFSIZ], nline[BUFSIZ], diffline[BUFSIZ];
	char *olp, *nlp, *dp;
	int i, otcnt, ntcnt;
	int pfd[2];
	FILE *poldtemp, *pnewtemp, *pipeinp;
	int status;

	(void ) setlocale(LC_ALL,"");
	catd = catopen(MF_BDIFF, 0);

	/*
	Set flags for 'fatal' so that it will clean up,
	produce a message, and terminate.
	*/
	Fflags = FTLMSG | FTLCLN | FTLEXIT;

	setsig();

	if (argc < 3 || argc > 5)
		fatal(MSGSTR(ARGCNT,
			     "usage: bdiff file1 file2 [number] [-s]\n"));

	if (equal(argv[1],"-") && equal(argv[2],"-"))
		fatal(MSGSTR(BOTHSTDIN, 
			    "Specify only one file as standard input.(bd2)\n"));
	if (equal(argv[1],"-"))
		poldfile = stdin;
	else
		poldfile = xfopen(argv[1],0);
	if (equal(argv[2],"-"))
		pnewfile = stdin;
	else
		pnewfile = xfopen(argv[2],0);

	if (argc > 3) {
		if (argv[3][0] == '-' && argv[3][1] == 's')
			Fflags &= ~FTLMSG;
		else {
		   if ( (*argv[3] <= '0') ||((seglim = patoi(argv[3])) == -1) )
				fatal(MSGSTR(NONNUMLMT,
         "\nUse a nonzero positive integer to specify a file segment.(bd4)"));
			if (argc == 5 && argv[4][0] == '-' &&
					argv[4][1] == 's')
				Fflags &= ~FTLMSG;
		}
	}

	linenum = 0;

	/*
	The following while-loop will prevent any lines
	common to the beginning of both files from being
	sent to 'diff'. Since the running time of 'diff' is
	non-linear, this will help improve performance.
	If, during this process, both files reach EOF, then
	the files are equal and the program will terminate.
	If either file reaches EOF before the other, the
	program will generate the appropriate 'diff' output
	itself, since this can be easily determined and will
	avoid executing 'diff' completely.
	*/
	while (1) {
		olp = fgets(oline,BUFSIZ,poldfile);
		nlp = fgets(nline,BUFSIZ,pnewfile);

		if (!olp && !nlp)	/* files are equal */
			exit(0);

		if (!olp) {
			/*
			The entire old file is a prefix of the
			new file. Generate the appropriate "append"
			'diff'-like output, which is of the form:
					nan,n
			where 'n' represents a line-number.
			*/
			addgen(nline,pnewfile);
		}

		if (!nlp) {
			/*
			The entire new file is a prefix of the
			old file. Generate the appropriate "delete"
			'diff'-like output, which is of the form:
					n,ndn
			where 'n' represents a line-number.
			*/
			delgen(oline,poldfile);
		}

		if (equal(olp,nlp))
			linenum++;
		else
			break;
	}

	/*
	Here, first 'linenum' lines are equal.
	The following while-loop segments both files into
	seglim segments, forks and executes 'diff' on the
	segments, and processes the resulting output of
	'diff', which is read from a pipe.
	*/
	while (1) {
		/*
		If both files are at EOF, everything is done.
		*/
		if (!olp && !nlp)	/* finished */
			exit(0);

		if (!olp) {
			/*
			Generate appropriate "append"
			output without executing 'diff'.
			*/
			addgen(nline,pnewfile);
		}

		if (!nlp) {
			/*
			Generate appropriate "delete"
			output without executing 'diff'.
			*/
			delgen(oline,poldfile);
		}

		/*
		Create a temporary file to hold a segment
		from the old file, and write it.
		*/
		poldtemp = maket(otmp);
		otcnt = 0;
		while(olp && otcnt < seglim) {
			fputs(oline,poldtemp);
			if (ferror(poldtemp) != 0) {
				Fflags |= FTLMSG;
				xmsg(otmp,"fputs");
			}
			olp = fgets(oline,BUFSIZ,poldfile);
			otcnt++;
		}
		fclose(poldtemp);

		/*
		Create a temporary file to hold a segment
		from the new file, and write it.
		*/
		pnewtemp = maket(ntmp);
		ntcnt = 0;
		while(nlp && ntcnt < seglim) {
			fputs(nline,pnewtemp);
			if (ferror(pnewtemp) != 0) {
				Fflags |= FTLMSG;
				xmsg(ntmp,"fputs");
			}
			nlp = fgets(nline,BUFSIZ,pnewfile);
			ntcnt++;
		}
		fclose(pnewtemp);

		/*
		Create pipes and fork.
		*/
		xpipe(pfd);
		if ((i = fork()) < 0) {
			close(pfd[0]);
			close(pfd[1]);
			fatal(MSGSTR(CANTFORK,
			       "Cannot create another process now. (co20)\n"));
		}
		else if (i == 0) {	/* child process */
			close(pfd[0]);
			close(1);
			dup(pfd[1]);
			close(pfd[1]);

			/*
			Execute 'diff' on the segment files.
			*/
			execlp(diff,diff,otmp,ntmp,0);
			close(1);
			sprintf(Error,MSGSTR(CANTEXEC,
                               "Cannot run %s.(co50)\n"),diff);
			fatal(Error);
		}
		else {			/* parent process */
			close(pfd[1]);
			pipeinp = fdfopen(pfd[0],0);

			/*
			Process 'diff' output.
			*/
			while ((dp = fgets(diffline,BUFSIZ,pipeinp))) {
				if (numeric(*dp))
					fixnum(diffline);
				else
					printf("%s",diffline);
			}

			fclose(pipeinp);

			/*
			EOF on pipe.
			*/
			wait(&status);
 			if (status&~0x100) {
				sprintf(Error,MSGSTR(DIFFFAIL,
                                            "%s failed (bd6)"),diff);
				fatal(Error);
			}
		}
		linenum += seglim;

		/*
		Remove temporary files.
		*/
		unlink(otmp);
		unlink(ntmp);
	}
}


/*
 * NAME: saverest
 *                                                                    
 * FUNCTION: 	Routine to save remainder of a file.
 */  
saverest(line,iptr)
char *line;
FILE *iptr;
{
	char *lp;
	FILE *temptr, *maket();

	temptr = maket(tempfile);

	lp = line;

	while (lp) {
		fputs(line,temptr);
		linenum++;
		lp = fgets(line,BUFSIZ,iptr);
	}
	fclose(temptr);
}


/*
 * NAME: putsave
 *                                                                    
 * FUNCTION: Routine to write out data saved by 
 *           'saverest' routine and to remove the file.
 */  
putsave(line,type)
char *line;
char type;
{
	FILE *temptr;

	temptr = xfopen(tempfile,0);

	while (fgets(line,BUFSIZ,temptr))
		printf("%c %s",type,line);

	fclose(temptr);

	xunlink(tempfile);
}


/*
 * NAME: fixnum
 *                                                                    
 * FUNCTION:  prints the commands from diff
 */  
fixnum(lp)
char *lp;
{
	int num;

	while (*lp) {
		switch (*lp) {

		case 'a':
		case 'c':
		case 'd':
		case ',':
		case '\n':
			printf("%c",*lp);
			lp++;
			break;

		default:
			lp = satoi(lp,&num);
			num += linenum;
			printf("%d",num);
		}
	}
}


/*
 * NAME: addgen
 *                                                                    
 * FUNCTION: generate the append diff like output 
 */  
addgen(lp,fp)
char *lp;
FILE *fp;
{
	printf("%da%d,",linenum,linenum+1);

	/*
	Save lines of new file.
	*/
	saverest(lp,fp);

	printf("%d\n",linenum);

	/*
	Output saved lines, as 'diff' would.
	*/
	putsave(lp,'>');

	exit(0);
}


/*
 * NAME: delgen
 *                                                                    
 * FUNCTION: generate delete diff like ouput
 */  
delgen(lp,fp)
char *lp;
FILE *fp;
{
	int savenum;

	printf("%d,",linenum+1);
	savenum = linenum;

	/*
	Save lines of old file.
	*/
	saverest(lp,fp);

	printf("%dd%d\n",linenum,savenum);

	/*
	Output saved lines, as 'diff' would.
	*/
	putsave(lp,'<');

	exit(0);
}


/*
 * NAME: clean_up
 *                                                                    
 * FUNCTION: unlink tmp files
 */  
clean_up()
{
	unlink(tempfile);
	unlink(otmp);
	unlink(ntmp);
}


/*
 * NAME: maket
 *                                                                    
 * FUNCTION: create temp file
 */  
FILE *
maket(file)
char *file;
{
	FILE *iop;
	char *mktemp();

	copy(tempskel,file);
	iop = xfcreat(mktemp(file),TMP_FILE_MODE);

	return(iop);
}
