/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, 1991, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0.1
 */
#if !defined(lint) && !defined(_NOIDENT)
static char rcsid[] = "@(#)$RCSfile: lint2.c,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/19 01:53:52 $";
#endif
/*
 * COMPONENT_NAME: (CMDPROG) Programming Utilites
 *
 * FUNCTIONS: CheckSymbol, FtnUsage, RefDefSymbol, SameMembers, SameParameters,
	      SameTypes
 *
 * ORIGINS: 00 03 10 27 32
 *
 * IBM CONFIDENTIAL -- (IBM Confidential Restricted when
 * combined with the aggregated modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1988, 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * lint2.c	1.6  com/cmd/prog/lint/pass2,3.1,9013 8/28/90 10:44:12"; 
 */
#include "mfile1.h"
#include "lint2.h"


#include "lint_msg.h"
#define  MSGSTR(Num, Str) catgets(catd, MS_LINT, Num, Str)
nl_catd catd;
/*
** Check that the current symbol and symbol p are compatible types.
*/
CheckSymbol()
{
	int stat;

	stat = STORE;
#ifdef	DEBUG
	if (debug) {
		PrintSymbol("CHECKING OLD SYMBOL", prevSym);
		PrintSymbol("WITH NEW SYMBOL", curSym);
		printf("at %s (%s, %d-%d)\n", curPFname, curIFname, curDLine,
			curRLine);
	}
#endif

	/* Check for multiple definitions. */
	if ((prevSym->usage & LINTDEF) && (curSym->usage & LINTDEF) &&
		!(prevSym->usage & LINTMBR)) {
		if (ISFTN(curSym->type))
			LERROR(WDECLAR, MSGSTR(M_MSG_304,
			       "function %s multiply defined"), curSym, CDUSE);
		else if (devdebug[ANSI_MODE]) 
			LERROR(WDECLAR, MSGSTR(M_MSG_305,
			       "symbol %s multiply defined"), curSym, CDUSE);
		stat = REJECT;
	}

	/* Check for compatible types. */
	if (!SameTypes(prevSym->type, curSym->type)) {
		stat = REJECT;
		if (!ISFTN(curSym->type))
			LERROR(WDECLAR, MSGSTR(M_MSG_306,
			       "symbol %s type inconsistent"), curSym, CRUSE);
		else if (prevSym->usage & LINTVRG || curSym->usage & LINTVRG)
			stat = CHANGE;
	}

	/* Check for possible struct/union/enum redefinition. */
	if (prevSym->nmbrs && !SameMembers(prevSym, curSym)) {
		LERROR(WDECLAR, MSGSTR(M_MSG_307,
			"struct/union/enum %s inconsistently redefined"),
			curSym, CDUSE);
		stat = REJECT;
	}

	/* End of REJECTion processing, now check for CHANGEs. */
	if (stat == REJECT)
		return (stat);

	/* New instance of symbol usage? */
	if ((prevSym->usage & (LINTREF|LINTDEF|LINTDCL|LINTRET)) !=
		(curSym->usage & (LINTREF|LINTDEF|LINTDCL|LINTRET)))
		stat = CHANGE;

	/* New file reference of symbol? */
	if (strcmp(prevSym->rpf, curPFname) &&
		(curSym->usage & (LINTREF|LINTDCL)))
		stat = CHANGE;

	return (stat);
}

/*
** This routine makes sure that the types t1 and t2 are compatible.
** Error messages assuming that these are dereferenced pointer types.
*/
SameTypes(t1, t2)
	register TPTR t1, t2;
{
	TPTR ot1 = t1;
	TPTR ot2 = t2;

	/* Check qualifier top-type compatibility. */
	if (QUALIFIERS(t1) != QUALIFIERS(t2))
		return (0);

	/* INTs and ENUMs are compatible types. */
	if (TOPTYPE(t1) != TOPTYPE(t2)) {
		if ((TOPTYPE(t1) == INT && TOPTYPE(t2) == ENUMTY) ||
			(TOPTYPE(t2) == INT && TOPTYPE(t1) == ENUMTY))
			return (1);
		return (0);
	}

	/* Examine each level of type indirection. */
	while (!ISBTYPE(t1)) {
		switch (TOPTYPE(t1)) {
		case FTN:
			if (!SameParameters(t1, t2))
				return (0);
			break;

		case ARY:
			if (t1->ary_size != 0 && t2->ary_size != 0 &&
				t1->ary_size != t2->ary_size)
				return (0);
			break;
		}
		t1 = t1->next; t2 = t2->next;

		/* Check type specifier and qualifier. */
		if (TOPQTYPE(t1) != TOPQTYPE(t2)) {
			if (QUALIFIERS(t1) == QUALIFIERS(t2) &&
				((TOPTYPE(t1) == INT && TOPTYPE(t2) == ENUMTY)
				||
				(TOPTYPE(t2) == INT && TOPTYPE(t1) == ENUMTY)))
				return (1);
			if (ISFTN(ot1) || ISFTN(ot2))
				LERROR(WDECLAR, MSGSTR(M_MSG_308,
					"function %s type inconsistent"),
					curSym, CRUSE);
			return (0);
		}
	}

	if (t1->typ_size != t2->typ_size)
		return (0);

	return (1);
}

/*
** Check if both function argument lists are compatible.
*/
SameParameters(t1, t2)
	register TPTR t1,t2;
{
	register PPTR p1 = t1->ftn_parm;
	register PPTR p2 = t2->ftn_parm;

	/* Check for prototype lists. */
	if (p1 == PNIL && p2 == PNIL)
		return (1);

	/* Check for ellipsis, although strictly speaking ANSI does not
	   permit an ellipsis to be the only function parameter, it is
	   produced when a VARARGS0 appears before an old-style function
	   definition. */
	if ((p1 != PNIL && TOPTYPE(p1->type) == TELLIPSIS) || (p2 != PNIL &&
		TOPTYPE(p2->type) == TELLIPSIS))
		return (1);

	/* If either prototype is NIL, check for default compatibilty. */
	if (p1 == PNIL)
		return (defaultproto(p2));
	if (p2 == PNIL)
		return (defaultproto(p1));

	/* Check each entry on both lists to be sure they are
	   compatible.  If not return a failure for the function. */
	for (; p1 != PNIL && p2 != PNIL; p1 = p1->next, p2 = p2->next) {
		/* VARARGSn directive now implimented correctly */
		if ((!SameTypes(p1->type, p2->type)) && (TOPTYPE(p1->type) != TELLIPSIS)) {
			LERROR(WDECLAR, MSGSTR(M_MSG_309,
				"function %s argument type inconsistent"),
				curSym, CRUSE);
			return (0);
		}
	}

	/* If both parameter lists don't end simultaneously, the
	   number of arguments is mismatched. */
	if (!(prevSym->usage & LINTVRG || curSym->usage & LINTVRG)) {
		if (!(p1 == PNIL && p2 == PNIL)) {
			LERROR(WDECLAR, MSGSTR(M_MSG_310,
				"function %s argument count mismatch"),
				curSym, CRUSE);
			return (0);
		}
	}
	return (1);
}

/*
** Check if struct/union/enum members are identical.
*/
SameMembers(p, q)
	SMTAB *p, *q;
{
	register MBTAB *mp, *mq;
	TWORD bt;

	/* Same symbol check. */
	if (p == q)
		return (1);

	/* Member count check. */
	if (p->nmbrs != q->nmbrs)
		return (0);

	/* Compare each member. */
	mp = p->mbrs; mq = q->mbrs;
	while (mp) {
#ifdef	DEBUG
		if (debug)
			printf("\tcomparing %s vs. %s\n",mp->mname,mq->mname);
#endif
		if (strcmp(mp->mname, mq->mname))
			return (0);
		if (!SameTypes(mp->type, mq->type))
			return (0);
		if ((bt = BTYPE(mp->type)) == STRTY || bt == UNIONTY ||
			bt == ENUMTY)
			/* if one or the other (but not both) are null OR 
			   both are not null and strings are different */
			if ((!!mp->tagname) ^ (!!mq->tagname) ||
			     (mp->tagname && mq->tagname && 
			     strcmp(mp->tagname, mq->tagname)))
				return(0);
		mp = mp->next; mq = mq->next;
	}
	return (1);
}

/*
** Examine symbol for proper reference/definitions usage.
*/
RefDefSymbol(h)
	register SMTAB *h;
{
	switch (h->usage & (LINTREF|LINTDEF|LINTDCL)) {
	case LINTREF|LINTDCL:
		if (!(h->usage & LINTNDF)) {
			if (ISFTN(h->type))
				LERROR(WUSAGE, MSGSTR(M_MSG_311,
					"function %s used but not defined"), h, RUSE);
			else
				LERROR(WUSAGE, MSGSTR(M_MSG_312,
					"symbol %s used but not defined"), h, RUSE);
		}
		break;
	case LINTDEF:
	case LINTDEF|LINTDCL:
		if (!(h->usage & LINTNOT)) {
			if (ISFTN(h->type)) {
				if (strcmp(h->sname, "main") && !(h->usage & LINTLIB))
					LERROR(WUSAGE, MSGSTR(M_MSG_313,
						"function %s defined but never used"),
						h, DUSE);
			}
			else
				LERROR(WUSAGE, MSGSTR(M_MSG_314,
					"symbol %s defined but never used"), h, DUSE);
		}
		break;
	case LINTDCL:
		if (!(h->usage & LINTNOT) && !(h->usage & LINTNDF)) {
			if (ISFTN(h->type))
				LERROR(WUDECLAR, MSGSTR(M_MSG_315,
			  	"function %s declared but never used or defined"),
			  	h, RUSE);
			else
				LERROR(WUDECLAR, MSGSTR(M_MSG_316,
			  	"symbol %s declared but never used or defined"),
			  	h, RUSE);
		}
		break;
	}
}

/*
** Examine function for proper/consistent usage.
*/
FtnUsage(h)
	register SMTAB *h;
{
	switch (h->usage & (LINTRET|LINTUSE|LINTIGN)) {
	case LINTUSE:
	case LINTUSE|LINTIGN:
		LERROR(WUSAGE, MSGSTR(M_MSG_317,
			"function %s return value used, but none returned"),
			h, RUSE);
		break;

	case LINTRET|LINTIGN:
		LERROR(WUSAGE, MSGSTR(M_MSG_318,
			"function %s return value is always ignored"),h,DUSE);
		break;

	case LINTRET|LINTUSE|LINTIGN:
		LERROR(WUSAGE, MSGSTR(M_MSG_319,
			"function %s return value is sometimes ignored"),
			h, DUSE);
		break;
	}
}
