/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
#if !defined(lint) && !defined(_NOIDENT)
static char rcsid[] = "@(#)$RCSfile: NLescstr.c,v $ $Revision: 1.2 $ (OSF) $Date: 1994/11/19 02:02:35 $";
#endif
/*
 * COMPONENT_NAME: (LIBCNLS) Standard C Library National Language Support
 *
 * FUNCTIONS: NLescstr
 *
 * ORIGINS: 27
 *
 * IBM CONFIDENTIAL -- (IBM Confidential Restricted when
 * combined with the aggregated modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * NLescstr.c	1.7  com/lib/c/nls,3.1,9013 1/18/90 09:44:16
 */

#include <NLctype.h>

/*
 * NAME: NLescstr
 *
 * FUNCTION: Translate each NLS code point in src into a printable esc 
 *	     sequence in standard ASCII unique to that code point.
 *
 * RETURN VALUE DESCRIPTION: The length of a resulting string

 */
/*
 *  Translate each NLS code point in src into a printable escape sequence
 *  in standard ASCII unique to that code point.  Return length of resulting
 *  string.
 */
int
NLescstr(src, dest, dlen)
register unsigned char *src, *dest;	/* a source and destination strings */
register int dlen;       	/* the length of dest string */
{
	register int n;
	NLchar nlc;		        
	unsigned char *odest = dest;	/* the next char position */

	/*  Always NUL-terminate output string, if any; but never count
	 *  NUL as part of length.
	 */
	for ( ; dlen && *src; --dlen)   
		if (n = NLisNLcp(src)) {	/* test if src is NLchars */
			if (dlen < NLESCMAX)
				break;
			nlc = NCdechr(src);	/* change to NLchar */
			src += n;
			n = NCesc(&nlc, dest);	/* Esc sequence */
			dest += n;
			dlen -= n - 1;
		} else
			*dest++ = *src++;
	if (odest < dest) {			/* more char ? */
		if (!dlen)			/* dlen = 0 ? */
			--dest;
		*dest = '\0';
	}
	return (dest - odest);
}
