/*
 * 
 * $Copyright
 * Copyright 1993, 1994, 1995  Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/*
 * @OSF_FREE_COPYRIGHT@
 */
/* 
 * Mach Operating System
 * Copyright (c) 1991 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log: xmm_zero.c,v $
 * Revision 1.2  1994/11/19  02:38:50  mtm
 * Copyright additions/changes
 *
 * Revision 1.1  1993/06/23  01:07:59  stans
 * Initial revision
 *
 * Revision 1.2  1992/05/12  14:51:49  devrcs
 * 	Created for OSF/1 MK
 * 	[1992/05/04  08:20:25  condict]
 *
 * Revision 2.3  92/01/22  22:55:05  rpd
 * 	Replaced old IPC types.
 * 	[92/01/18            rpd]
 * 
 * 	Fixed includes to use "" when appropriate.
 * 	[92/01/18            rpd]
 * 
 * Revision 2.2  91/07/06  15:08:19  jsb
 * 	First checkin.
 * 
 * $EndLog$
 */
/*
 *	File:	xmm_zero.c
 *	Author:	Joseph S. Barrera III
 *	Date:	1991
 *
 *	Xmm class providing zero filled data.
 */

#include <mach.h>
#include "xmm_obj.h"

kern_return_t m_zero_init();
kern_return_t m_zero_terminate();
kern_return_t m_zero_data_request();

xmm_decl(zero_class,
	/* m_init		*/	m_zero_init,
	/* m_terminate		*/	m_zero_terminate,
	/* m_copy		*/	m_invalid_copy,
	/* m_data_request	*/	m_zero_data_request,
	/* m_data_unlock	*/	m_invalid_data_unlock,
	/* m_data_write		*/	m_invalid_data_write,
	/* m_lock_completed	*/	m_invalid_lock_completed,
	/* m_supply_completed	*/	m_invalid_supply_completed,
	/* m_data_return	*/	m_invalid_data_return,

	/* k_data_provided	*/	k_invalid_data_provided,
	/* k_data_unavailable	*/	k_invalid_data_unavailable,
	/* k_get_attributes	*/	k_invalid_get_attributes,
	/* k_lock_request	*/	k_invalid_lock_request,
	/* k_data_error		*/	k_invalid_data_error,
	/* k_set_attributes	*/	k_invalid_set_attributes,
	/* k_destroy		*/	k_invalid_destroy,
	/* k_data_supply	*/	k_invalid_data_supply,

	/* name			*/	"zero",
	/* size			*/	sizeof(struct xmm_obj)
);

xmm_zero_create(new_mobj)
	xmm_obj_t *new_mobj;
{
	return xmm_obj_allocate(&zero_class, XMM_OBJ_NULL, new_mobj);
}

m_zero_init(mobj, k_kobj, memory_object_name, page_size)
	xmm_obj_t mobj;
	xmm_obj_t k_kobj;
	mach_port_t memory_object_name;
	vm_size_t page_size;
{
	xmm_obj_t kobj = mobj;

#if     lint
	page_size++;
	memory_object_name++;
#endif  lint
	if (kobj->k_kobj) {
		_K_DESTROY(k_kobj, KERN_FAILURE);
		return;
	}
	k_kobj->m_kobj = kobj;
	kobj->k_kobj = k_kobj;
	K_SET_ATTRIBUTES(kobj, TRUE, FALSE, MEMORY_OBJECT_COPY_DELAY);
}

m_zero_terminate(mobj, kobj, memory_object_name)
	xmm_obj_t mobj;
	xmm_obj_t kobj;
	mach_port_t memory_object_name;
{
#if     lint
	mobj++;
	kobj++;
	memory_object_name++;
#endif  lint
}

m_zero_data_request(mobj, kobj, offset, length, desired_access)
	xmm_obj_t mobj;
	xmm_obj_t kobj;
	vm_offset_t offset;
	vm_size_t length;
	vm_prot_t desired_access;
{
#if     lint
	mobj++;
	desired_access++;
#endif  lint
	K_DATA_UNAVAILABLE(kobj, offset, length);
}
