/*
 * 
 * $Copyright
 * Copyright 1993, 1994 , 1995 Intel Corporation
 * INTEL CONFIDENTIAL
 * The technical data and computer software contained herein are subject
 * to the copyright notices; trademarks; and use and disclosure
 * restrictions identified in the file located in /etc/copyright on
 * this system.
 * Copyright$
 * 
 */
 
/* 
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * Copyright (c) 1991-1995, Locus Computing Corporation
 * All rights reserved
 */
/*
 * HISTORY
 * $Log: inittodr.c,v $
 * Revision 1.8  1995/02/01  22:26:19  bolsen
 *  Reviewer(s): Jerry Toman
 *  Risk: Medium (lots of files)
 *  Module(s): Too many to list
 *  Configurations built: STD, LITE, & RAMDISK
 *
 *  Added or Updated the Locus Copyright message.
 *
 * Revision 1.7  1994/11/18  20:48:36  mtm
 * Copyright additions/changes
 *
 * Revision 1.6  1994/01/12  17:46:19  jlitvin
 * Checked in some preliminary changes to make lint happier.
 *
 *  Reviewer: none
 *  Risk: low
 *  Benefit or PTS #: Reduce lint complaints.
 *  Testing: compiled server
 *  Module(s):
 * 	uxkern/vm_unix.c
 * 	uxkern/ux_server_loop.c
 * 	uxkern/tty_io.c
 * 	uxkern/syscall.c
 * 	uxkern/server_init.c
 * 	uxkern/raw_hippi.c
 * 	uxkern/misc.c
 * 	uxkern/mf.c
 * 	uxkern/inittodr.c
 * 	uxkern/hippi_io.c
 * 	uxkern/fsvr_subr.c
 * 	uxkern/fsvr_server_side.c
 * 	uxkern/fsvr_rmtspec_ops.c
 * 	uxkern/fsvr_port.c
 * 	uxkern/fsvr_msg.c
 * 	uxkern/ether_io.c
 * 	uxkern/disk_io.c
 * 	uxkern/device_reply_hdlr.c
 * 	uxkern/credentials.c
 * 	uxkern/cons.c
 * 	uxkern/bsd_server_side.c
 * 	uxkern/boot_config.c
 * 	uxkern/block_io.c
 * 	uxkern/rpm_clock.c
 * 	i386/conf.c
 * 	i860/conf.c
 *
 * Revision 1.5  1993/10/29  11:55:48  paul
 * Add support for setting and using the RPM distributed time-of-day clock.
 *
 * Revision 1.4  1993/07/14  18:42:32  cfj
 * OSF/1 AD 1.0.4 code drop from Locus.
 *
 * Revision 1.1.1.3  1993/07/01  21:03:32  cfj
 * Adding new code from vendor
 *
 * Revision 1.3  1993/05/06  19:30:24  nandy
 * ad103+tnc merged with Intel code.
 *
 *
 * Revision 1.1.2.1  1992/11/05  23:43:44  dleslie
 * Local changes for NX through noon, November 5, 1992.
 *
 * Revision 4.1  1992/11/04  00:53:35  cfj
 * Bump major revision number.
 *
 * Revision 1.1.1.1  1993/05/03  17:52:53  cfj
 * Initial 1.0.3 code drop
 *
 * Revision 2.4  1993/04/08  11:39:49  loverso
 * 	Charles Silvers changes from CMU (check hardware clock)
 * 	[1992/06/25  13:12:30  emcmanus]
 *
 * Revision 2.3  91/12/17  09:34:25  roy
 * 	91/10/23  16:39:05  condict
 * 	Change use of time var to new_time, to avoid confusion with global 
 * 	time var, and replace get_time calls with access to global time var.
 * 
 * Revision 2.2  91/08/31  14:26:31  rabii
 * 	Initial V2.0 Checkin
 * 
 * Revision 3.0  91/01/17  12:06:07  condict
 * Unchanged copy from Mach 3.0 BSD UNIX server
 * 
 * Revision 2.2  89/12/08  20:18:42  rwd
 * 	Set boottime also, to make uptime and w happy.
 * 	[89/12/05            af]
 * 
 * Revision 2.1  89/08/04  14:51:35  rwd
 * Created.
 * 
 * 26-Jun-89  Randall Dean (rwd) at Carnegie-Mellon University
 *	Added copyright to file by dbg.  Fixed cvttime to adjust for
 *	timezone.  Haven't figured out DST yet.
 *
 */
/*
 * Routines to guess the time.
 */
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/kernel.h>

/*
 * Time conversion.
 */

#define	SECS_PER_MIN	60
#define	MINS_PER_HOUR	60
#define	HOURS_PER_DAY	24
#define	DAYS_PER_WEEK	7
#define	DAYS_PER_NYEAR	365
#define	DAYS_PER_LYEAR	366
#define	SECS_PER_HOUR	(SECS_PER_MIN * MINS_PER_HOUR)
#define	SECS_PER_DAY	((long) SECS_PER_HOUR * HOURS_PER_DAY)
#define	MONS_PER_YEAR	12

#define	TM_SUNDAY	0
#define	TM_MONDAY	1
#define	TM_TUESDAY	2
#define	TM_WEDNESDAY	3
#define	TM_THURSDAY	4
#define	TM_FRIDAY	5
#define	TM_SATURDAY	6

#define	TM_JANUARY	0
#define	TM_FEBRUARY	1
#define	TM_MARCH	2
#define	TM_APRIL	3
#define	TM_MAY		4
#define	TM_JUNE		5
#define	TM_JULY		6
#define	TM_AUGUST	7
#define	TM_SEPTEMBER	8
#define	TM_OCTOBER	9
#define	TM_NOVEMBER	10
#define	TM_DECEMBER	11

#define	TM_YEAR_BASE	1900

#define	EPOCH_YEAR	1970
#define	EPOCH_WDAY	TM_THURSDAY

/*
** Accurate only for the past couple of centuries;
** that will probably do.
*/

#define	isleap(y) (((y) % 4) == 0 && ((y) % 100) != 0 || ((y) % 400) == 0)

int	mon_lengths[2][MONS_PER_YEAR] = {
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
	31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

int	year_lengths[2] = {
	DAYS_PER_NYEAR, DAYS_PER_LYEAR
};


cvttime(clock, tmp)
time_t			clock;		/* seconds since 1 Jan 1970 */
register struct tm *	tmp;
{
	register long		days;
	register long		rem;
	register int		y;
	register int		yleap;
	register int *		ip;
	struct tm		tm;

	days = (clock - tz.tz_minuteswest*SECS_PER_MIN) / SECS_PER_DAY;
	rem  = (clock - tz.tz_minuteswest*SECS_PER_MIN) % SECS_PER_DAY;
	while (rem < 0) {
	    rem += SECS_PER_DAY;
	    --days;
	}
	while (rem >= SECS_PER_DAY) {
	    rem -= SECS_PER_DAY;
	    ++days;
	}

	tm.tm_hour = (int) (rem / SECS_PER_HOUR);
	rem = rem % SECS_PER_HOUR;
	tm.tm_min = (int) (rem / SECS_PER_MIN);
	tm.tm_sec = (int) (rem % SECS_PER_MIN);

	tm.tm_wday = (int) ((EPOCH_WDAY + days) % DAYS_PER_WEEK);
	if (tm.tm_wday < 0)
	    tm.tm_wday += DAYS_PER_WEEK;

	y = EPOCH_YEAR;
	if (days >= 0) {
	    for (;;) {
		yleap = isleap(y);
		if (days < (long) year_lengths[yleap])
		    break;
		++y;
		days = days - (long) year_lengths[yleap];
	    }
	}
	else {
	    do {
		--y;
		yleap = isleap(y);
		days = days + (long) year_lengths[yleap];
	    } while (days < 0);
	}
	tm.tm_year = y - TM_YEAR_BASE;
	tm.tm_yday = (int) days;

	ip = mon_lengths[yleap];
	for (tm.tm_mon = 0;
	     days >= (long) ip[tm.tm_mon];
	     ++tm.tm_mon) {
	    days = days - (long) ip[tm.tm_mon];
	}
	tm.tm_mday = (int) (days + 1);
	tm.tm_isdst = 0;

	*tmp = tm;
}

fmttime(timeptr, str)
register struct tm *timeptr;
char		str[26];
{
	static char	wday_name[DAYS_PER_WEEK][3] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
	};
	static char	mon_name[MONS_PER_YEAR][3] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};

	sprintf(str, "%.3s %.3s%3d %02d:%02d:%02d %d",
		wday_name[timeptr->tm_wday],
		mon_name[timeptr->tm_mon],
		timeptr->tm_mday, timeptr->tm_hour,
		timeptr->tm_min, timeptr->tm_sec,
		TM_YEAR_BASE + timeptr->tm_year);
}	

print_time(fmt, clock)
	char *	fmt;
	time_t	clock;
{
	struct tm	tm;
	char		timestr[26];

	cvttime(clock, &tm);
	fmttime(&tm, timestr);
	printf(fmt, timestr);
}

/*
 * Initialize the time of day.
 */
#define	SECYR		((unsigned)(365*SECS_PER_DAY))	/* per common year */

/*
 * If the hardware clock does not keep the current year, it
 * sets the year to 1982.  If there is no hardware clock at all,
 * the year will be about 1970.
 */
#define	NOYEAR		((1982 - EPOCH_YEAR) * SECYR + 3 * SECS_PER_DAY)
			/* 1972, 1976, 1980 were leap years */

/*
 * Initialze the time of day register, based on the time base which is, e.g.
 * from a filesystem.  Base provides the time to within six months,
 * and the time of year clock provides the rest.
 */
inittodr(base)
	time_t base;
{
	long		deltat;
	int		year = EPOCH_YEAR;

	struct timeval	cur_time, new_time;

	new_time.tv_usec = 0;

  print_time("Base is %s\n", base);

	if (base < 5*SECYR) {
	    printf("WARNING: preposterous time in file system");
	    new_time.tv_sec = 6*SECYR + 186*SECS_PER_DAY + SECS_PER_DAY/2;
	    goto check;
	}

	TIME_READ_LOCK();
	cur_time = time;
	TIME_READ_UNLOCK();
	boottime = cur_time;

  print_time("Current time is %s\n", cur_time.tv_sec);

	/*
	 * On some machines the hardware only provides the time-in-the-year.
	 * This might result in the filesystem being ahead of the current
	 * time.  This is more likely the case than having a bogus time in
	 * the filesystem.
	 */
	if (cur_time.tv_sec < base) {
		printf("This is strange");
		new_time.tv_sec = base;
		new_time.tv_usec = 0;
		boottime.tv_sec = base;
		boottime.tv_usec = 0;
		goto check;
	}

	/*
	 * If the hardware does not provide the year,
	 * the time will be stuck at 1982.	XXX
	 */
	if (cur_time.tv_sec < NOYEAR) {
	    printf("WARNING: hardware does not know what time it is");
	    /*
	     * Believe the time in the file system for lack of
	     * anything better.
	     */
	    new_time.tv_sec = base;
	    new_time.tv_usec = 0;
	    goto check;
	}

	/*
	 * Sneak to within 6 month of the time in the filesystem,
	 * by starting with the time of the year suggested by the TODR,
	 * and advancing through succesive years.  Adding the number of
	 * seconds in the current year takes us to the end of the current year
	 * and then around into the next year to the same position.
	 */
	new_time.tv_sec = cur_time.tv_sec - NOYEAR;
	while (new_time.tv_sec < base-SECYR/2) {
	    if (isleap(year))
		new_time.tv_sec += SECS_PER_DAY;
	    year++;
	    new_time.tv_sec += SECYR;
	}

	/*
	 * See if we gained/lost two or more days;
	 * if so, assume something is amiss.
	 */
	deltat = new_time.tv_sec - base;
	if (deltat < 0)
	    deltat = -deltat;
	if (deltat < 2*SECS_PER_DAY) {
	    /*
	     * Time seems to correspond.
	     */
	    goto set_the_time;
	}

	printf("WARNING: clock %s %d days",
	    new_time.tv_sec < base ? "lost" : "gained", deltat / SECS_PER_DAY);
check:
	printf(" -- CHECK AND RESET THE DATE!\n");
	boottime.tv_sec = new_time.tv_sec;

set_the_time:
  print_time("Time is set to %s\n", new_time.tv_sec);
	set_time(&new_time);

#if defined(__i860__) && defined(TNC)
	if(check_for_rpm()){
		rpm_set_time(&new_time);
	}
#endif /* defined(__i860__) && defined(TNC) */

}

