'(These are some of the benchmark programs
used to compare LISP interpreters in the
LISP article in September 1981 BYTE)

DEFINE ((
(BUILD-LONG-CONS (LENGTH ELEMENT) (COND
	((ZEROP LENGTH) NIL)
	(T (LIST 'CONS (LIST 'QUOTE ELEMENT)
		       (BUILD-LONG-CONS (DIFFERENCE LENGTH 1) ELEMENT)))))
(BUILD-DEEP-CONS (DEPTH ELEMENT) (COND
	((ZEROP DEPTH) (LIST 'QUOTE ELEMENT))
	(T (LIST 'CONS (BUILD-DEEP-CONS (DIFFERENCE DEPTH 1) ELEMENT) NIL))))
(NESTED-APPLICATION (FUNCTION LENGTH ARG) (COND
	((ZEROP LENGTH) ARG)
	(T (LIST FUNCTION (NESTED-APPLICATION FUNCTION (DIFFERENCE LENGTH 1)
						       ARG)))))
(HAS-AS-MEMBER-R (ELEMENT LST) (COND
	((NULL LST) NIL)
	((EQ ELEMENT (CAR LST)) T)
	(T (HAS-AS-MEMBER-R ELEMENT (CDR LST)))))
(REMOVE-ELEMENT-R (ELEMENT LST) (COND
	((NULL LST) NIL)
	((EQ ELEMENT (CAR LST)) (REMOVE-ELEMENT-R ELEMENT (CDR LST)))
	(T (CONS (CAR LST) (REMOVE-ELEMENT-R ELEMENT (CDR LST))))))
(HAS-AS-MEMBER-I (ELEMENT LST) (PROG (CDR-LST)
	(SETQ CDR-LST LST)
LOOP	(COND ((NULL CDR-LST) (RETURN NIL))
	      ((EQ (CAR CDR-LST) ELEMENT) (RETURN T)))
	(SETQ CDR-LST (CDR CDR-LST))
	(GO LOOP)))
))

(SETQ LC (BUILD-LONG-CONS 50 'A))

(SETQ DC (BUILD-DEEP-CONS 50 'A))

(SETQ LONG (EVAL LC))

(SETQ DEEP (EVAL DC))

(SETQ BIGCAR (NESTED-APPLICATION 'CAR 49 'DEEP))

(SETQ BIGCDR (NESTED-APPLICATION 'CDR 49 'LONG))

(SETQ LONG1 (APPEND LONG '(B)))

DEFINE ((
(MIX-4-1 (LENGTH E1 E2) (COND
	((LESSP LENGTH 1) NIL)
	(T (APPEND (LIST E1 E1 E1 E1 E2)
		   (MIX-4-1 (DIFFERENCE LENGTH 5) E1 E2]

(SETQ LONG41 (MIX-4-1 50 'A 'B))

DEFINE ((
(TESTER (FORM) (PROG (COUNT)
	(SETQ COUNT 0)
	(COLLECT)
LOOP	(EVAL FORM)
	(SETQ COUNT (PLUS COUNT 1))
	(GO LOOP]
