/*
 *	$Source: /u1/X/DECToolkit/src/RCS/Text.h,v $
 *	$Header: Text.h,v 1.1 86/12/17 09:04:45 swick Exp $
 */

/*
 *			  COPYRIGHT 1986
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
 * APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
 * SET FORTH ABOVE.
 *
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting documentation,
 * and that the name of Digital Equipment Corporation not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission.
 */

/* Text.h   -  include file for Text.c */
/* larson:	11-Nov-86 */

#ifndef CURSORS
#include "left_ptr.cursor"
#include "left_ptr_mask.cursor"
#define insertCursor_width 6
#define insertCursor_height 3
static short insertCursor_mask[] = {0x000c, 0x001e, 0x0033};
static short insertCursor_bits[] = {0x000c, 0x001e, 0x0033};
static Bitmap insertCursorMask = 0;
#endif

#ifdef SCROLLBAR
extern Window TArrangeWithScrollBars();
extern Window TAddScrollBar();
#endif

#define DEFAULT_FONT    "/usr/lib/Xfont/9x15.onx"
#define TEXT_EVENTS  ButtonPressed | ButtonReleased | LeftDownMotion | \
	    RightDownMotion | KeyPressed | ExposeWindow | ExposeRegion | \
	    ExposeCopy
#define BufMax 1000
#define abs(x)		(((x) < 0) ? (-(x)) : (x))
#define min(x,y)	((x) < (y) ? (x) : (y))
#define max(x,y)	((x) > (y) ? (x) : (y))
#define IsPositionVisible(ctx, pos)	\
			(pos >= ctx->lt.entry[0].position && \
			 pos <= ctx->lt.entry[ctx->lt.lines].position)

/*
 * notify used to signal the users program that a certain character has
 * been typed. 
 */
typedef struct _TNotify {
    char *symbols;     /** characters that signify notify **/
    int (*routine)();  /** user's routine to call when notify occurs **/
    caddr_t tag;       /** argument passed to above procedure **/
} TNotify;


typedef struct _LineTableEntry {
    TTextPosition position;	/** last position of previous line **/
				/** ie. where this line should start from **/
    int x, y, 			/** starting x, y coord for this line **/
	endX;			/** ending x coordinate for this line **/
    } LineTableEntry, *LineTableEntryPtr;
/*
 * Line Tables are n+1 long - e.g. last position displayed is in last lt entry 
 */
typedef struct _LineTable {
    TTextPosition top;	/* Top of the displayed text. */
    int lines;		/* How many lines in this table. */
    LineTableEntry *entry;	/* A dynamic array, one entry per line */
    } LineTable, *LineTablePtr;

/*
 * cursor insertion 
 */
enum InsertState {on, off};
typedef struct _Insertion {
    TTextPosition position;
    enum InsertionType type;
    } Insertion, *InsertionPtr;

/*
 * every text window has one of the following structures assoiciated with it.
 */
typedef struct  _TextSWContext {
    TTextSource *source;/* pointer to source structure */
    TTextSink *sink;	/* pointer to sink structure */
    LineTable lt;	/* structure for line table */
    Selection s;	/* structure for text selection */
    Insertion i;	/* structure for cursor insertion */
    short width,height;	/* Dimensions of the text subwindow */
    short leftmargin;	/* Width of left margin. */
    short options;	/* wordbreak, scroll, etc. */
    Window sbar;	/* The vertical scroll bar.  If none, this is zero. */
    Window w;		/* Actual window containing text.  */
    TNotify notify;
    int bkgrd_pix,
	foregrd_pix;
} TextSWContext, *TextSWContextPtr;


static int myContext;
static char *buf;
static int initialized = 0;
static Window window_with_selection; /* used for mutually exclusive selection*/
static TTextSink *defaultSink;

