/*
* $Header: IconP.h,v 1.0 88/06/9 09:27:32 swick Exp $
*/


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/*
	Modified LabelP.h to handle Pixmaps
*/

/* 
 * IconP.h - Private definitions for Icon widget
 * 
 */

#ifndef _XtIconP_h
#define _XtIconP_h

/***********************************************************************
 *
 * Icon Widget Private Data
 *
 ***********************************************************************/

#include <X11/Icon.h>
#include <X11/SimpleP.h>


/* New fields for the Icon widget class record */

typedef struct {int foo;} IconClassPart;

/* Full class record declaration */
typedef struct _IconClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    IconClassPart	icon_class;
} IconClassRec;

extern IconClassRec iconClassRec;

/* New fields for the Icon widget record */
typedef struct {
    /* resources */
    Pixel	foreground;
    Pixel	background;
    caddr_t     bitmap_data;
    Dimension	internal_width;
    Dimension	internal_height;
    Dimension	icon_width;
    Dimension	icon_height;

    /* private state */
    GC		normal_GC;
    GC          invr_GC;
    GC          gray_GC;
    Position	icon_x;
    Position	icon_y;
    Pixmap      inverse_icon_pixmap;
    Pixmap      icon_pixmap;
} IconPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _IconRec {
    CorePart	core;
    SimplePart	simple;
    IconPart	icon;
} IconRec;

#endif _XtIconP_h
