/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Get the Pixel for a given colour name
 */

#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>

#define FER_NOCOLOR	"Colour not supported"

extern Widget toplevel;

Pixel init_colour(colrname)
	char *colrname;
{
	XColor hard;
	XColor exact;

	if (strcmp(colrname, "white") == 0)
		return(WhitePixelOfScreen(XtScreen(toplevel)));
	else if (strcmp(colrname, "black") == 0)
		return(BlackPixelOfScreen(XtScreen(toplevel)));
	else if (CellsOfScreen(XtScreen(toplevel)) > 2) {
		if (XAllocNamedColor(XtDisplay(toplevel),
			DefaultColormapOfScreen(XtScreen(toplevel)),
			colrname, &hard, &exact) == NULL)
			ferr(FER_NOCOLOR);
		return(hard.pixel);
	} else
		return(BlackPixelOfScreen(XtScreen(toplevel)));
}

