/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * Creates standard titles and popup text input panels
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Atoms.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/Shell.h>
#include <X11/AsciiText.h>
#include <X11/Label.h>
#include <X11/LabelP.h>
#include <X11/Viewport.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Icon.h>
#include <X11/ICommand.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/title.h"
#include "../icons/cancel.icn"
#include "../icons/reset.icn"
#include "../icons/accept.icn"
#include "../icons/newname.icn"

/*
 * Global vars.
 */
extern Widget toplevel;
extern void help_call();

/*
 * Create title bar for all panels
 */
void title_creat(topl, fgr, bgr, setwidth, prefix, callb,
	helphead, iconflg,
	opbut, opbut_bits, opbut_width, opbut_height,
	formw, firstbw, secndbw, thirdbw, opbw, titlew)
	Widget topl;
	char *fgr, *bgr;
	int setwidth;
	char *prefix;
	void (*(callb))();
	HelpList *helphead;
	int iconflg;
	char *opbut;
	char *opbut_bits;
	int opbut_width, opbut_height;
	Widget *formw, *titlew, *opbw, *firstbw, *secndbw, *thirdbw;
{
	int widv;
	int i;
	Widget cw;
	XtArgVal fg, bg;
	XtTranslations cmdtrn;
	static char helpname[NAMSIZ+1];
	static char topltrans[] =
		"<Btn2Down>: enablenotify() \n\
		 <Btn2Up>:   notify(Help) disablenotify()";
	static char ctrlbuttrans[] =
	"<Btn1Down>:	set() enablenotify() \n\
	<Btn1Up>:		notify() disablenotify() unset() \n\
	<Btn2Down>:	enablenotify() \n\
	<Btn2Up>:	notify(Help) disablenotify() \n\
	<EnterWindow>:	highlight() \n\
	<LeaveWindow>:	unset(NoRedisplay) disablenotify() unhighlight()";
	static XtCallbackRec helpcall[] = {
		{help_call,	NULL},
		{NULL,		NULL},
	};
	static XtCallbackRec cmdcall[] = {
		{NULL,		NULL},
		{NULL,		NULL},
	};
	static Arg topllist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNwidth,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) helpcall},
	};
	static Arg titlelist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNwidth,		(XtArgVal) NULL},
		{XtNheight,		(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNjustify,		(XtArgVal) XtJustifyCenter},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNbottom,		(XtArgVal) XtChainTop},
	};
	static Arg iconlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNbitmapData,		(XtArgVal) NULL},
		{XtNiconWidth,	(XtArgVal) NULL},
		{XtNiconHeight,	(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNbottom,		(XtArgVal) XtChainTop},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg cmdlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNtop,		(XtArgVal) XtChainTop},
		{XtNbottom,		(XtArgVal) XtChainTop},
		{XtNcallback,		(XtArgVal) cmdcall},
	};

	/* Create the Form that the top level panel is laid out in */
	topllist[0].value = fg = (XtArgVal) init_colour(fgr);
	topllist[1].value = bg = (XtArgVal) init_colour(bgr);
	topllist[3].value = (XtArgVal) XtParseTranslationTable(topltrans);
	*formw = XtCreateManagedWidget("topl", formWidgetClass,
		topl, topllist, XtNumber(topllist));
	add_help(prefix, helphead, *formw);
	i = strlen(prefix);
	bcopy(prefix, helpname, i);
	/* now for the control buttons */
	if (iconflg) {
		/* Cancel widget */
		iconlist[0].value = (XtArgVal) fg;
		iconlist[1].value = (XtArgVal) bg;
		iconlist[2].value = (XtArgVal) cancel_bits;
		iconlist[3].value = (XtArgVal) cancel_width;
		iconlist[4].value = (XtArgVal) cancel_height;
		iconlist[5].value = (XtArgVal) XtParseTranslationTable(ctrlbuttrans);
		iconlist[6].value = (XtArgVal) NULL;
		cmdcall[0].callback = callb;
		cmdcall[0].closure = (caddr_t) 0;
		*firstbw = cw = XtCreateManagedWidget("ctrlb0", icommandWidgetClass,
			*formw, iconlist, XtNumber(iconlist));
		bcopy(".Cancel", helpname+i, 8);
		add_help(helpname, helphead, cw);
		/* Reset widget */
		iconlist[2].value = (XtArgVal) reset_bits;
		iconlist[3].value = (XtArgVal) reset_width;
		iconlist[4].value = (XtArgVal) reset_height;
		iconlist[6].value = (XtArgVal) cw;
		cmdcall[0].closure = (caddr_t) 1;
		*secndbw = cw = XtCreateManagedWidget("ctrlb1", icommandWidgetClass,
			*formw, iconlist, XtNumber(iconlist));
		bcopy(".Reset", helpname+i, 7);
		add_help(helpname, helphead, cw);
		/* Accept widget */
		iconlist[2].value = (XtArgVal) accept_bits;
		iconlist[3].value = (XtArgVal) accept_width;
		iconlist[4].value = (XtArgVal) accept_height;
		iconlist[6].value = (XtArgVal) cw;
		cmdcall[0].closure = (caddr_t) 2;
		*thirdbw = cw = XtCreateManagedWidget("ctrlb2", icommandWidgetClass,
			*formw, iconlist, XtNumber(iconlist));
		bcopy(".Accept", helpname+i, 8);
		add_help(helpname, helphead, cw);
		if (opbut != NULL) {
			/* Create other button */
			iconlist[2].value = (XtArgVal) opbut_bits;
			iconlist[3].value = (XtArgVal) opbut_width;
			iconlist[4].value = (XtArgVal) opbut_height;
			iconlist[6].value = (XtArgVal) cw;
			cmdcall[0].closure = (caddr_t) 3;
			*opbw = cw = XtCreateManagedWidget("ctrlb3", icommandWidgetClass,
				*formw, iconlist, XtNumber(iconlist));
			bcopy(".Opbut", helpname+i, 7);
			add_help(helpname, helphead, cw);
			widv = 4*ICONBUTWIDTH;
		} else
			widv = 3*ICONBUTWIDTH;
	} else {
		/* Cancel widget */
		cmdlist[0].value = (XtArgVal) fg;
		cmdlist[1].value = (XtArgVal) bg;
		cmdlist[2].value = (XtArgVal) "Cancel";
		cmdlist[3].value = (XtArgVal) XtParseTranslationTable(ctrlbuttrans);
		cmdlist[4].value = (XtArgVal) NULL;
		cmdcall[0].callback = callb;
		cmdcall[0].closure = (caddr_t) 0;
		*firstbw = cw = XtCreateManagedWidget("ctrlb0", commandWidgetClass,
			*formw, cmdlist, XtNumber(cmdlist));
		bcopy(".Cancel", helpname+i, 8);
		add_help(helpname, helphead, cw);
		/* Reset widget */
		cmdlist[2].value = (XtArgVal) "Reset ";
		cmdlist[4].value = (XtArgVal) cw;
		cmdcall[0].closure = (caddr_t) 1;
		*secndbw = cw = XtCreateManagedWidget("ctrlb1", commandWidgetClass,
			*formw, cmdlist, XtNumber(cmdlist));
		bcopy(".Reset", helpname+i, 7);
		add_help(helpname, helphead, cw);
		/* Accept widget */
		cmdlist[2].value = (XtArgVal) "Accept";
		cmdlist[4].value = (XtArgVal) cw;
		cmdcall[0].closure = (caddr_t) 2;
		*thirdbw = cw = XtCreateManagedWidget("ctrlb2", commandWidgetClass,
			*formw, cmdlist, XtNumber(cmdlist));
		bcopy(".Accept", helpname+i, 8);
		add_help(helpname, helphead, cw);
		/* opt button */
		if (opbut != NULL) {
			cmdlist[2].value = (XtArgVal) opbut;
			cmdlist[4].value = (XtArgVal) cw;
			cmdcall[0].closure = (caddr_t) 3;
			*opbw = cw = XtCreateManagedWidget("ctrlb3", commandWidgetClass,
				*formw, cmdlist, XtNumber(cmdlist));
			bcopy(".Opbut", helpname+i, 7);
			add_help(helpname, helphead, cw);
			widv = 4*BUTWIDTH;
		} else
			widv = 3*BUTWIDTH;
	}
	/* and the title bar (should be more that label someday) */
	titlelist[0].value = (XtArgVal) fg;
	titlelist[1].value = (XtArgVal) bg;
	if (setwidth > 0)
		titlelist[2].value = (XtArgVal) setwidth-widv;
	else
		titlelist[2].value = (XtArgVal) NULL;
	if (iconflg)
		titlelist[3].value = (XtArgVal) 36;
	titlelist[4].value = (XtArgVal) prefix;
	titlelist[6].value = (XtArgVal) cw;
	*titlew = XtCreateManagedWidget("title", labelWidgetClass,
		*formw, titlelist, XtNumber(titlelist));
}

void dial_creat(parw, prefix, fgr, bgr, textfgr, textbgr, font, str, nstr, 
	ctrlcall, helphead, iconf,  dw, fw, lw, tw)
	Widget parw;
	char *prefix;
	char *fgr, *bgr, *textfgr, *textbgr;
	XFontStruct *font;
	char *str;
	int nstr;
	void (*(ctrlcall))();
	HelpList *helphead;
	int iconf;
	Widget *dw, *fw, *lw, *tw;
{
	int len;
	Widget cw, cw1, cw2, cw3, titw;
	static char helpname[NAMSIZ+1];

	static XtCallbackRec textcall[] = {
		{NULL,	(caddr_t)2},
		{NULL,	NULL},
	};
	static Arg popupdiallist[] = {
		{XtNx, (XtArgVal) NULL},
		{XtNy, (XtArgVal) NULL},
		{XtNgeometry, (XtArgVal) NULL},
		{XtNallowShellResize, (XtArgVal) True},
		{XtNsaveUnder, (XtArgVal) True},
	};
	static Arg label_args[] = {
		{XtNforeground, (XtArgVal) NULL},
		{XtNbackground, (XtArgVal) NULL},
		{XtNwidth,	(XtArgVal) NULL},
		{XtNlabel, (XtArgVal)NULL},
		{XtNfromVert,	(XtArgVal) NULL},
		{XtNfromHoriz,	(XtArgVal) NULL},
		{XtNborderWidth, (XtArgVal) 0}
	};
	static char texttrans[] =
	"<Key>0xff53:		forward-character() \n\
	<Key>0xff51:		backward-character() \n\
	<Key>0xffff:		delete-previous-character() \n\
	<Key>0xff08:		delete-previous-character() \n\
	<Key>0xff0d:		enablenotify() notify() disablenotify() \n\
	<Btn2Down>:		enablenotify() \n\
	<Btn2Up>:			notify(Help) disablenotify() \n\
	<LeaveWindow>:		disablenotify() \n\
	<Key>:			insert-ascii() \n\
	Shift<Key>:		insert-ascii()";
	static Arg text_args[] = {
		{XtNforeground,	(XtArgVal) NULL},
		{XtNbackground,	(XtArgVal) NULL},
		{XtNwidth, (XtArgVal)NULL},
		{XtNstring, (XtArgVal)NULL},
		{XtNlength, (XtArgVal)0},
		{XtNfromVert, (XtArgVal)NULL},
		{XtNresizable, (XtArgVal)TRUE},
		{XtNtextOptions, (XtArgVal)(resizeWidth | resizeHeight)},
		{XtNeditType, (XtArgVal)XttextEdit},
		{XtNright, (XtArgVal)XtChainRight},
		{XtNtranslations, (XtArgVal)NULL},
		{XtNcallback,	(XtArgVal) textcall},
	};
	*dw = XtCreatePopupShell("dialog", transientShellWidgetClass,
		parw, popupdiallist, XtNumber(popupdiallist));
	title_creat(*dw, fgr, bgr, 0, prefix, ctrlcall, helphead, iconf,
		NULL, NULL, 0, 0,
		fw, &cw1, &cw2, &cw3, &cw, &titw);
	label_args[0].value = (XtArgVal) init_colour(fgr);
	label_args[1].value = (XtArgVal) init_colour(bgr);
	label_args[2].value = (XtArgVal) (font->max_bounds.width*nstr+30);
	label_args[3].value = (XtArgVal)" ";
	label_args[4].value = (XtArgVal) cw1;
	*lw = XtCreateManagedWidget( "label", labelWidgetClass, *fw,
				        label_args, XtNumber(label_args) );
	text_args[0].value = (XtArgVal) init_colour(textfgr);
	text_args[1].value = (XtArgVal) init_colour(textbgr);
	text_args[2].value = (XtArgVal) (font->max_bounds.width*nstr+30);
	text_args[3].value = (XtArgVal)str;
	text_args[4].value = (XtArgVal)nstr;
	text_args[5].value = (XtArgVal)*lw;
	text_args[10].value = (XtArgVal)XtParseTranslationTable(texttrans);
	textcall[0].callback = ctrlcall;
	*tw = XtCreateManagedWidget("value",asciiStringWidgetClass,*fw,
					   text_args, XtNumber(text_args) );
	len = strlen(prefix);
	bcopy(prefix, helpname, len);
	bcopy(".Text", helpname+len, 6);
	add_help(helpname, helphead, *tw);
}

