/*

Copyright 1988 by the University of Guelph

Permission to use, copy and modify this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.
University of Guelph makes no representations about the suitability of
this software for any purpose.  It is provided "as is"
without express or implied warranty.

*/

/*
 * This component manages the top level panel.
 */
#include <X11/Xos.h>
#include <stdio.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Core.h>
#include <X11/CoreP.h>
#include <X11/Atoms.h>
#include <X11/Form.h>
#include <X11/Box.h>
#include <X11/Label.h>
#include <X11/Command.h>
#include <X11/ICommand.h>
#include <X11/Mailbox.h>
#include <X11/Clock.h>
#include <X11/Load.h>
#include "../include/tar.h"
#include "../include/help.h"
#include "../include/Xtty.h"
#include "../include/xgshconf.h"
#include "../include/xgshstate.h"
#include "../include/xgsherr.h"
#include "../include/gshdirs.h"
#include "../icons/dirb.icn"

/*
 * Global vars.
 */
extern Widget toplevel;
extern char **environ;
extern GshState	gshstate;	/* state struct for gsh		*/
extern GshConf *gconfptr;		/* conf. struct for gsh		*/
extern char outstr[OUTSTRL+1];	/* Cmd string displayed */
extern char blkstr[OUTSTRL+1];
extern char winstr[];		/* Hex string for Window id */

static char curdir[CURDIRL+1];
static int cmd_xpos, cmd_ypos;
static void ctrl_input();
static char dirbpath[MYMAXPATHLEN+1];
static char *dirbargv[20];
Boolean allocerr;
void help_call();
void cmd_popdown();

/*
 * This function deals with input to the top level panel.
 */
static void topl_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	Widget cur_cmdw;
	static Arg setpos[] = {
		{XtNx,		(XtArgVal) NULL},
		{XtNy,		(XtArgVal) NULL},
	};

	/* Handle other input (help..) */
	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
	if (gs->gs_notoplinput) {
		return;
	}
	if (gs->gs_logfile != NULL)
		gs->gs_slog.sl_chtopls++;
	cmd_popdown();
	gs->gs_curtoplevel = (int) p1;
	change_dir(gs->gs_curtoplevel);
	if (XtIsSensitive(gs->gs_topw[gs->gs_curtoplevel]))
		XtSetSensitive(gs->gs_topw[gs->gs_curtoplevel], False);
	cur_cmdw = gs->gs_cmdw[gs->gs_curtoplevel];
	setpos[0].value = (XtArgVal) cmd_xpos;
	setpos[1].value = (XtArgVal) cmd_ypos;
	XtSetValues(cur_cmdw, setpos, 2);
	XtPopup(cur_cmdw, XtGrabNone);
	if (gconfptr->gc_flags & G_WARPPOINTER)
		warp_pointer(gs->gs_defcmdw[gs->gs_curtoplevel]);
}

/*
 * Initialize the top level panel. Mostly call gen_topanel().
 */
init_topl()
{
	register GshConf *gc = gconfptr;
	register GshState *gs = &gshstate;
	register int i;
	register LevelConf *lp;
	int widv;
	char *opbut;
	Widget cw;
	XtTranslations cmdtrn;
	static char helpname[NAMSIZ+1];
	static char topbbtrans[] =
		"<Btn2Down>: enablenotify() \n\
		 <Btn2Up>:   notify(Help) disablenotify()";
	static char infotrans[] =
		"<Btn2Down>: enablenotify() \n\
		 <Btn2Up>:   notify(Help) disablenotify()";
	static char cmdtrans[] =
	"<Btn1Down>:	set() enablenotify() \n\
	<Btn1Up>:		notify() disablenotify() unset() \n\
	<Btn2Down>:	enablenotify() \n\
	<Btn2Up>:	notify(Help) disablenotify() \n\
	<EnterWindow>:	highlight() \n\
	<LeaveWindow>:	unset(NoRedisplay) disablenotify() unhighlight()";
	static XtCallbackRec helpcall[] = {
		{help_call,	NULL},
		{NULL,		NULL},
	};
	static XtCallbackRec cmdcall[] = {
		{topl_input,	NULL},
		{NULL,		NULL},
	};
	static Arg topbblist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) helpcall},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNleft,		(XtArgVal) XtChainLeft},
		{XtNborderWidth,	(XtArgVal) 0},
	};
	static Arg iconlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNbitmapData,		(XtArgVal) NULL},
		{XtNiconWidth,	(XtArgVal) NULL},
		{XtNiconHeight,	(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg cmdlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNcallback,		(XtArgVal) cmdcall},
	};
	static Arg infolist[] = {
		{XtNborderColor,	(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNtranslations,	(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNright,		(XtArgVal) XtChainRight},
		{XtNcallback,		(XtArgVal) helpcall},
	};
	static Arg cmdstrlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNwidth,		(XtArgVal) NULL},
		{XtNjustify,		(XtArgVal) XtJustifyLeft},
	};
	static Arg curdirlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNlabel,		(XtArgVal) NULL},
		{XtNwidth,		(XtArgVal) NULL},
		{XtNfromVert,		(XtArgVal) NULL},
		{XtNfromHoriz,		(XtArgVal) NULL},
		{XtNjustify,		(XtArgVal) XtJustifyLeft},
	};
	static Arg clocklist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNwidth,		(XtArgVal) INFOWIDTH-10},
		{XtNheight,		(XtArgVal) INFOWIDTH-10},
		{XtNupdate,		(XtArgVal) 1},
		{XtNanalog,		(XtArgVal) True},
	};
	static Arg mboxlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNupdate,		(XtArgVal) 15},
	};
	static Arg loadlist[] = {
		{XtNforeground,		(XtArgVal) NULL},
		{XtNbackground,		(XtArgVal) NULL},
		{XtNwidth,		(XtArgVal) INFOWIDTH-10},
		{XtNheight,		(XtArgVal) INFOWIDTH-10},
	};
	Widget cw1, cw2, cw3;
	int l1;
	char *pp;

	/* Create title bar */
	if (gc->gc_flags & (G_CLOCK|G_MAILBOX|G_LOAD))
		widv = gs->gs_dispwidth-INFOWIDTH;
	else
		widv = gs->gs_dispwidth;
	if (gc->gc_flags & G_DIRBROWSER) {
		opbut = "DirBrowz";
		strcpy(dirbpath, XDIR);
		strcat(dirbpath, "dirb");
		dirbargv[0] = "dirb";
		dirbargv[1] = "-display";
		dirbargv[2] = DisplayString(gs->gs_disp);
		dirbargv[3] = "-geometry";
		dirbargv[4] = "500x500+200+200";
		dirbargv[5] = "-topdir";
		dirbargv[6] = gs->gs_homedir;
		dirbargv[7] = "-dirbfgr";
		dirbargv[8] = gc->gc_dirbfgr;
		dirbargv[9] = "-dirbbgr";
		dirbargv[10] = gc->gc_dirbbgr;
		dirbargv[11] = "-chdirwin";
		dirbargv[12] = winstr;
		i = 13;
		if (gc->gc_flags & G_ICONCTRL)
			dirbargv[i++] = "-iconctrl";
		if (gc->gc_flags & G_DIRBRMDIR)
			dirbargv[i++] = "-rmdir";
		if (gc->gc_flags & G_DIRBCHDIR)
			dirbargv[i++] = "-chdir";
		if (gc->gc_flags & G_DIRBMKDIR)
			dirbargv[i++] = "-mkdir";
		if (gc->gc_flags & G_DIRBRMFILE)
			dirbargv[i++] = "-rmfile";
		dirbargv[i] = NULL;
	} else {
		opbut = NULL;
	}
	title_creat(toplevel, gc->gc_toplfgr, gc->gc_toplbgr, widv,
		"Top", ctrl_input, &(gs->gs_helphead),
		(gc->gc_flags & G_ICONCTRL), opbut,
		dirb_bits, dirb_width, dirb_height,
		&(gs->gs_toplw), &cw1, &cw2, &cw3, &cw, &(gs->gs_titlew));
	/* Display the current directory */
	if (gc->gc_flags & (G_CHDIR|G_DIRBROWSER)) {
		curdirlist[0].value = (XtArgVal) init_colour(gc->gc_curdirfgr);
		curdirlist[1].value = (XtArgVal) init_colour(gc->gc_curdirbgr);
		curdirlist[2].value = (XtArgVal) curdir;
		curdirlist[3].value = (XtArgVal) (widv-20);
		curdirlist[4].value = (XtArgVal) cw1;
		cw = gs->gs_curdirw = XtCreateManagedWidget("curdir", labelWidgetClass,
			gs->gs_toplw, curdirlist, XtNumber(curdirlist));
	} else {
		cw = cw1;
	}
	/* The info widget box */
	if (gc->gc_flags & (G_CLOCK|G_MAILBOX|G_LOAD)) {
		infolist[0].value = (XtArgVal) init_colour(gc->gc_infofgr);
		infolist[1].value = (XtArgVal) init_colour(gc->gc_infobgr);
		infolist[2].value = (XtArgVal) XtParseTranslationTable(infotrans);
		infolist[3].value = (XtArgVal) cw;
		gs->gs_infobbw = XtCreateManagedWidget("infobb", boxWidgetClass,
			gs->gs_toplw, infolist, XtNumber(infolist));
		/* add the info widgets, as required */
		/* The clock widget */
		if (gc->gc_flags & G_CLOCK) {
			clocklist[0].value = (XtArgVal) init_colour(gc->gc_clockfgr);
			clocklist[1].value = (XtArgVal) init_colour(gc->gc_clockbgr);
			gs->gs_clockw = XtCreateManagedWidget("clock",
				clockWidgetClass, gs->gs_infobbw, clocklist,
				XtNumber(clocklist));
		}
		/* the mailbox widget */
		if (gc->gc_flags & G_MAILBOX) {
			mboxlist[0].value = (XtArgVal) init_colour(gc->gc_mailfgr);
			mboxlist[1].value = (XtArgVal) init_colour(gc->gc_mailbgr);
			gs->gs_mboxw = XtCreateManagedWidget("mbox",
				mailboxWidgetClass, gs->gs_infobbw, mboxlist,
				XtNumber(mboxlist));
		}
		/* and the load monitor widget */
		if (gc->gc_flags & G_LOAD) {
			loadlist[0].value = (XtArgVal) init_colour(gc->gc_loadfgr);
			loadlist[1].value = (XtArgVal) init_colour(gc->gc_loadbgr);
			gs->gs_loadw = XtCreateManagedWidget("load",
				loadWidgetClass, gs->gs_infobbw, loadlist,
				XtNumber(loadlist));
		}
	}
	topbblist[0].value = (XtArgVal) init_colour(gc->gc_toplbbfgr);
	topbblist[1].value = (XtArgVal) init_colour(gc->gc_toplbbbgr);
	topbblist[2].value = (XtArgVal) XtParseTranslationTable(topbbtrans);
	topbblist[3].value = (XtArgVal) cw;
	gs->gs_topbbw = XtCreateManagedWidget("topbb", boxWidgetClass,
		gs->gs_toplw, topbblist, XtNumber(topbblist));
	/* And finally the command string widget */
	cmdstrlist[0].value = (XtArgVal) init_colour(gc->gc_cmdstrfgr);
	cmdstrlist[1].value = (XtArgVal) init_colour(gc->gc_cmdstrbgr);
	if (gc->gc_flags & G_COMMANDSTR)
		strcpy(outstr, "% ");
	else
		strcpy(outstr, " ");
	cmdstrlist[2].value = (XtArgVal) outstr;
	cmdstrlist[3].value = (XtArgVal) widv-24;
	gs->gs_cmdstrw = XtCreateManagedWidget("cmdstr", labelWidgetClass,
		gs->gs_topbbw, cmdstrlist, XtNumber(cmdstrlist));
	/* and the button boxes */
	/* The top level selection buttons */
	if (gc->gc_level[1].l_flags & L_VALID) {
		lp = gc->gc_level;
		i = 0;
		cmdcall[0].callback = topl_input;
		cmdtrn = XtParseTranslationTable(cmdtrans);
		while (i < NTOPLEVEL && (lp->l_flags & L_VALID)) {
			cmdcall[0].closure = (caddr_t) i;
			if (lp->l_flags & L_ICON) {
				iconlist[0].value = (XtArgVal) init_colour(
					lp->l_fgr);
				iconlist[1].value = (XtArgVal) init_colour(
					lp->l_bgr);
				iconlist[2].value = (XtArgVal) lp->l_bits;
				iconlist[3].value = (XtArgVal) lp->l_width;
				iconlist[4].value = (XtArgVal) lp->l_height;
				iconlist[5].value = (XtArgVal) cmdtrn;
				gs->gs_topw[i] = XtCreateManagedWidget("top",
					icommandWidgetClass, gs->gs_topbbw,
					iconlist, XtNumber(iconlist));
			} else {
				cmdlist[0].value = (XtArgVal) init_colour(
					lp->l_fgr);
				cmdlist[1].value = (XtArgVal) init_colour(
					lp->l_bgr);
				cmdlist[2].value = (XtArgVal) (pp = XtMalloc(MAXLABEL+1));
				l1 = strlen(lp->l_label);
				bcopy(lp->l_label, pp, l1);
				bcopy(blkstr, pp+l1, MAXLABEL-l1);
				*(pp+MAXLABEL) = '\0';
				cmdlist[3].value = (XtArgVal) cmdtrn;
				gs->gs_topw[i] = XtCreateManagedWidget("top",
					commandWidgetClass, gs->gs_topbbw,
					cmdlist, XtNumber(cmdlist));
			}
			strcpy(helpname, "Toplevel.");
			strncat(helpname, lp->l_label, NAMSIZ);
			helpname[NAMSIZ] = '\0';
			add_help(helpname, &(gs->gs_helphead), gs->gs_topw[i]);
			i++;
			lp++;
		}
		gs->gs_toplnum = i;
	}
}

/*
 * Change directory for current top level.
 */
change_dir(toplnum)
	int toplnum;
{
	register GshConf *gc = gconfptr;
	int l;
	char dpath[MYMAXPATHLEN+1];

	if (!(gc->gc_flags & G_CHDIR) || *gc->gc_level[toplnum].l_chdir == '\0')
		return;
	if (*gc->gc_level[toplnum].l_chdir != '/') {
		strcpy(dpath, gshstate.gs_homedir);
		l = strlen(dpath);
		if (dpath[l-1] != '/') {
			dpath[l] = '/';
			dpath[l+1] = '\0';
			l += 2;
		}
		strncat(dpath, gc->gc_level[toplnum].l_chdir, MYMAXPATHLEN-l);
	}
	if (access(dpath, (R_OK|W_OK|X_OK)) < 0) {
		if (access(dpath, F_OK) == 0 || mkdir(dpath, 0777) < 0) {
			err(ER_TOPLCHDIR);
			return;
		}
	}
	if (gsh_chdir(dpath, True) < 0)
		err(ER_TOPLCHDIR);
}

/*
 * Callback routine for control buttons
 */
static void ctrl_input(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;
	register PidList *pidp;
	int newpid;
	int i;

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
	i = (int) p1;
	switch(i) {
	case 0:
		gshlogout();
	case 1:
		/* pop down the current cmd panel */
		cmd_popdown();
		break;
	case 2:
		/* Start command execution */
		go_cmd();
		break;
	case 3:
		/* Start up directory browser */
		if ((pidp = (PidList *)malloc(sizeof(PidList))) == NULL)
			break;
		pidp->flags = C_DIRB;
		if ((newpid = vfork()) < 0) {
			free((caddr_t) pidp);
			err(ER_NOFORK);
			break;
		}
		if (newpid == 0) {
			int fdt;

#ifdef notdef
			if ((fdt = open("/dev/null", O_RDWR, 0666)) < 0)
				err(ER_NONULL);
			dup2(fdt, 0);
			dup2(fdt, 1);
			dup2(fdt, 2);
			close(fdt);
#endif
			execve(dirbpath, dirbargv, environ);
			_exit();
		} else {
			int omask;
	
			pidp->pid = newpid;
			omask = sigblock(sigmask(SIGCHLD));
			pidp->next = gs->gs_pidlist.next;
			gs->gs_pidlist.next = pidp;
			sigsetmask(omask);
		}
		XDefineCursor(gs->gs_disp, gs->gs_rootwin, gs->gs_fullhrcursor);
		break;
	};
}

/*
 * Catchall callback for help
 */
void help_call(w, p1, p2)
	Widget w;
	caddr_t p1, p2;
{
	register GshState *gs = &gshstate;

	if (p2 != NULL) {
		if (*p2 == 'H') {
			popup_help(&(gs->gs_helphead), &(gs->gs_popuphead), w);
		}
		return;
	}
}

/*
 * Display working dir.
 */
void gsh_dispdir()
{
	register char *p, *p2;
	GshState *gs = &gshstate;
	GshConf *gc = gconfptr;
	int len, ret, prelen;
	static char wdir[MYMAXPATHLEN+1];
	static Arg setlab[] = {
		{XtNlabel,	(XtArgVal) curdir},
	};

	if (!(gc->gc_flags & (G_CHDIR|G_DIRBROWSER)))
		return;
	prelen = strlen(DIRPREFIX);
	bcopy(DIRPREFIX, curdir, prelen);
	if (getwd(wdir) == 0) {
		curdir[prelen] = '\0';
	} else {
		/* If not to display full path, extract homedir */
		p = wdir;
		if (!(gc->gc_flags & G_FULLDIRPATH)) {
			p2 = gs->gs_homedir;
			while (*p == *p2) {
				p++;
				p2++;
			}
			if (p2 != NULL)
				p = wdir;
		}
		len = strlen(p);
		if (len >= (CURDIRL-prelen)) {
			bcopy(p, curdir+prelen, CURDIRL-prelen);
			curdir[CURDIRL] = '\0';
		} else if (len > 0) {
			bcopy(p, curdir+prelen, len+1);
		} else {
			bcopy("<home>", curdir+prelen, 7);
		}
	}
	/* Draw out the string */
	XtSetValues(gs->gs_curdirw, setlab, XtNumber(setlab));
	/* Force redraw of curdirw (Kludge..) */
	(*(gs->gs_curdirw->core.widget_class->core_class.expose))
		(gs->gs_curdirw, (XEvent *) NULL, (Region) NULL);
}

/*
 * Change working dir.
 */
int gsh_chdir(dirp)
	char *dirp;
{
	register GshState *gs = &gshstate;
	GshConf *gc = gconfptr;

	if (!(gc->gc_flags & (G_CHDIR|G_DIRBROWSER)))
		return(-1);
	XSync(gs->gs_disp, False);
	allocerr = False;
	XChangeProperty(gs->gs_disp, gs->gs_chdirwin, gs->gs_abdiratom,
		XA_STRING, 8, PropModeReplace, dirp, strlen(dirp)+1);
	XSync(gs->gs_disp, False);
	if (allocerr)
		return(-1);
	else
		return(0);
}

/*
 * Pop down the current cmd panel.
 */
void cmd_popdown()
{
	register GshState *gs = &gshstate;
	Widget cur_cmdw;
	static Arg getpos[] = {
		{XtNx,		(XtArgVal) &cmd_xpos},
		{XtNy,		(XtArgVal) &cmd_ypos},
	};

	if (gs->gs_curtoplevel != -1) {
		cur_cmdw = gs->gs_cmdw[gs->gs_curtoplevel];
		XtGetValues(cur_cmdw, getpos, 2);
		reset_names();
		reset_cmd(True);
		XtPopdown(cur_cmdw);
		if (!XtIsSensitive(gs->gs_topw[gs->gs_curtoplevel]))
			XtSetSensitive(gs->gs_topw[gs->gs_curtoplevel], True);
		gs->gs_curtoplevel = -1;
	}
}

