.TH KTERM 1 "6 Sept 1988" "X Version 11"
.SH NAME
kterm \- terminal emulator for X
.SH SYNOPSIS
.B kterm
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The \fIkterm\fP program is a Kanji terminal emulator for the X Window System.
It provides DEC VT102 and Tektronix 4014 
compatible terminals for programs that can't
use the window system directly.
It comes from \fIxterm\fP in the core programs of the distribution of the
X Window System.
The most of the functions are the same as original \fIxterm\fP's, however,
it has capabilities of displaying Kanji strings and handling of the status line,
if compiled with -DKANJI or -DSTATUSLINE compile time options.
.PP
.SH OPTIONS
The \fIkterm\fP terminal emulator 
accepts all of the standard \fIxterm\fP command line options along with the 
additional options listed below (if the option begins with a
.RB ` + '
instead of a
.RB ` \- ',
the option is restored to its default value):
.TP 8
.BI \-fk " kanji-font"
This option specifies a Kanji font to be used when displaying Kanji text.  
This font must be the same height and width as the ascii font.
The default is ``a14.''
.TP 8
.BI \-fkb " kanji-font"
This option specifies a Kanji bold font to be used when displaying bold text.  
This font must be the same height and width as the kanji font.
If no Kanji bold font is specified, it will be used as the
normal font and the bold font will be produced by overstriking this font.
The default is not specified.
.TP 8
.BI \fr " kana-font"
This option specifies a Kana font, which may be used as GR in 8bit environment.
This font is used if ``ESC ( I'' is appeared in JIS Kanji mode, SS2 (0x8e)
is appeared in EUC Kanji mode, and not used so frequntly in normal Japanese
text.
The default is ``kana14.''
.TP 8
.BI \frb " kana-font"
This option specifies a Kana bold font.
.TP 8
.B \-km " kanji-mode"
This option specifies the Kanji code from the pty output.
If kanji-mode is ``jis'', then it assumes the output is coded by JIS code,
i.e., each Kanji string is proceeded by ESC-$-B or ESC-$-@ and each
ascii string is proceeded by ESC-(-B or ESC-(-J.
This mode does not require 8 bit passing tty modele because 7 bit encoding
with appropriate escape sequences is used.
If kanji-mode is ``euc'', then it assumes the output is coded by EUC.
If kanji-mode is ``sjis'', then it assumes the output is coded by Shift-JIS
code (which is the same as MicroSoft Kanji code).
The default mode is ``jis.''
.TP 8
.B \-sn
By default, the status line is in reverse-video (relative to the rest of the
window).
This option causes the status line to be in normal video (the status line
is still enclosed in a box).
.TP 8
.B \-st
This option causes the status line to be displayed on startup.
.SH "X DEFAULTS"
The program understands all of the core xterm resource names and
classes as well as:
.TP 8
.B "kanjiFont (\fPclass\fB KanjiFont)"
Specifies the name of the kanji font.  The default is ``a14.''
.TP 8
.B "kanjiboldFont (\fPclass\fB KanjiFont)"
Specifies the name of the bold font.  The default is not specified.
.TP 8
.B "kanaFont (\fPclass\fB KanaFont)"
Specifies the name of the kana font.  The default is ``kana14.''
.TP 8
.B "kanaboldFont (\fPclass\fB KanaFont)"
Specifies the name of the bold font.  The default is not specified.
.TP 8
.B "kanjiMode (\fPclass\fB KanjiMode)"
Specifies the Kanji code of pty output. The default is ``jis.''
.TP 8
.B "statusLine (\fPclass\fB StatusLine)"
Causes the status line to be displayed on startup.
.TP 8
.B "statusNormal (\fPclass\fB StatusNormal)"
Specifies whether or not the last column bug in cursor should be worked around.
The default is ``false.''
.SH EMULATIONS
The VT102 emulation is fairly complete, but does not support the blinking
character attribute nor the double-wide and double-size character sets.
.IR Termcap (5)
entries that work with
.I xterm
include ``kterm'', ``xterm'', ``vt102'', ``vt100'' and ``ansi'', and
.I xterm
automatically searches the termcap file in this order for these entries and then
sets the ``TERM'' and the ``TERMCAP'' environment variables.
.SH "POINTER USAGE"
.PP
.I Kterm
converts the specified text by the cut operation into JIS code regardless
of the Kanji mode and then saves it to the Xserver.
This convention allows us to cut and paste between different kterm's with
differecnt Kanji mode.
.SH "SEE ALSO"
xterm(1), resize(1), X(1), pty(4), tty(4)
.br
.I ``Xterm Control Sequences''
.SH BUGS
\fBXterm will hang forever if you try to paste too much text at one time.\fP
It is both producer and consumer for the pty and can deadlock.
.PP
Variable-width fonts are not handled reasonably.
.PP
This program still needs to be rewritten.  It should be split into very
modular sections, with the various emulators being completely separate
widgets that don't know about each other.  Ideally, you'd like to be able to
pick and choose emulator widgets and stick them into a single control widget.
.PP
The focus is considered lost if some other client (e.g., the window manager)
grabs the pointer; it is difficult to do better without an addition to the
protocol.
.PP
There needs to be a dialog box to allow entry of log file name
and the COPY file name.
.PP
Many of the options are not resettable after
.I xterm
starts.
.PP
All programs should be written to use X directly; then we could
eliminate this program.
.PP
Current
.I kterm
does not support the designate sequence of KANJI as ``ESC $ ( B''
but ``ESC $ B'' which is still valid sequence in ISO 2022 (even if it seems
to be historical reason :-)
.SH COPYRIGHT
Copyright 1988, XXI working group in Japan Unix Society Japan.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Far too many people, including:
.sp
Katsuya Sano (Tokyo Inst. of Tech.),
Michael Irie (Sony Corp.),
Akira Kato (Tokyo Inst. of Tech.),
Michiharu Ariza (Software Research Associates),
Makoto Ishisone (Software Research Associates)
