/* grX5.c -
 *
 * Copyright 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software (the graphics, textio, and windows modules of the Magic
 * system) and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.  
 *
 * Manipulate the programable cursor on the graphics display.
 *
 */

/**** Modifications by Dave Durfee and Markus G. Wloka
***** Copyright (C) 1987 Brown University	
****/

/**** Modifications by Marco Papa
***** Copyright (C) 1988 University of Southern California
****/

#ifndef lint
static char sccsid[] = "@(#)grX5.c	4.3 MAGIC (Berkeley) 8/7/85";
#endif	not lint

#include <stdio.h>
#include "magic.h"
#include "textio.h"
#include "geometry.h"
#include "graphics.h"
#include "glyphs.h"
#include "windows.h"
#include "graphicsInt.h"
#include "grXInt.h"
#include <X11/Xlib.h>
#include <X11/X10.h>
#include "grX11.h"

extern GrGlyphs *grCursorGlyphs;

/* locals */

Cursor grCursors[ MAX_CURSORS ];


/*
 * ----------------------------------------------------------------------------
 * GrXDrawGlyph --
 *
 *	Draw one glyph on the display.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Draws pixels.
 * ----------------------------------------------------------------------------
 */

GrXDrawGlyph (gl, p)
    GrGlyph *gl;		/* A single glyph */
    Point *p;			/* screen pos of lower left corner */
{
    Rect bBox;
    bool anyObscure;
    LinkedRect *ob;
    GC grGCGlyph;

    GR_CHECK_LOCK();
    bBox.r_ll = *p;
    bBox.r_xtop = p->p_x + gl->gr_xsize - 1;
    bBox.r_ytop = p->p_y + gl->gr_ysize - 1;

    anyObscure = false;
    for (ob = grCurObscure; ob != NULL; ob = ob->r_next) {
	if (GEO_TOUCH( &(ob->r_r), &bBox)) {
	    anyObscure = true;
	    break;
	}
    }

    grGCGlyph = XCreateGC(display, grCurrent.window, 0, 0);

    if ((!anyObscure) && (GEO_SURROUND(&grCurClip, &bBox)) ) {
	int *pixelp, x, y;

	/* no clipping, try to go quickly */
	pixelp = gl->gr_pixels;

	for (y = 0; y < gl->gr_ysize; y++) {
	    int x1, y1;

	    y1 = grMagicToX( bBox.r_ybot + y );
	    for (x = 0; x < gl->gr_xsize; x++) {
		x1 = bBox.r_xbot + x;
	    	XSetForeground(display, grGCGlyph, grPixels[ grStyleTable[*pixelp++].color ] | grCurrent.maskmod);
		XDrawPoint( display,
		       grCurrent.window,
		       grGCGlyph,
		       x1, y1);
	    }
	}
    } else {
	/* do pixel by pixel clipping */
	int y, yloc;
	yloc = bBox.r_ybot;
	for (y = 0; y < gl->gr_ysize; y++) {
	    int startx, endx;
	    if ( (yloc <= grCurClip.r_ytop) && (yloc >= grCurClip.r_ybot) ) {
		int laststartx;
		laststartx = bBox.r_xbot - 1;
		for (startx = bBox.r_xbot; startx <= bBox.r_xtop;
			startx = endx + 1) {
		    int *pixelp;

		    startx = MAX(startx, grCurClip.r_xbot);
		    endx = MIN(bBox.r_xtop, grCurClip.r_xtop);

		    if (anyObscure) {
			for (ob = grCurObscure; ob != NULL; ob = ob->r_next) {
			    if ( (ob->r_r.r_ybot <= yloc) &&
				 (ob->r_r.r_ytop >= yloc) ) {
				if (ob->r_r.r_xbot <= startx)
				    startx = MAX(startx, ob->r_r.r_xtop + 1);
				else if (ob->r_r.r_xbot <= endx)
				    endx = MIN(endx, ob->r_r.r_xbot - 1);
			    }
			}
		    }

		    /* stop if we aren't advancing */
		    if (startx == laststartx) break;
		    laststartx = startx;
		    if (startx > endx) continue;

		    /* draw a section of this scan line */
		    pixelp = &( gl->gr_pixels[y*gl->gr_xsize +
			    (startx - bBox.r_xbot)]);

		    for ( ; startx <= endx; startx++) {
		    	XSetForeground(display, grGCGlyph, grPixels[ grStyleTable[*pixelp++].color ] | grCurrent.maskmod);
			XDrawPoint( display,
			    grCurrent.window,
			    grGCGlyph,
			    startx, grMagicToX( yloc + y ));
		    }
		    startx = endx + 1;
		}
	    }
	    yloc++;
	}
    }
    XFreeGC(display, grGCGlyph);
}


/*
 * ----------------------------------------------------------------------------
 * grxDefineCursor:
 *
 *	Define a new set of cursors.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The given matrix is stored in the graphics display, and it can be
 *	used as the cursor by calling GrSetCursor.
 * ----------------------------------------------------------------------------
 */

Void
grxDefineCursor(glyphs)
    GrGlyphs *glyphs;
{
    int glyphnum;
    Rect oldClip;
/* #define X10TOX11 */
#ifdef X10TOX11
    XColor list[1];
    int forepix;
#endif

    if (glyphs->gr_num <= 0) return;

    if (glyphs->gr_num > MAX_CURSORS)
    {
	TxError("X only has room for %d cursors\n", MAX_CURSORS);
	return;
    }

    /* expand clipping amount for off-screen access on the X */
    GrLock(GR_LOCK_SCREEN, FALSE);
    oldClip = grCurClip;
    grCurClip = GrScreenRect;
    grCurClip.r_ytop += 16;

    /* enter the glyphs */
    for (glyphnum = 0; glyphnum < glyphs->gr_num; glyphnum++) {
	int *p;
	GrGlyph *g;
	int x, y;
	short colored;
#ifndef DONT_USE_LAST_COLOR_DEFINED_FOR_GLYPH
	int color_to_use;
#endif
	Pixmap bm;
	Pixmap bm2;
	XColor color;
	unsigned short curs[16];

	g = glyphs->gr_glyph[glyphnum];
	if ((g->gr_xsize != 16) || (g->gr_ysize != 16)) {
	    TxError("Cursors for the X must be 16 X 16 pixels.\n");
	    return;
	}

	/* Perform transposition on the glyph matrix since X displays
	 * the least significant bit on the left hand side.
	 */
	p = &(g->gr_pixels[0]);
	for (y = 0; y < 16; y++) {
	    curs[ 15 - y] = 0;
	    for (x = 0; x < 16; x++) {
#ifndef DONT_USE_LAST_COLOR_DEFINED_FOR_GLYPH
		if (grStyleTable[*p].color != 0) {
		     color_to_use = (int)grStyleTable[*p].color;
		}
#endif				
		colored = (grStyleTable[*p].color != 0);
		curs[ 15 - y ] = curs[ 15 - y ] | ( colored & 001 ) << x;
		p++;
	    }
	}

	if (XImageByteOrder(display) == MSBFirst)
	    for (y=0; y<16; y++)
		curs[y] = ((curs[y] & 0x00ff)<<8) | ((curs[y] & 0xff00)>>8);

#ifdef X10TOX11
	/* simulate XStoreBitmap */
	bm = StoreBitmap(display, curs, 16, 16);

	/* simulate XStoreCursor */
#define foreground (list+0)
	forepix = X10toX11pixel(display,color_to_use),
	foreground->pixel = forepix;
	if (DisplayPlanes(display,screen) < 4) {
		foreground->pixel = WhitePixel(display, DefaultScreen(display));
		XQueryColors(display,
			DefaultColormap(display, DefaultScreen(display)),
			list,
			1);
	} else
		XQueryColors(display,
			cmap,
			list,
			1);

	grCursors[ glyphnum ] = XCreatePixmapCursor(display, bm, bm,
	    foreground, foreground,
	    (unsigned int) g->gr_origin.p_x,
	    (unsigned int) ( 15 - g->gr_origin.p_y ));
#undef foreground

#else X10TOX11
	/* set color */
	color.pixel = X10toX11pixel(display,color_to_use);

	if (DisplayPlanes(display,screen) < 4) {
		color.pixel = WhitePixel(display, DefaultScreen(display));
		XQueryColor(display,
			DefaultColormap(display, DefaultScreen(display)),
			&color);
	} else
		XQueryColor(display,
			cmap,
			&color);

	bm = XCreateBitmapFromData(display, DefaultRootWindow(display),
		curs, 16, 16);
	bm2 = XCreateBitmapFromData(display, DefaultRootWindow(display),
		curs, 16, 16);
	grCursors[ glyphnum ] = XCreatePixmapCursor(display, bm, bm2,
	    &color, &color,
	    (unsigned int) g->gr_origin.p_x,
	    (unsigned int) ( 15 - g->gr_origin.p_y ));
	XFreePixmap(display, bm2);
#endif X10TOX11
	XFreePixmap(display, bm);

    }

    /* Restore clipping */
    grCurClip = oldClip;
    GrUnlock(GR_LOCK_SCREEN);
}


/*
 * ----------------------------------------------------------------------------
 * GrXSetCursor:
 *
 *	Make the cursor be a new pattern, as defined in the display styles file.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	When the cursor is turned back on it will take on the new pattern.
 * ----------------------------------------------------------------------------
 */

Void
GrXSetCursor(cursorNum)
int cursorNum;		/* The cursor number as defined in the display
			 * styles file.
			 */
{
    grCurrent.cursor = grCursors[ cursorNum ];
    XDefineCursor(display, grCurrent.window, grCurrent.cursor);
}

/*
 * XStoreBitmap (like X10) -- uses depth 1
 */
#define UBPS (sizeof(short)/2)
#define X10BitmapSize(wd, ht) (((((wd) + 15) >> 3) & ~1) * (ht) * UBPS)

Pixmap
StoreBitmap(dpy,data,width,height)
Display *dpy;
short *data;
unsigned int width, height;
{
	XImage ximage;
	GC pgc;
	XGCValues gcv;
	Pixmap pid;
	unsigned int gcmask;

	pid = XCreatePixmap(dpy, DefaultRootWindow(dpy),
		width, height, 1);	/* depth 1 */

	gcmask = GCForeground | GCBackground | GCPlaneMask;
	gcv.foreground = 1;	/* X10 foreground */
	gcv.background = 0;	/* X10 background */
	gcv.plane_mask = 0xffffffff;
	pgc = XCreateGC(dpy, pid, gcmask, &gcv);

	ximage.height = height;
	ximage.width = width;
	ximage.xoffset = 0;
	ximage.format = XYBitmap;
	ximage.data = (char *) data;
	ximage.byte_order = MSBFirst;	/* was LSBFirst */
	ximage.bitmap_unit = 16;
	ximage.bitmap_bit_order = LSBFirst;
	ximage.bitmap_pad = 16;
	ximage.bytes_per_line = X10BitmapSize(width,1);
	/* was (width+15)/16 * 2; */
	ximage.depth = 1;

	XPutImage(dpy, pid, pgc, &ximage, 0, 0, 
		(unsigned int) 0, (unsigned int) 0, width, height);
	XFreeGC(dpy, pgc);
	return(pid);
}

X10toX11pixel(dpy,pix)
Display *dpy;
{

	if (pix == 1)
		pix = WhitePixel(dpy, DefaultScreen(dpy));
	else if (pix == 0)
		pix = BlackPixel(dpy, DefaultScreen(dpy));
	return(pix);
}

