/* pbmtops.c - read a portable bitmap and produce a PostScript bitmap file
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#ifdef	OS_SYSV
#include <string.h>
#else	OS_SYSV
#include <strings.h>
#endif	OS_SYSV
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int argn, rows, cols, padright, row, col;
    char ch;
    float scale;
    char name[100], *cp;
    char *usage = "usage:  %s [-s scale] [pbmfile]\n";

    argn = 1;
    scale = 1.0;

    /* Check for flags. */
    if ( argn < argc )
	{
	if ( argv[argn][0] == '-' )
	    {
	    if ( ( argv[argn][1] == 's' || argv[argn][1] == 'S' ) &&
		 argv[argn][2] == '\0' )
		{
		argn++;
		if ( argn == argc )
		    {
		    fprintf( stderr, usage, argv[0] );
		    exit( 1 );
		    }
		if ( sscanf( argv[argn], "%f", &scale ) != 1 )
		    {
		    fprintf( stderr, usage, argv[0] );
		    exit( 1 );
		    }
		argn++;
		}
	    else
		{
		fprintf( stderr, usage, argv[0] );
		exit( 1 );
		}
	    }
	}

    if ( argn == argc )
	{
	ifd = stdin;
	strcpy( name, "noname" );
	}
    else
	{
        ifd = fopen( argv[argn], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[argn] );
	    exit( 1 );
	    }
	strcpy( name, argv[argn] );

#ifdef	OS_SYSV
	if ( ( cp = strchr( name, '.' ) ) != 0 )
#else	OS_SYSV
	if ( ( cp = index( name, '.' ) ) != 0 )
#endif	OS_SYSV
	    *cp = '\0';
	argn++;
	}

    if ( argn != argc )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    /* Compute padding to round cols up to the nearest multiple of 8. */
    padright = ( ( cols + 7 ) / 8 ) * 8 - cols;

    putinit( name, cols, rows, scale );
    for ( row = 0; row < rows; row++ )
	{
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
	for ( col = 0; col < padright; col++ )
	    putbit( 0 );
        }
    putrest( );

    exit( 0 );
    }


int item, bitsperitem, bitshift, itemsperline, itemcount;

putinit( name, cols, rows, scale )
char *name;
int cols, rows;
float scale;
    {
    int scols, srows;

    scols = cols * scale * 0.96 + 0.5;	/*   0.96 is the multiple of   */
    srows = rows * scale * 0.96 + 0.5;	/* 72/300 that is closest to 1 */

    printf( "%%! %s.ps\n", name );
    printf(
	"%d %d translate\t%% move to lower left corner of box\n",
	300 - ( scols/2 ), 400 - ( srows/2 ) );
    printf( "%d %d scale\t\t%% scale box\n", scols, srows );
    printf( "%d %d 1\t\t%% width height bits/sample\n", cols, rows );
    printf(
	"[ %d 0 0 -%d 0 %d ]\t%% transformation matrix\n", cols, rows, rows );
    printf( "/picstr 256 string def\n" );
    printf( "{ currentfile picstr readhexstring pop }\n" );
    printf( "image\n" );

    itemsperline = 0;
    item = 0;
    bitsperitem = 0;
    bitshift = 7;
    itemcount = 0;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 8 )
	{
	putitem( );
	}
    if ( ! b )
	item += 1 << bitshift;
    bitsperitem++;
    bitshift--;
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    /* And pad hex string to 256 bytes. */
    while ( itemcount % 256 != 0 )
	putitem( );
    printf( "\nshowpage\n" );
    }

putitem( )
    {
    if ( itemcount != 0 )
	putchar( ' ' );
    itemcount++;
    if ( itemsperline == 20 )
	{
	putchar( '\n' );
	itemsperline = 0;
	}
    if ( itemsperline == 0 )
	printf( "  " );
    itemsperline++;
    printf( "%02x", item );
    item = 0;
    bitsperitem = 0;
    bitshift = 7;
    }
