/*
 * Copyright 1988 Anant Agarwal
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied 
 * warranty.
 *
 * Author:  Anant Agarwal, MIT Laboratory for Computer Science
 */

/*
graph.font controls:
	symbols, title, axis labels, axis thickness.
curve.font:
	curve line width, bar thickness.
axis.font:
	axis numbers.
graph.keyfont:
	key aspects.
text.font:
	text fonts.
*/

#define BIG 999999999999.99
#define SMALL 0.0000000000001
#define MAXTICS 80
#define MAXTICSM 40
#define MAXOBJECTS 65536
#define MAXCURVES 1024

#define MAXPTS 1024
#define MAXLABEL 256
#define MAXTEXT 2048
#define MAXTICLABEL 64
#define PAIR 2
#define MAXFONTS 64
#define MAXSSFNS 2

typedef int FontType;

typedef enum {objline, objCurLine, objsymbol, objtext, objCurText,
	objflagcurves, objflagaxes, objflagkey, objflagtext, objflag,objdummy,
	objLineStartFlag, objLineEndFlag,
	objTextStartFlag, objTextEndFlag} ObjType;
/*objline is for line defined by begin and end point */
/*objCurLine is defined from prev point new point  relative */
/* objflag ends any other objflagcurves etc */

typedef enum {left, center, right } alignType;
typedef enum {norml, grk, pls, mns } SpecialType;

#define MINFNTSIZ	3
#define MAXFNTSIZ	30
#define FBS		100
#define helveticamin	100
#define helvetica3  	100
#define helvetica4  	101
#define helvetica5  	102
#define helvetica6  	103
#define helvetica7 	104
#define helvetica8  	105
#define helvetica9 	106
#define helvetica10 	107
#define helvetica11 	108
#define helvetica12 	109
#define helvetica13 	110
#define helvetica14	111
#define helvetica15 	112
#define helvetica16 	113
#define helvetica17 	114
#define helvetica18 	115
#define helvetica19 	116
#define helvetica20 	117
#define helvetica21 	118
#define helvetica22 	119
#define helvetica23 	120
#define helvetica24 	121
#define helvetica25 	122
#define helvetica26 	123
#define helvetica27 	124
#define helvetica28 	125
#define helvetica29 	126
#define helvetica30 	127
#define helveticamax 	127

#define helveticabmin 	128
#define helvetica3b 	128
#define helvetica4b 	129
#define helvetica5b 	130
#define helvetica6b 	131
#define helvetica7b 	132
#define helvetica8b 	133
#define helvetica9b 	134
#define helvetica10b 	135
#define helvetica11b 	136
#define helvetica12b	137
#define helvetica13b	138
#define helvetica14b	139
#define helvetica15b	140
#define helvetica16b	141
#define helvetica17b	142
#define helvetica18b	143
#define helvetica19b	144
#define helvetica20b	145
#define helvetica21b	146
#define helvetica22b	147
#define helvetica23b	148
#define helvetica24b	149
#define helvetica25b	150
#define helvetica26b	151
#define helvetica27b	152
#define helvetica28b	153
#define helvetica29b	154
#define helvetica30b	155
#define helveticabmax	155

#define helveticaimin 	200
#define helvetica3i 	200
#define helvetica4i 	201
#define helvetica5i 	202
#define helvetica6i 	203
#define helvetica7i 	204
#define helvetica8i 	205
#define helvetica9i 	206
#define helvetica10i 	207
#define helvetica11i 	208
#define helvetica12i	209
#define helvetica13i	210
#define helvetica14i	211
#define helvetica15i	212
#define helvetica16i	213
#define helvetica17i	214
#define helvetica18i	215
#define helvetica19i	216
#define helvetica20i	217
#define helvetica21i	218
#define helvetica22i	219
#define helvetica23i	220
#define helvetica24i	221
#define helvetica25i	222
#define helvetica26i	223
#define helvetica27i	224
#define helvetica28i	225
#define helvetica29i	226
#define helvetica30i	227
#define helveticaimax	227

#define helveticabimin 	228
#define helvetica3bi 	228
#define helvetica4bi 	229
#define helvetica5bi 	230
#define helvetica6bi 	231
#define helvetica7bi 	232
#define helvetica8bi 	233
#define helvetica9bi 	234
#define helvetica10bi 	235
#define helvetica11bi 	236
#define helvetica12bi	237
#define helvetica13bi	238
#define helvetica14bi	239
#define helvetica15bi	240
#define helvetica16bi	241
#define helvetica17bi	242
#define helvetica18bi	243
#define helvetica19bi	244
#define helvetica20bi	245
#define helvetica21bi	246
#define helvetica22bi	247
#define helvetica23bi	248
#define helvetica24bi	249
#define helvetica25bi	250
#define helvetica26bi	251
#define helvetica27bi	252
#define helvetica28bi	253
#define helvetica29bi	254
#define helvetica30bi	255
#define helveticabimax	255

#define timesromanmin  	400
#define timesroman3  	400
#define timesroman4  	401
#define timesroman5  	402
#define timesroman6  	403
#define timesroman7 	404
#define timesroman8  	405
#define timesroman9 	406
#define timesroman10 	407
#define timesroman11 	408
#define timesroman12 	409
#define timesroman13 	410
#define timesroman14	411
#define timesroman15 	412
#define timesroman16 	413
#define timesroman17 	414
#define timesroman18 	415
#define timesroman19 	416
#define timesroman20 	417
#define timesroman21 	418
#define timesroman22 	419
#define timesroman23 	420
#define timesroman24 	421
#define timesroman25 	422
#define timesroman26 	423
#define timesroman27 	424
#define timesroman28 	425
#define timesroman29 	426
#define timesroman30 	427
#define timesromanmax 	427

#define timesromanbmin 	428
#define timesroman3b 	428
#define timesroman4b 	429
#define timesroman5b 	430
#define timesroman6b 	431
#define timesroman7b 	432
#define timesroman8b 	433
#define timesroman9b 	434
#define timesroman10b 	435
#define timesroman11b 	436
#define timesroman12b	437
#define timesroman13b	438
#define timesroman14b	439
#define timesroman15b	440
#define timesroman16b	441
#define timesroman17b	442
#define timesroman18b	443
#define timesroman19b	444
#define timesroman20b	445
#define timesroman21b	446
#define timesroman22b	447
#define timesroman23b	448
#define timesroman24b	449
#define timesroman25b	450
#define timesroman26b	451
#define timesroman27b	452
#define timesroman28b	453
#define timesroman29b	454
#define timesroman30b	455
#define timesromanbmax	455

#define timesromanimin 	600
#define timesroman3i 	600
#define timesroman4i 	601
#define timesroman5i 	602
#define timesroman6i 	603
#define timesroman7i 	604
#define timesroman8i 	605
#define timesroman9i 	606
#define timesroman10i 	607
#define timesroman11i 	608
#define timesroman12i	609
#define timesroman13i	610
#define timesroman14i	611
#define timesroman15i	612
#define timesroman16i	613
#define timesroman17i	614
#define timesroman18i	615
#define timesroman19i	616
#define timesroman20i	617
#define timesroman21i	618
#define timesroman22i	619
#define timesroman23i	620
#define timesroman24i	621
#define timesroman25i	622
#define timesroman26i	623
#define timesroman27i	624
#define timesroman28i	625
#define timesroman29i	626
#define timesroman30i	627
#define timesromanimax	627

#define timesromanbimin	628
#define timesroman3bi 	628
#define timesroman4bi 	629
#define timesroman5bi 	630
#define timesroman6bi 	631
#define timesroman7bi 	632
#define timesroman8bi 	633
#define timesroman9bi 	634
#define timesroman10bi 	635
#define timesroman11bi 	636
#define timesroman12bi	637
#define timesroman13bi	638
#define timesroman14bi	639
#define timesroman15bi	640
#define timesroman16bi	641
#define timesroman17bi	642
#define timesroman18bi	643
#define timesroman19bi	644
#define timesroman20bi	645
#define timesroman21bi	646
#define timesroman22bi	647
#define timesroman23bi	648
#define timesroman24bi	649
#define timesroman25bi	650
#define timesroman26bi	651
#define timesroman27bi	652
#define timesroman28bi	653
#define timesroman29bi	654
#define timesroman30bi	655
#define timesromanbimax	655

typedef enum {nonesymbol,cross,triangle,trianglefilled,diamond,diamondfilled,
square,squarefilled,rectangle,rectanglefilled,circle,circlefilled,
bullet,star,plus } SymbolType;

typedef enum {none,solid,dashes,stipple,dots,fill,pat} LineType;


typedef enum {integer,floating,scientific,exponent} NumberStyleType;

typedef enum {linear, logstype, logs2, logs10 } ScalesDef;

typedef enum {linearinterp, xhistogram, yhistogram, lregression, step,
smooth} InterpType;

typedef enum {ksymbol, ktype, kboth} KeyType;

#define xpt 0
#define ypt 1
#define xpt 0
#define ypt 1
#define xpt 0
#define ypt 1
#define minval 0
#define maxval 1

typedef struct ZScaleType {
  ScalesDef type;/*typically linear or logs */
  double base; /* typically 2 or 10 */
} ScaleType;

typedef struct  ZpointType {
  struct ZpointType *nxtPtr;
  struct ZpointType *prvPtr;/*prev necessary for step type for instance */
  double pt[PAIR];
  double conf;	/* confidence interval: absolute value */
} pointType;

typedef struct Zmattype {
  double freq;
  double ang;
  int indx; /* or number  */
  boolean showline; 
  /* should the line bounding the filled region be drawn? */
  /* the following parameters are used only by yacc */
  boolean grayset, matset; 
   /* has the user has specified gray and mat values for this curve? */
} mattype;

typedef struct Zcurvetype {
  pointType *fstPtr; /*pointer to first point */
  pointType *lstPtr; /*pointer to last point */
  int lastpoint;		/* index of last valid point in a curve*/
  char label[MAXLABEL];
  SymbolType symbol;		/*cross, circle etc*//*size from graph.font*/
  int symbolsize; /* size of symbol, typically from 0 to 4 */
		  /* 2 means leave as is */
  LineType type;		/* bold, dashes etc */
  InterpType  interp;/* linearinterp, bar */
  Boolean include;
  Boolean showConf;
  boolean validcurve;		 /* true upto the last entered curve */
  double thick;	      /*in points*//* line width *//* comes from curve font */
  double gray;
  mattype mat; /* freq and angle of the mat, only for postscript */
} curvetype;

typedef struct Zgraphtype {
char title[MAXLABEL];
FontType font;/* for symbols, title, axis labels */
double keypos[PAIR];
KeyType key;
FontType keyfont;
Boolean includekey;
double size[PAIR];
} graphtype;

typedef struct  Zaxistype {
char label[MAXLABEL];
FontType font;/* font of the axis numbers */
double axismax;
double axismin;
ScaleType scale;/* logs/ linear and logbase if logs*/
NumberStyleType numberstyle;/* float or int or exponent*/
int signif; /* significant digits */
double interval;
double unit;
} axistype;

typedef struct  Ztexttype {
Boolean validtext; /* true upto the last entered text */
char label[MAXTEXT];
FontType font;
double pos[PAIR];
double angle;/*degrees*/
Boolean include;
alignType align;/*center, left or right */
} texttype;


#define MAXARR 1024

typedef struct XhashElementType {
	char instring[MAXLABEL];
	int token;
	int attribute;
	struct XhashElementType *link;
} hashElementType, *ptrToHashElementType;

typedef struct Ztictype {
Boolean validtic;
Boolean showtic;/* do not show tics beyond axis limits */
double pos;
Boolean major;/* TRUE if majortic else FALSE */
char label[MAXTICLABEL];
} tictype;

/* global flags */
ScaleType scale[PAIR];
/* 0 and 1 correspond to scales on X and Y axes */

double graphsize[PAIR];/* do not scale *//* in cms unlike graph.size*/
double limits[PAIR][PAIR];/*  scale */
double origin[PAIR];/* scale */
	/* gives the x-coord of the Y axis and Y-coord of X-axis */
/* first axis and then minval and maxval */


/* psf definitions */
typedef struct ZPsfTextType {
char *StrPtr;
double angle;/*in degrees */
alignType align;/*left, center, right */
char *FF;
int fontsize;/* in points */
double up;
SpecialType Sp;/* types are grk, pls, mns */
FontType font;/*specially added so that special characters could be handled
		from the object itself */
} PsfTextType;

typedef struct ZPsfLineType {
  double to[PAIR];
  LineType line;/* bold, stipple etc */
  double thick;/* in points */
  InterpType interp; /* regression, linear, smooth, etc */
  mattype mat; /* freq and angle of the mat, only in startline in postscript*/
} PsfLineType;

typedef struct ZPsfSymbolType {
SymbolType symbol;
int fontsize;/* in points */
} PsfSymbolType;


typedef struct ZLocalObjectType {
ObjType name;/* objline, objsymbol, objtext, objflagcurves, objLineStartFlag,
		objLineEndFlag, etc*/
Boolean scale;/*psf disregards this field */
double gray;/*  from 0 to 1 */
	/* 0 implies black, 1 implies white */
	/*so far only curves use it, however, it is defined here for 
		generality later*/
double from[PAIR];
union 	 {
	PsfTextType text;
	PsfSymbolType symbol;
	PsfLineType line;
	} un;
} LocalObjectType;




