.TH x11 L "9 July 1987" "X Version 11"
.SH NAME
x11 - an easy way to start up the X windows system (Version 11)
.SH SYNTAX
.PP
.B x11
.RB [ -rv ]
.RI [ servername
.IR serveroptions ]
.SH DESCRIPTION
.PP
.I x11
is a simple way to start up the X Windows system. It does this by
letting the X \fBserver\fP initialize itself, and then
executes a file called
.IR .x11startup .type
in the user's home directory, which starts up the \fBwindow manager\fP
and various application programs. If this file is not present, then it
copies some default files there and starts up with those defaults. The
user can subsequently modify these files to select other preferences
after gaining the necessary familiarity with X. This manual tries to
give the user a working familiarity with X, but for more details, the
user should refer to the standard X documents.
.PP
The 
.I .type
extension on the startup file name allows the user to have different
startup files for different types of displays - Locally, we have the types 
.I .bw2
for conventional Sun 3/50 and 3/60 monochrome displays, 
.I bw2hires
for high resolution Sun monochrome displays (like the one on godzilla),
.I cg4
for the Sun 3/110 and 3/60 color displays,
and
.I cg2
for the Sun 3/260 color displays. 
.PP
\fBStartup\fP
.br
When X comes up, the screen fills with a patterned
background, with a X shaped cursor in the centre. This is the \fBRoot
Window\fP and all windows created on the display are \fBdescendants\fP
of the Root Window. After the Root Window comes up, a small \fBconsole
window\fP appears at the top left corner of the screen. This is where
most messages will go (talk(1) requests, biff(1) reminders etc.)
On a
.I cg4
display, X uses the two available graphic planes as separate screens,
side by side.  You can move from one screen to the other by sliding
your mouse off the left or right edge of either screen. The zero'th
screen is a monochrome screen, and the first screen is a color screen.
They are referred to as 0.0 and 0.1 respectively in the display
numbering system. (if the machine is properly configured - harass your
system adminstartor if it isn't)
.br
\fBTo exit X Windows, hit Control-D or type "exit" in the console window\fP
.PP
Depending on the 
.I .x11startup
file found, various applications start up. With the default file, there
will be handy applications like a clock.
Two \fBterminal emulator\fP windows (
.I xterms
) will appear, which will behave exactly like vt102 terminals, with
shells in them. These can be used like normal terminals, except that
they are a lot bigger, and have a few bells and whistles not found on
the humble text terminal. To type into one of these, move the mouse till
the cursor is in the window (it changes shape to a pillar-like symbol)
and type away. (See 
.IR xterm (x))
.PP
These 
.I xterms
are what most people use most of the time, and familiarity with their
features is advised.
.PP
.B What is a window?
.PP
A
.I window
is a rectangular area on the screen, which has a background color, a
foreground color, and a border. Windows are created by the X Windows
server when asked for by various applications. An application program
sends all its output to its windows(s) and receives its input from
them. Windows may have child windows, forming a hierarchy, of which
the root is the Root Window.
.PP
.B What is X?
.br
The X Windows server is a program which controls the display and
takes requests from other application programs, called \fBclients\fP to
draw text and graphics, and return \fBevents\fP like mouse clicks and
key presses back to the applications. These requests can come over a
network, so it is possible to use a workstation running X to interact
with a program running on another machine. (See 
.IR xhost (x))
This allows the creation of windows by different client programs, and
their manipulation and interaction, to form a multi-tasking desktop
environment. X applications can be treated in most respects as ordinary
UNIX\*R programs, and put in the background (as all the applications
started up by
.I .xstartup
are), suspended, etc.
Most applications do not provide window management
facilities for moving windows around, above and below one another,
changing their size, and getting them out of the way. These functions
are performed by another X application program - the window manager.
.PP
.B The Window Manager
.br
There are several window managers for X, the more popular (around here)
being 
.I twm
and
.I awm.
The window manager makes such operations as resizing, moving, overlapping and
iconification of application windows much easier, and most application
programs will behave appropriately when such an action is taken. For
example, when rescaling the clock, it redraws itself to the
bigger/smaller scale.
.PP
The window manager
and well-behaved X Windows applications decide between themselves what
they'd like done about window management - usually, 
teh window manager
will put a frame around the application's window, and throw on a 
.I titlebar
on top. 
It
highlights the titlebar when the mouse goes into the window, to indicate
that that is the window that is going to receive the input
.I focus.
Sometimes, if you have the 
.I Auto-Raise
attribute set, the window will also come to the top when it gets the
focus. If not, clicking the LEFT mouse button on the titlebar raises the
window. Clicking the RIGHT mouse button on the titlebar lowers the window,
and clicking the MIDDLE mouse button on the titlebar, and holding it down
will result in an outline appearing, which you can drag around, and
place somewhere else on the screen by releasing the mouse button. The window
will move there.
.PP
The titlebar also has
.I buttons 
(or 
.IR gadgets )
on it.  (Not to be confused with mouse buttons!). These are little
square items, which can be used for other operations on the window.
The button which looks like a window pane, on the left closes the
window, and produces an 
.I icon
in its place. Icons are small, and can be moved around the same way as
windows can be - by holding down the MIDDLE mouse button over them and
dragging. By keeping windows that you are not using closed, you can
prevent them from cluttering the screen
.I desktop.
To reopen an icon, simply click on it with the RIGHT or LEFT mouse
button. The window will reopen at its original locaation on the screen.
.PP
The button which shows boxes of several sizes is ro reshape the
window. If you click a mouse button on it, and hold the mouse button
down, and move around, a window outline will form. If you leave the
window through any side, that side will start reshaping, and will now
follow the mouse around. You can now go back into the window to reduce
the size. When you release the mouse button, the window changes to the
new shape.
.PP
A third, optional button, which may or may not appear, depending on
what defaults you/your system adminstrator have selected, is a
button with a small keyboard pattern on it will grab the 
.I focus.
After that, even if you move out of the window, anything you type will
still go into that window - this is indicated by its titlebar
remaining highlighted, even when you leave. To restore the old
behaviour (of focusing on the window the mouse cursor is in), you have
to restore the focus to thr Root Window. Since the Root Window has no
buttons on it, you have to use other means to set the focus - menus.
.PP
.B Menus
.PP
Clicking a mouse button in the Root Window and holding it down will
produce a 
.I menu
which 
.I pops-up
at the mouse position. The menu has various items on it, like
"Refresh", and "Focus on Root". As you move the mouse over them, they
highlight to indicate that they can be selected. Releasing the mouse
over one of them selects the item highlighted - for instance "Focus on
Root" will restore the focus to the window the mouse wanders into.
.PP
Some items don't do anything when selected - they are pointers to
other menus, and indicate this with an arrow pointing right on the
right edge. If you move the mouse over the arrow of one of those, for
instance, "New Windows", it will produce another window, with the
entries "24 lines" and "48 lines". Selecting one of those will create
a new 
.I xterm
window on the screen.
Such menus are called
.I walking menus.
(Menus have a whole taxonomy of their own!)
.PP
The behaviour of 
.I twm, 
its menus, its actions on buttons, and so on, can be extensively
customized by editing the 
.I ~/.twmrc
file. (See 
.IR twm (x)).
To customize 
.I awm,
you need to edit the 
.I .awmrc
file and
also your
.I defaults
file, described below. (See
.IR awm (x)).
If you break anything drastically, so that things don't start up, or
do really strange things, and want the good old defaults back, simply
delete (rm) the 
.I .twmrc/.awmrc 
file - the next time you start up X with 
.I x11,
you'll get another. Note that regardless of the window manager you
choose to use eventually, you get default files for all of them.
.PP
.B Defaults, er, Resources
.br
To permit users to specify defaults for applications (color, size,
location, font etc.) without having to type long lists of command line
options, X provides the facility of loading 
.I resource databases
which are essentially files specifying default values. The files are
simple, and as a local convention, we call them 
.IR .X11defaults .type
where
the extension
.I .type
is once again the display type, allowing the user to store different
sets of defaults for the different displays. Initially, the 
.I x11
command copies system default files for the user - these may be edited
and changed as desired.
.PP
For example, the system defaults setup the 
.I xterm
windows to be white characters on a black background on the 
.I bw2
displays. To change that, edit the file
.I ~/.X11defaults.bw2
and change the line
.br
	xterm*reverseVideo:	on
.br
to
.br
	xterm*reverseVideo:	off
.br
This example will only affect those terminal emulators whose
\fIname\fP is xterm - for instance, the console window's name is not
xterm, but 'console'.  To affect ALL terminal emulators, you have to
use the \fIclass\fP rather than the name - the class for the
.I xterm
applications is 
.I XTerm.
So to change all xterms to reverse video, use
.br
	XTerm*reverseVideo:	on
.br
to
.br
	XTerm*reverseVideo:	off
.PP
Resources are usually as "program.name.subname.etc: value", one per line in
resource files, or one per -xrm argument.  Names are hierarchies, usually
corresponding to major structures within an application (where structures are
often objects like windows, panels, menus, scrollbars, etc.).  The various
subnames are called components and are specified left to right from most
general to least general. Instead of names, classnames can be
substituted - these are more general - typically all instances of a
particular program would have the same classname (eg) XTerm for the
xterm program. 
.PP
See 
.IR /usr/doc/resources.X11
for a fuller guide on how to set up resources, and the 
.IR X (x)
manual page for more information on resources and command line arguments.
.PP
.B Other X Applications
.br
The list is growing rapidly enough to make this section obsolete.
Further, since much of the software is distributed by anonymous ftp and
Usenet, it varies from site to site. Very useful applications include
the previewer for TeX, 
.RI ( texx (x))
the ditroff previewer,
.RI ( xtroff (x))
the window dumper and printer,
.RI ( xwd (x), 
.IR xwud (x), 
.IR xpr (x), 
.IR xdpr (x))
which produce snapshots of windows, various editors for graphics and
text, the 
.I xmh
mail reader, the graph-plotting program
.RI ( gnuplot (x)),
the PostScript(tm) interpreter
.Ri ( xps (L)),
a bitmap editor (\fIbitmap\fP(x)),
an access control program (\fIxhost\fP(x)),
user preference setting programs (\fIxset\fP(x), \fIxsetroot\fP(x),
and \fIxmodmap\fP(x)),
a load monitor (\fIxload\fP(x)), clock (\fIxclock\fP(x)),
a font displayer (\fIxfd\fP(x)),
a protocol translator for running X10 programs (\fIx10tox11\fP(x)),
various demos (\fIico\fP(x), \fImuncher\fP(x)).
and of course, games.
.RI  ( xconq (6), 
.IR xfish (x), 
.IR xpuzzle (x), 
.IR puzzle (x)).
Try looking in /usr/bin/X11, or /usr/man/manx.
.PP
.B Programming X Windows
.br
The raw interface to the X Windows server is through the Xlib C
Interface library. There is also a higher level X Toolkit C Interface
library, and a library of \fBwidgets\fP for the X Toolkit called the
Athena Widgets. 
.I (Xaw)
There's another set of widgets called the HP widgets, or 
.I Xw.
There is also a toolkit in the C++ language called
InterViews. There are also toolkits for Common Lisp.
See the respective manuals, or the example programs in the
X Windows source tree (stored locally in \fI/csri3/X.V11R2\fP).
.SH OPTIONS
(These options are for the x11 command - the previous section on
options described the options which most applications provide)
.IP -rv
Starts the initial console xterm in reverse video.
.IP \fIserver\fP
the name of the X Windows server to be started in place of the default
Xsun. Useful for testing new servers. The server name may be followed
by server options. If no server options are given, defaults are used.
("0 -a 4 -t 4 -c -fp \fIfontpath\fP" asking for display 0, an
acceleration of 4 with a threshold of 4, no keyclick, and a default
fontpath) If you change these, remember to specify the display.
.SH "SEE ALSO"
.IR Xsun (x),
.IR Xserver (x),
.IR xinit (x),
.IR uwm (x),
.IR awm (x),
.IR twm (x),
.IR xtroff (x),
.IR texx (x),
.IR plotspice (x),
.IR bitmap (x),
.IR gnuplot (x),
.IR xrdb (x),
.IR xterm (x)
and many more. See section 'x' of the manual.
.SH FILES
.IP ~/.X11defaults.*
Resource files for different displays
.IP ~/.x11startup.*
Startup scripts for various displays. (Executable)
.IP ~/.twmrc
Window manager startup defaults
.IP /usr/local/lib/x11/default.{X11defaults.*,x11startup.*,twmrc}
Defaults which get copied if the user has none.
.SH AUTHOR
Mark Moraes. (University of Toronto)
.SH BUGS
Really BAD things will happen if users set their paths in ~/.cshrc,
and don't make sure that /usr/bin/X11 (where most X11 programs are) is 
.B before
/usr/local and /usr/new. (where most X10 programs are)
The right path order is /usr/bin/X11:/usr/local:/usr/new.
