/*-
 * xhop.c - X11 client to display the HOPALONG fractals
 *          from page 14 of the September 1986 Scientific American.
 *
 * Copyright (c) 1988 by Patrick J. Naughton (naughton@wind.Sun.COM)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * Comments and additions should be sent to the author:
 *
 *                     Patrick J. Naughton
 *                     Window Systems Group, MS 14-40
 *                     Sun Microsystems, Inc.
 *                     2550 Garcia Ave
 *                     Mountain View, CA  94043
 *                     (415) 336-1080
 *
 * Revision History:
 * 31-Aug-88: Written.
 */

#include <stdio.h>
#include <math.h>
#include <X11/X.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "hopalong.h"

#define DEFX 100
#define DEFY 100
#define DEFW 512
#define DEFH 512

#ifdef sparc
#define NPOINTS 1000
#else
#define NPOINTS 100
#endif

Display *dsp = NULL;		/* current display (must be inited) */
int screen;
Window win;			/* window used to cover screen */
GContext gc;			/* graphics context */
int height = 0, width = 0;
int inittime = 15;
int color;
Colormap cmap;
char *pname;


void
error(s1, s2)
char *s1, *s2;
{
    fprintf(stderr, s1, pname, s2);
    exit(1);
}


void
restart()
{
    randomInithop(dsp, win, gc, color, inittime, NPOINTS);
}


void
HandleEvents()
{
XEvent event;
XKeyEvent *xke = (XKeyEvent *) &event;

    restart();
    while (1) {
	while (!XPending(dsp)) {
	    hop();
	    if (hopdone())
		restart();
	}
	XNextEvent(dsp, &event);
	switch(event.type) {
	    case ConfigureNotify:
	    case Expose:
		restart();
	    continue;
	    case GraphicsExpose:
	    case NoExpose:
	    case MapNotify:
	    case UnmapNotify:
	    continue;
	    case KeyPress:
		switch (XLookupKeysym(xke, 0)) {
		    case XK_Return:
		    case XK_space:
			restart();
			continue;
		    case XK_Escape:
			return;
		    default:
			continue;
		}
	    case EnterNotify:
		if (color)
		    XInstallColormap(dsp, cmap);
	    continue;
	    case LeaveNotify:
		if (color)
		    XUninstallColormap(dsp, cmap);
	    continue;
	    default:
		restart();
	    continue;
	}		
    }
}


void
usage()
{
    error("\tusage: %s [-display d] [-geometry g] [-color] [-time n]\n", NULL);
}


main(argc, argv)
int argc;
char *argv[];
{
    XSetWindowAttributes xswa;
    XGCValues xgcv;
    XSizeHints size_hints;
    int i;
    int geomStat;
    char *geom = NULL;
    char *displayName = NULL;
    Status stat;
    char *s;
    int n;

    pname = argv[0];

    for (i = 1; i < argc; i++) {
	s = argv[i];
	n = strlen(s);
	if (!strncmp("-geometry", s, n)) {
	    if (++i >= argc) usage();
	    geom = argv[i];
	}
	else if (!strncmp("-display", s, n)) {
	    if (++i >= argc) usage();
	    displayName = argv[i];
	}
	else if (!strncmp("-color", s, n)) {
	    color = True;
	}
	else if (!strncmp("-time", s, n)) {
	    if (++i >= argc) usage();
	    inittime = atoi(argv[i]);
	}
	else usage();
    }

    if (!(dsp = XOpenDisplay(displayName)))
	error("%s: unable to open display, %s.\n", displayName);

    srandom(getpid());

    screen = DefaultScreen(dsp);

    stat = XCreateHSBColormap(dsp, screen, &cmap,
	0.0, 1.0, 1.0,
	1.0, 1.0, 1.0);
    if (stat != Success)
	error("%s: unable create colormap (%d).\n", stat);


    size_hints.x = DEFX;
    size_hints.y = DEFY;
    size_hints.width = DEFW;
    size_hints.height = DEFH;

    size_hints.flags = 0;
    if (geom) {
	geomStat = XParseGeometry(geom, &(size_hints.x),
                                        &(size_hints.y),
                                        &(size_hints.width),
                                        &(size_hints.height));
	if (geomStat & (XValue | YValue)) {
	    size_hints.flags |= USPosition;
	}
	if (geomStat & (WidthValue | HeightValue)) {
	    size_hints.flags |= USSize;
	}    
    }

    xswa.event_mask = ExposureMask | KeyPressMask
		 | EnterWindowMask | LeaveWindowMask
		 | StructureNotifyMask;

    xswa.background_pixel = BlackPixel(dsp, screen);


    win = XCreateWindow(
	dsp,
	DefaultRootWindow(dsp),
	size_hints.x,
	size_hints.y,
	size_hints.width,
	size_hints.height,
	1,			/* borderwidth */
	CopyFromParent,		/* depth */
	InputOutput,		/* class */
	CopyFromParent,		/* visual */
	CWBackPixel |
	CWEventMask,		/* window attribute mask */
	&xswa			/* the attributes */
    );

    XSetStandardProperties(dsp, win, " XHop ", " XHOPALONG ",
	NULL, argv, argc, &size_hints);

    xgcv.foreground = BlackPixel(dsp, screen);
    xgcv.background = WhitePixel(dsp, screen);
    gc = (GContext) XCreateGC(dsp, win, GCForeground | GCBackground, &xgcv);

    XMapWindow(dsp, win);

    HandleEvents();

    XUnmapWindow(dsp, win);
    XDestroyWindow(dsp, win);
    XFlush(dsp);
    XCloseDisplay(dsp);
}
