/* $Header: obj_line.c,v 1.3 88/08/31 23:44:11 moraes Exp $ */
/* Procedures for the line object */

#include <values.h>

#include "xpic.h"
#include "windows.h"
#include "gels.h"
#include "draw.h"
#include "assert.h"

static int x1, y1, x2, y2;			/* Corners of box, ellipse, ends of line */
static int xmin, xmax, ymin, ymax;	/* Bounding box */
static PointList *ptList;

/* Handles events for LINE mode */
line_event(evtype, mx, my)
int evtype;		/* One of MOUSE, LEFT, MIDDLE, RIGHT */
int mx, my;		/* Snapped position of the mouse */
{
	switch (evtype) {
	case MOTION | START_MODE:
	case RIGHT  | START_MODE:
	case MIDDLE | START_MODE:
	case REDRAW | START_MODE:
		break;
	case MOTION | END_MODE:
		if (((line_arrow & ST_ARROW) != 0) && (nVerts == 1))
			Arrow(picDpy, picWin, x2, y2, x1, y1, gcInvert);
		if ((line_arrow & EN_ARROW) != 0)
			Arrow(picDpy, picWin, x1, y1, x2, y2, gcInvert);
		line(picWin, x1, y1, x2, y2, gcInvert);
		x2 = mx;
		y2 = my;
		line(picWin, x1, y1, x2, y2, gcInvert);
		if (((line_arrow & ST_ARROW) != 0) && (nVerts == 1))
			Arrow(picDpy, picWin, x2, y2, x1, y1, gcInvert);
		if ((line_arrow & EN_ARROW) != 0)
			Arrow(picDpy, picWin, x1, y1, x2, y2, gcInvert);
		break;
	case LEFT | START_MODE:
		xmin = xmax = x1 = x2 = verts[0].x = mx;
		ymin = ymax = y1 = y2 = verts[0].y = my;
		nVerts = 1;
		drawingMode = END_MODE;
		break;
	case LEFT | END_MODE:
		if (nVerts + 1 >= maxVerts) {
			maxVerts += INC_VERTS;
#ifdef DEBUG
			fprintf(stderr, "Reallocing verts to %d\n", maxVerts);
#endif
			if ((verts = (XPoint *) realloc(verts, 
			 maxVerts * sizeof(XPoint))) == NULL) {
				message("No more memory for vertices");
				break;
			}
		}
		if (((line_arrow & ST_ARROW) != 0) && (nVerts == 1))
			Arrow(picDpy, picWin, x2, y2, x1, y1, gcInvert);
		if ((line_arrow & EN_ARROW) != 0)
			Arrow(picDpy, picWin, x1, y1, x2, y2, gcInvert);
		line(picWin, x1, y1, x2, y2, gcInvert);
		verts[nVerts].x = x2 = mx;
		verts[nVerts].y = y2 = my;
		xmin = MIN(xmin, mx);
		xmax = MAX(xmax, mx);
		ymin = MIN(ymin, my);
		ymax = MAX(ymax, my);
		line(picWin, x1, y1, x2, y2, gcInvert);
		if (((line_arrow & ST_ARROW) != 0) && (nVerts == 1))
			Arrow(picDpy, picWin, x2, y2, x1, y1, gcNormal);
		nVerts++;
		x1 = x2;
		y1 = y2;
		break;
	case RIGHT | END_MODE:
		if (((line_arrow & ST_ARROW) != 0) && (nVerts == 1))
			Arrow(picDpy, picWin, x2, y2, x1, y1, gcInvert);
		if ((line_arrow & EN_ARROW) != 0)
			Arrow(picDpy, picWin, x1, y1, x2, y2, gcInvert);
		line(picWin, x1, y1, x2, y2, gcInvert);
		if (((line_arrow & EN_ARROW) != 0) && (nVerts > 1))
			Arrow(picDpy, picWin, verts[nVerts - 2].x, verts[nVerts - 2].y,
			 x1, y1, gcInvert);
		drawingMode = START_MODE;
		if (nVerts <= 1)
			break;
		if ((ptList = NewPtList(verts, nVerts)) == NULL)
			message("No more memory for line/spline");
		else {			
			AddLineGel(&(CurrentCell->gelList), LINE, ptList,
			 line_type | line_arrow, xmin, ymin, xmax, ymax, lineThickness);
			FreeGel(CurrentCell->undoList);
			CurrentCell->undoList = NULL;
			CurrentCell->undo = 1;
			CurrentCell->saved |= MODIFIED;
		}
		break;
	case MIDDLE | END_MODE:
		if ((line_arrow & ST_ARROW) != 0)
			Arrow(picDpy, picWin, verts[1].x, verts[1].y, verts[0].x, 
			 verts[0].y, gcInvert);
		if ((line_arrow & EN_ARROW) != 0)
			Arrow(picDpy, picWin, x1, y1, x2, y2, gcInvert);
		verts[nVerts].x = mx;
		verts[nVerts].y = my;
		nVerts++;
		/* erase the whole line */
		XDrawLines(picDpy, picWin, gcInvert, verts, nVerts, CoordModeOrigin);
		drawingMode = START_MODE;
		break;
	case REDRAW | END_MODE:
		XDrawLines(picDpy, picWin, gcInvert, verts, nVerts, CoordModeOrigin);
		line(picWin, x1, y1, x2, y2, gcInvert);
		if (((line_arrow & ST_ARROW) != 0) && (nVerts == 1))
			Arrow(picDpy, picWin, x2, y2, x1, y1, gcInvert);
		if ((line_arrow & EN_ARROW) != 0)
			Arrow(picDpy, picWin, x1, y1, x2, y2, gcInvert);
		break;
	default:
#ifdef DEBUG
		sprintf(errstring, "Hey! Unknown LINE mode %d", drawingMode);
		message(errstring);
#endif
		break;
	}
	ASSERT(allock(), "line_event");
}
	

line_abort()
{
	line_event((RIGHT | drawingMode), 0, 0);
}


line_adj(evtype, gel, mx, my)
int evtype;
Gel *gel;
int mx, my;
{
	static XPoint *v;
	static XPoint *adjusted;
	static int arrowstyle, start, end, npts;
	static Gel *linegel, *oldlinegel;
	/*
	 *  Will not need to process MOTION|START_MODE, RIGHT|START_MODE,
	 *  REDRAW|START_MODE - these are taken care of in
	 *  the adj_element routine.
	 */
	switch(evtype) {
	case MOTION | END_MODE:
		DrawLineSection(v, npts, tmpGcInvert, start, end);
		adjusted->x = mx;
		adjusted->y = my;
		DrawLineSection(v, npts, tmpGcInvert, start, end);
		break;
	case LEFT | START_MODE:
		linegel = CopyGel(gel, 1);
		oldlinegel = gel;
		gel = NULL;
		GetClosestLinePoint(linegel, mx, my, &v, &npts, &adjusted, 
		 &start, &end);
		/* Line has been erased in element_adjust, so we redraw inverted */
		GelDraw(linegel, INVERT);
		drawingMode = END_MODE;
		setwidth(tmpGcNormal, linegel->linewidth);
		setwidth(tmpGcInvert, linegel->linewidth);
		SETDASHES(tmpGcNormal, getlinestyle(linegel->attributes))
		SETDASHES(tmpGcInvert, getlinestyle(linegel->attributes))
		arrowstyle = getlinearrow(linegel->attributes);
		start = start && (arrowstyle & ST_ARROW);
		end = end && (arrowstyle & EN_ARROW);
		break;
	case LEFT | END_MODE:
		DrawLineSection(v, npts, tmpGcInvert, start, end);
		adjusted->x = mx;
		adjusted->y = my;
		update_box(linegel->b_box, mx, my);
		GelDraw(linegel, DRAW);
		PushGel(&(CurrentCell->gelList), linegel);
		linegel = NULL;
		FreeGel(CurrentCell->undoList);
		CurrentCell->undoList = oldlinegel;
		CurrentCell->undo = 1;
		CurrentCell->saved |= MODIFIED;
		drawingMode = START_MODE;
		break;
	case RIGHT | END_MODE:
	case MIDDLE | END_MODE:
		DrawLineSection(v, npts, tmpGcInvert, start, end);
		GelDraw(oldlinegel, DRAW);
		PushUnderUndo(&(CurrentCell->gelList), oldlinegel, CurrentCell->undo);
		oldlinegel = NULL;
		FreeGel(linegel);
		linegel = NULL;
		if (evtype == (MIDDLE | END_MODE))
			ClearGelFlags(CurrentCell->gelList);
		drawingMode = START_MODE;
		break;
	case MIDDLE | START_MODE:
		ClearGelFlags(CurrentCell->gelList);
		break;
	case REDRAW | END_MODE:
		DrawLineSection(v, npts, tmpGcInvert, start, end);
		break;
	default:
#ifdef DEBUG
		sprintf(errstring, "Hey! Unknown mode %d in line_adj", 
		 evtype);
		message(errstring);
#endif
		break;
	}
	ASSERT(allock(), "line_adj");
}


DrawLineSection(v, npts, gc, start, end)
XPoint *v;
GC gc;
int start, end, npts;
{
	XDrawLines(picDpy, picWin, gc, v, npts, CoordModeOrigin);

	if (start)
		Arrow(picDpy, picWin, v[1].x, v[1].y, v[0].x, v[0].y, gc);
	if (end)
		Arrow(picDpy, picWin, v[0].x, v[0].y, v[1].x, v[1].y, gc);
}


/*
 *  Finds the closest point in the line gel 'g' to mx, my and
 *  puts the points in 'v'. Caller must allocate space for v. 'adjusted'
 *  will point to the closest point in the gel pointlist, and start and
 *  end will be set depending on whether the point is the start or end
 *  point. 'npts' is the number of points in v, usually 3, but 2 if one
 *  of the points is an endpoint.
 */
GetClosestLinePoint(g, mx, my, v, npts, adjusted, start, end)
Gel *g;
XPoint **v;
XPoint **adjusted;
int *start, *end, *npts;
int mx, my;
{
	register int i;
	int mindist = MAXINT;
	int dist;
	int closest;
	int n = ((PointList *) g->data)->nVerts;
	XPoint *vertices = ((PointList *) g->data)->v;

	*adjusted = vertices;
	for (i = 0; i < n; i++, vertices++) {
		dist = (vertices->x - mx)*(vertices->x - mx) + 
		 (vertices->y - my)*(vertices->y - my);
		if (dist < mindist) {
			closest = i;
			*adjusted = vertices;
			mindist = dist;
		}
	}
	*npts = 3;
	if (closest == 0) {
		*start = TRUE;
		*v = *adjusted;
		(*npts)--;
	} else {
		*start = FALSE;
		*v = *adjusted - 1;
	}
	if (closest == n - 1) {
		*end = TRUE;
		(*npts)--;
	} else {
		*end = FALSE;
	}
	ASSERT((*npts != 1), "One point line");
}
