% Prolog for xpic to PostScript converter
% Author: Mark Moraes
% $Header: x2ps.pro,v 1.2 88/03/19 16:50:09 moraes Exp 
%	%d D - change style SOLID, DOTTED, SHORT-DASH, LONG-DASH, DOT-DASH
%	%s F - change font to fontname
%	%d S - change size (font size in points)
%	(%s) rj %d t - text right just. (%d is TOPLINE, MIDLINE, BOTLINE)
%	(%s) lj %d t - text left just. (%d is TOPLINE, MIDLINE, BOTLINE)
%	(%s) ce %d t - text centered (%d is TOPLINE, MIDLINE, BOTLINE)
%	%d %d l - lineto
%	%d %d m - moveto
%	%d %d s - spline segment
%	x - flush line, spline
%	<wid> <ht> <x> <y> b - box
%	<wid> <ht> <x> <y> e - ellipse
%	%d ss - setscale
%	%d W - change linewidth
save 50 dict begin /xpic exch def
/StartXpic {newpath 0 0 moveto [] 0 setdash 0 setgray 1 setlinecap} def
% Set defaults
/fontname /Times-Roman def
/ptsize 12 def
% halign has the values for MIDLINE, TOPLINE, BOTLINE
/halign 3 array def
/s {rcurveto} def
/x {stroke} def
/l {lineto} def
/m {moveto} def
/b {
	/ury exch def /urx exch def /lly exch def /llx exch def 
	llx lly moveto urx lly lineto urx ury lineto 
	llx ury lineto llx lly lineto stroke
} def
/mtrx matrix def
/e {
	/yc exch def /xc exch def /yrad exch def /xrad exch def
	xc xrad add yc moveto
	/savematrix mtrx currentmatrix def
	xc yc translate
	xrad yrad scale
	0 0 1 0 360 arc
	savematrix setmatrix stroke
} def
% The next three take the text string, and moveto the right horiz. position
% leaving the string on the stack.
/lj {} def
/rj {dup stringwidth pop neg 0 rmoveto} def
/ce {dup stringwidth pop 2 div neg 0 rmoveto} def
% And this is invoked after one of the three above, and 
% computes the vert. pos, and then displays the string.
/t {halign exch get 0 exch rmoveto show newpath} def
% Store an array of patterns in /styles - a pattern is an array consisting 
% of an array and an offset. Corresp to xpic patterns
% solid, dotted, short-dashed, long-dashed, dot-dashed
/styles [ [] 0 ] [ [1 3] 0 ] [ [4 4] 0 ] [ [8 4] 0 ] [ [1 4 4 4] 0 ]
	5 array astore def
% change style to arg.
/D {stroke styles exch get aload pop setdash newpath} def
/W {stroke 0.5 mul setlinewidth newpath} def
% fontbox takes a fontname off the stack, and returns an array
% containing the values of the bottom line of the bounding box, the
% mid line of the bounding box, and the top line of the bounding box
% of that font, taken from the baseline, scaled to a font of size 1
/fontbox {
	findfont dup /FontMatrix get /fm exch def /FontBBox get aload pop
	/ytop exch def pop /ybot exch def pop
	/ymid ytop ybot sub 2 div def
	0 ybot fm dtransform exch pop % botline
	dup neg exch % midline - this works better than (ytop-ybot)/2!
	0 ytop fm dtransform exch pop exch %topline
	% now in the order midline, topline, botline.
	3 array astore
} def
% select font
/F {
	dup /fontname exch def fontbox
	/thisfontbox exch def SF 
} def
% set point size
/S {/ptsize exch def SF} def
% actually set font
/SF {
	fontname findfont ptsize curscale div scalefont setfont
	thisfontbox aload pop
	1 1 3 {
		pop ptsize mul curscale div neg 3 1 roll
	} for
	halign astore pop
} def
% sets the scale to 72 / n, where n is on the stack, and stores the value
% in curscale for font scaling
/curscale 1 def
/ss {/curscale exch 72 exch div dup dup scale def} def
/land {90 rotate} def
StartXpic
