# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Label.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

static Arg		key_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 0 },
	{ XtNresizable,		(XtArgVal) TRUE }
};

void
key_form_setup(name, ly)
	char	*name;
	layoptr	ly;
{
	Widget	key_form;
	Widget	key_label;
	Arg	arg;

	key_form = XtCreateManagedWidget("keyForm", formWidgetClass,
					 ly->ly_parent,
					 (ArgList) key_form_args,
					 XtNumber(key_form_args));

	if (ly->ly_horiz != (Widget) NULL) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(key_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) NULL) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(key_form, &arg, 1);
	}

	XtSetArg(arg, XtNvertDistance, 0);
	XtSetValues(key_form, &arg, 1);
	XtSetArg(arg, XtNhorizDistance, 0);
	XtSetValues(key_form, &arg, 1);

	add_form(key_form);

	key_label = XtCreateManagedWidget("keyLabel", labelWidgetClass,
					  key_form, (ArgList) NULL, 0);

	XtSetArg(arg, XtNlabel, name);
	XtSetValues(key_label, &arg, 1);
	XtSetArg(arg, XtNborderWidth, 0);
	XtSetValues(key_label, &arg, 1);

	ly->ly_label = key_label;
	ly->ly_vert = key_label;
	ly->ly_parent = key_form;
}
