# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Label.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

static Arg		mouse_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 0 },
	{ XtNresizable,		(XtArgVal) TRUE }
};

void
mouse_form_setup(name, ly)
	char	*name;
	layoptr	ly;
{
	Widget	mouse_form;
	Widget	mouse_label;
	Arg	arg;

	mouse_form = XtCreateManagedWidget("mouseForm", formWidgetClass,
					   ly->ly_parent,
					   (ArgList) mouse_form_args,
					   XtNumber(mouse_form_args));

	if (ly->ly_horiz != (Widget) NULL) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(mouse_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) NULL) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(mouse_form, &arg, 1);
	}

	XtSetArg(arg, XtNvertDistance, 0);
	XtSetValues(mouse_form, &arg, 1);
	XtSetArg(arg, XtNhorizDistance, 0);
	XtSetValues(mouse_form, &arg, 1);

	add_form(mouse_form);

	mouse_label = XtCreateManagedWidget("mouseLabel", labelWidgetClass,
					    mouse_form, (ArgList) NULL, 0);

	XtSetArg(arg, XtNlabel, name);
	XtSetValues(mouse_label, &arg, 1);
	XtSetArg(arg, XtNborderWidth, 0);
	XtSetValues(mouse_label, &arg, 1);

	ly->ly_label = mouse_label;
	ly->ly_vert = mouse_label;
	ly->ly_parent = mouse_form;
}

# ifdef notdef
void
fix_label(ly)
	layoptr	ly;
{
	Arg	arg;

	XtSetArg(arg, XtNwidth, 0);
	XtGetValues(ly->ly_parent, &arg, 1);
	XtUnmapWidget(ly->ly_label);
	XtSetValues(ly->ly_label, &arg, 1);
	XtMapWidget(ly->ly_label);
}
# endif notdef
