# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Label.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

static Arg		screen_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 0 },
	{ XtNresizable,		(XtArgVal) TRUE }
};

void
screen_form_setup(name, ly)
	char	*name;
	layoptr	ly;
{
	Widget	screen_form;
	Widget	screen_label;
	Arg	arg;

	screen_form = XtCreateManagedWidget("screenForm", formWidgetClass,
					    ly->ly_parent,
					    (ArgList) screen_form_args,
					    XtNumber(screen_form_args));

	if (ly->ly_horiz != (Widget) NULL) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(screen_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) NULL) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(screen_form, &arg, 1);
	}

	XtSetArg(arg, XtNvertDistance, 0);
	XtSetValues(screen_form, &arg, 1);
	XtSetArg(arg, XtNhorizDistance, 0);
	XtSetValues(screen_form, &arg, 1);

	add_form(screen_form);

	screen_label = XtCreateManagedWidget("screenLabel", labelWidgetClass,
					     screen_form, (ArgList) NULL, 0);

	XtSetArg(arg, XtNlabel, name);
	XtSetValues(screen_label, &arg, 1);
	XtSetArg(arg, XtNborderWidth, 0);
	XtSetValues(screen_label, &arg, 1);

	ly->ly_label = screen_label;
	ly->ly_vert = screen_label;
	ly->ly_parent = screen_form;
}
