# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/AsciiText.h>
# include <X11/Scroll.h>
# include <X11/Command.h>
# include <X11/Form.h>
# include <stdio.h>

# include "globs.h"
# include "layo.h"

/* BUG */
typedef struct {
	int	firstPos;
	int	length;
	char	*ptr;
	Atom	format;
} XtTextBlock, *XtTextBlockPtr;
/* END BUG */

# define SLIDER_WIDTH	50
# define TEXT_LEN	6

static XtTranslations	slider_trans;

struct slider_info {
	Widget		sl_text;
	Widget		sl_scroll;
	void		(*sl_set_proc)();
	char		*sl_buf;
	int		sl_max;
	int		sl_min;
};

static Arg		slider_form_args[] = {
	{ XtNborderWidth,	(XtArgVal) 1 }
};

static Arg		slider_scroll_args[] = {
	{ XtNorientation,	(XtArgVal) XtorientHorizontal },
	{ XtNlength,		(XtArgVal) SLIDER_WIDTH },
	{ XtNvertDistance,	(XtArgVal) 0 }
};

static Arg		slider_text_args[] = {
	{ XtNstring,		(XtArgVal) NULL },
	{ XtNeditType,		(XtArgVal) XttextEdit },
	{ XtNwidth,		(XtArgVal) SLIDER_WIDTH },
	{ XtNlength,		(XtArgVal) TEXT_LEN },
	{ XtNcallback,		(XtArgVal) NULL },
/*	{ XtNinsertPosition,	(XtArgVal) TEXT_LEN }, */
};

static struct slider_info *
sl_setup(set_proc, get_proc, min, max)
	void			(*set_proc)();
	unsigned int		(*get_proc)();
	int			min, max;
{
	extern char		*calloc();
	struct slider_info	*sl;

	sl = (struct slider_info *) calloc(1, sizeof(struct slider_info));
	if (sl == NULL) {
		perror("malloc");
		return(NULL);
	}

	sl->sl_buf = calloc(128, sizeof(char));
	if (sl->sl_buf == NULL) {
		perror("malloc");
		return(NULL);
	}

	sprintf(sl->sl_buf, "%d", (*get_proc)());

	sl->sl_set_proc = set_proc;
	sl->sl_min = min;
	sl->sl_max = max;

	return(sl);
}

static void
slider_button_proc(w, client_data, call_data)
	Widget			w;
	caddr_t			client_data;
	caddr_t			call_data;
{
	struct slider_info	*sl;
	float			slider_pos;
	int			value;

	sl = (struct slider_info *) client_data;
	if (sscanf(sl->sl_buf, "%d", &value) != 1)
		return;

	if (value > sl->sl_max)
		value = sl->sl_max;
	if (value < sl->sl_min)
		value = sl->sl_min;

	(*sl->sl_set_proc)(value);

	slider_pos = ((float) value - sl->sl_min) / (sl->sl_max - sl->sl_min);
	XtScrollBarSetThumb(sl->sl_scroll, slider_pos, -1.0);
}

static void
slider_scroll_proc(w, closure, top)
	Widget			w;
	caddr_t			closure;
	float			top;
{
	char			buf[128];
	struct slider_info	*sl;
	XtTextPosition		end;
	XtTextBlock		text;

	sl = (struct slider_info *) closure;

	end = strlen(sl->sl_buf);
	sprintf(buf, "%d", (int) (top * (sl->sl_max-sl->sl_min)) + sl->sl_min);
	text.firstPos = 0;
	text.length = strlen(buf);
	text.ptr = &buf[0];
	XtTextReplace(sl->sl_text, (XtTextPosition) 0, end, &text);
}

/*
void
slider_text_proc(w, client_data, call_data)
	Widget		w;
	caddr_t		client_data;
	caddr_t		call_data;
{
	return;
}
*/

slider_setup(name, ly, set_proc, get_proc, min, max)
	char				*name;
	layoptr				ly;
	void				(*set_proc)();
	unsigned int			(*get_proc)();
	int				min, max;
{
	extern struct slider_info	*sl_setup();
	extern void			slider_action_setup();
	static int			slider_action_done;
	struct slider_info		*sl;
	Widget				slider_form;
	Widget				slider_text;
	Widget				slider_scroll;
	Widget				slider_button;
	Arg				arg;
	float				slider_pos;

	if (! slider_action_done) {
		slider_action_setup();
		slider_action_done = 1;
	}

	slider_form = XtCreateManagedWidget("sliderForm", formWidgetClass,
					   ly->ly_parent,
					   (ArgList) slider_form_args,
					   XtNumber(slider_form_args));
	if (ly->ly_horiz != (Widget) 0) {
		XtSetArg(arg, XtNfromHoriz, ly->ly_horiz);
		XtSetValues(slider_form, &arg, 1);
	}
	if (ly->ly_vert != (Widget) 0) {
		XtSetArg(arg, XtNfromVert, ly->ly_vert);
		XtSetValues(slider_form, &arg, 1);
	}

	if ((sl = sl_setup(set_proc, get_proc, min, max)) == NULL)
		exit(1);

	slider_button = XtCreateManagedWidget("sliderButton", commandWidgetClass,
					     slider_form, (ArgList) NULL, 0);
	XtAddCallback(slider_button, XtNcallback, slider_button_proc,
		      (caddr_t) sl);
	XtSetArg(arg, XtNlabel, name);
	XtSetValues(slider_button, &arg, 1);
	
	XtSetArg(slider_text_args[0], XtNstring, sl->sl_buf);
	slider_text = XtCreateManagedWidget("sliderText", asciiStringWidgetClass,
					   slider_form,
					   (ArgList) slider_text_args,
					   XtNumber(slider_text_args));
	XtOverrideTranslations(slider_text, slider_trans);
	XtSetArg(arg, XtNfromVert, slider_button);
	XtSetValues(slider_text, &arg, 1);
	sl->sl_text = slider_text;

	slider_scroll = XtCreateManagedWidget("sliderScroll",
					     scrollbarWidgetClass, slider_form,
					     (ArgList) slider_scroll_args,
					     XtNumber(slider_scroll_args));
	XtAddCallback(slider_scroll, XtNthumbProc, slider_scroll_proc,
		      (caddr_t) sl);
	XtSetArg(arg, XtNfromVert, slider_text);
	XtSetValues(slider_scroll, &arg, 1);
	slider_pos = ((float) (*get_proc)() - min) / (max - min);
	XtScrollBarSetThumb(slider_scroll, slider_pos, -1.0);
	sl->sl_scroll = slider_scroll;

	ly->ly_horiz = slider_form;
}

void
slider_set(w, event, params, nparams)
	Widget		w;
	XEvent		event;
	String		*params;
	Cardinal	*nparams;
{
	return;
}

static XtActionsRec	slider_actions[] = {
	{ "slider_set",	slider_set }
};

static String		slider_translations =
	"Ctrl<Key>M:	slider_set() \n\
	<Key>0xff0d:	slider_set() \n";

void
slider_action_setup() {
	XtAddActions(&slider_actions[0], XtNumber(slider_actions));
	slider_trans = XtParseTranslationTable(slider_translations);
}
