.TH XPREF 1 
.SH NAME
xpref \- a preference setting tool
.SH SYNOPSIS
xpref [normal Xaw options]
.SH DESCRIPTION
.I xpref
is sort of an Xaw version of
.I xset.
You can set your preferences
via buttons, scroll bars, or type-in text windows.  Things that toggle
(keyboard auto repeat, screen blanking, and screen exposures) can be
set with on/off buttons and take effect immediately.  Things that take
values (keyboard click, bell volume, pitch, and duration, mouse
acceleration numerator, acceleration denomintor, and threshold, and
screen time-out and cycle) can be set with a scroll bar or type-in
text window and don't take effect until you press the (label) button
directly above the type-in window.  Things that toggle display the the
current setting by dimming it (for example, if keyboard repeat is off
then the off button is dimmed).  Things that take a value display the
current value in the type-in window and position the scroll bar at
that position.
.SH OPTIONS
.I xpref
takes all of the standard toolkit options.
.SH "X DEFAULTS"
The available names (classes) for the widgets used are:
.IP topForm 1.3i
(Form)
.IP keyForm
(Form)
.IP keyLabel
(Label)
.IP bellForm
(Form)
.IP bellLabel
(Label)
.IP mouseForm
(Form)
.IP mouseLabel
(Label)
.IP screenForm
(Form)
.IP screenLabel
(Label)
.IP thumbForm
(Form)
.IP thumbButton
(Command)
.IP thumbText
(Text)
.IP thumbScroll
(Scrollbar)
.IP toggleForm
(Form)
.IP toggleLabel
(Label)
.IP toggleOn
(Command)
.IP toggleOff
(Command)
.IP quitForm
(Form)
.IP quitButton
(Command)
.PP
These can be used to set fonts, colors, etc. tailored to the user's
needs.  As a color example:
.PP
.RS
.ta 4i
.nf
xpref*keyForm.Background:	yellow
xpref*bellForm.Background:	orange
xpref*mouseForm.Background:	pink
xpref*screenForm.Background:	cyan
xpref*screenForm*Label.Background:	yellow
xpref*Label.Font:	9x15
xpref*thumbForm.Command.Font:	helvetica10
xpref*toggleForm.Label.Font:	helvetica12b
.fi
.RE
.SH AUTHORS
.ta 1.2i
Program:	Rusty C. Wright
.br
	rusty@cartan.berkeley.edu
.br
	ucbvax!cartan!rusty
.sp
Man page:	Dana Chee
.br
	dana@bellcore.com
.br
	{standard gateways}!bellcore!dana
