#ifndef SUNTOOLS
/*
 *  X Windows routines - These pretty closely mirror the SunView
 *  interface in sunwindows.c. The main difference is that this has more
 *  and more flexible bindings, and has the Next-Section, Prev-Section
 *  bindings. This one also lacks the StatusPanel stuff - nice, but
 *  somewhat unnecessary in my opinion. Instead, it has an emacs-style
 *  Minibuffer at the bottom for interaction. It also lacks the feature
 *  to Print the file or page - sheer laziness. The code is there - just
 *  didn't bother to call the routines because it also means fixing the
 *  printcaps. Sigh! The suntroff code is remarkably independent of the
 *  window system - the routines in this file or windows.c set up the
 *  frame window (a Form), the drawing window (Chris Peterson's
 *  Window.c, lifted straight from xman. It should be in Xaw), the event
 *  handlers, and menus(the menu widget in contrib/menus). The only
 *  other X dependent code is in draw.c and a small chunk in the
 *  LoadFontBits() routine in font.c!  Its been ifdef'ed assuming
 *  that if you're not compiling for SUNTOOLS, you're compiling for
 *  X11.  - Mark Moraes.
 */
#ifndef lint
static char rcsid[]="$Header";
#endif

#include	<stdio.h>
#include	<ctype.h>
#include	<signal.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<X11/Intrinsic.h>
#include	<X11/StringDefs.h>
#include	<X11/Shell.h>
#include 	<X11/Scroll.h>
#include	<X11/Form.h>
#include	"Window.h"	/* Chris Peterson's Window widget */
#include 	"Minibuf.h"	/* My Minibuf widget */
#include 	"Menu.h"	/* contrib/menus after Dana Chee's fixes */
#include	<X11/cursorfont.h>
#include	<X11/Xutil.h>

#define YES 	 1
#define NO 	 0
#define ABORT 	-1

/*
 *  These are the various actions allowed in the canvas window - each
 *  related to a procedure
 */
static void StartPan(), EndPan(), PagePan(), Number(), EscapeNumber(), 
	GoToPage(), ForwardPage(), BackPage(), NextSection(), PrevSection(),
	Quit(),	SetMenuPos(), MenuSelection(), Rerasterize();
	
static XtActionsRec canvasActionTable[] = {
	{"SetMenuPos",	SetMenuPos},
	{"start-pan",	StartPan},
	{"end-pan",	EndPan},
	{"page-pan", 	PagePan},
	{"number",	Number},
	{"escape",	EscapeNumber},
	{"go-to-page",	GoToPage},
	{"forward-page",ForwardPage},
	{"back-page",	BackPage},
	{"next-section",NextSection},
	{"prev-section",PrevSection},
	{"rerasterize", Rerasterize},
	{"quit",	Quit},
};

/* 
 *  These are default bindings for the actions in the canvas window. All
 *  actions except MenuPopup and MenuPopdown are defined in the action
 *  table above, and have corresp callback routines in this file.
 *  MenuPopup and MenuPopdown are provided by the Xt Intrinsics - for
 *  some reason, it doesn't seem possible to create a spring-loaded
 *  shell from an application other than by these two actions. I'd have
 *  preferred an XtPopup() with a spring-loaded parameter, and there's
 *  even such a routine in the Toolkit - _XtPopup! Of course, I may
 *  just be missing something obvious... I plead guilty to complete
 *  (well, almost complete) incomprehension of the Toolkit Intrinsics
 *  doc. - moraes
 */
static String canvasTransTbl = 
	"<Btn3Down>:	SetMenuPos() MenuPopup(popupShell)\n\
	<Btn3Up>:	MenuPopdown(popupShell)\n\
	<Btn2Down>:	start-pan()\n\
	<Btn2Up>:	end-pan()\n\
	<LeaveWindow>:	end-pan()\n\
	<Btn2Motion>:	page-pan()\n\
	<Key>0x30:	number()\n\
	<Key>0x31:	number()\n\
	<Key>0x32:	number()\n\
	<Key>0x33:	number()\n\
	<Key>0x34:	number()\n\
	<Key>0x35:	number()\n\
	<Key>0x36:	number()\n\
	<Key>0x37:	number()\n\
	<Key>0x38:	number()\n\
	<Key>0x39:	number()\n\
	<Key>0xff1b:	escape()\n\
	<Key>P:		back-page()\n\
	<Key>B:		back-page()\n\
	<Key>-:		back-page()\n\
	<Key>0xff7f:	back-page()\n\
	<Key>0xff08:	back-page()\n\
	<Key>0xffff:	back-page()\n\
	Ctrl<Key>H:	back-page()\n\
	<Key>0xff51:	back-page()\n\
	<Key>N:		forward-page()\n\
	<Key>F:		forward-page()\n\
	<Key>+:		forward-page()\n\
	<Key>0xff0d:	forward-page()\n\
	Ctrl<Key>M:	forward-page()\n\
	<Key>0xff0a:	forward-page()\n\
	Ctrl<Key>J:	forward-page()\n\
	<Key>0xff53:	forward-page()\n\
	Shift<Btn1Down>:prev-section()\n\
	<Key>0xff52:	prev-section()\n\
	<Btn1Down>:	next-section()\n\
	<Key>0x20:	next-section()\n\
	<Key>0xff54:	next-section()\n\
	<Key>G:		go-to-page()\n\
	<Key>R:		rerasterize()\n\
	<Key>Q:		quit()\n\
	";

#include	"suntroff.h"

/* Preserved most of the sunview names */
Window	OuterFrame;
Widget	BaseFrame;		/* Top Level Window Frame */
Widget	CanvasWidget;
Window	DrawingCanvas;		/* Main Drawing Window for Text */
Widget	MainMenu;		/* Top Level User Menu */
Widget	PopupShell;		/* Popup Shell enclosing the Main menu */
Widget	HorizScroll;		/* Horizontal Scroll Bar */
Widget	VertScroll;		/* Vertical Scroll Bar */
Widget	InputWidget = NULL;	/* Minibuffer widget for input and dislay */
Window 	InputWin;
Pixmap	PagePixRect;		/* Full Page Pix Rect for Drawing Page */
int	ViewLeft = 0, ViewTop = 0;	/* Page Offset for display */
/* Set these to the window height and width */
int 	ViewWidth = 0, ViewHeight = 0;
int	OriginalX = -1;
int	OriginalY = -1;
int	Scrollbars = 1;		/* Does User want scrollbars????? */
char	*homeDir;

/* 
 *  The following icon of a hand was generated by Stefano Concino@SPAR.
 */
#define hand_width 16
#define hand_height 16
#define hand_x_hot 8
#define hand_y_hot 8
static char hand_bits[] = {
   0x80, 0x00, 0x40, 0x09, 0x48, 0x15, 0x54, 0x15, 0x54, 0x15, 0x54, 0x15,
   0x54, 0x15, 0x54, 0x15, 0x74, 0xd2, 0x04, 0xa8, 0x08, 0xa8, 0x18, 0xa8,
   0x30, 0x90, 0x20, 0x40, 0x20, 0x20, 0x60, 0x18};

static char hand_mask_bits[] = {
   0xc0, 0x09, 0x68, 0x1d, 0x7e, 0x37, 0x76, 0x37, 0x76, 0x37, 0x76, 0x37,
   0x76, 0x37, 0x76, 0xf7, 0x76, 0xf2, 0x06, 0xb8, 0x0e, 0xb8, 0x1c, 0xb8,
   0x3c, 0x90, 0x38, 0xc0, 0x30, 0x60, 0x70, 0x38};

#include "ditroff.bm"

Cursor	HandCursor;
Cursor	WorkingCursor;
Cursor	WaitCursor;

XWMHints xwmh;

Pixel fgcolor, bgcolor;
/* Needed for the undocumented XCreatePixmapCursor() */
static XColor bg = {0, 0, 0, 0};
static XColor fg = {0, ~0, ~0, ~0};
unsigned int depth;

Display *dpy;
Screen *scn;
GC gc;			/* The Graphic context we use for all drawing */
GC cleargc;		/* The GC used for clearing the Pixmap */

/*
 *  DON'T CHANGE THE ORDER OF THE ARGS IN THE VARIOUS ARG STRUCTS. IF
 *  YOU WANT TO ADD STUFF, ADD IT AT THE END OF THE STRUCT, BECAUSE WE
 *  REFER TO SOME OF THE ELEMENTS BY POSITION IN THE CODE.
 */
/* No spacing between the widgets on the Form */
static Arg form_args[] = {
	{XtNdefaultDistance, (XtArgVal) 0},
};

static void finished_input();
static XtCallbackRec minibufCallbacks[] = {
	{finished_input, NULL},
	{NULL, NULL},
};

static Arg minibuf_args[] = {
	{XtNwidth, (XtArgVal) 0},
	{XtNfinishedCallback, (XtArgVal) minibufCallbacks},
	{XtNfromVert, (XtArgVal) NULL},
};

/* we use this when we ask what the various attributes of the Canvas. */
static Arg query_args[] = {
	{XtNbackground, (XtArgVal) &bgcolor},
	{XtNforeground, (XtArgVal) &fgcolor},
	{XtNwidth, (XtArgVal) &ViewWidth},
	{XtNheight, (XtArgVal) &ViewHeight},
};

/* args for the canvas window - we fill in translations by hand */
static Arg canvas_args[] = {
	{XtNwidth, (XtArgVal) 950},
	{XtNheight, (XtArgVal) 830},
	{XtNfromHoriz, (XtArgVal) NULL},
	{XtNtranslations, 0},
};

static void Scrolled();
static XtCallbackRec scrollCallbacks[] = {
	{ Scrolled, NULL },
	{ NULL, NULL },
};

static void Thumbed();
static XtCallbackRec thumbCallbacks[] = {
	{ Thumbed, NULL },
	{ NULL, NULL },
};

/* 
 *  We change the XtNlength, XtNorientation and XtNfromHoriz by getting
 *  the size from the Canvas - don't take this value seriously.
 *  XtNfromHoriz also changes to XtNfromVert.
 */
static Arg scroll_args[] = {
	XtNlength, (XtArgVal) 850,
	XtNorientation, (XtArgVal) XtorientVertical,
	XtNfromHoriz, (XtArgVal) NULL,
	XtNscrollProc, (XtArgVal) scrollCallbacks,
	XtNthumbProc, (XtArgVal) thumbCallbacks,
};

static MenuItemsList menu_list[] = {
	{"Rerasterize",   MenuSelection, (caddr_t) 1, 0},
	{"Next Page",   MenuSelection, (caddr_t) 2, 0},
	{"Previous Page", MenuSelection, (caddr_t) 3, 0},
	{"Next Page Section",   MenuSelection, (caddr_t) 4, 0},
	{"Previous Page Section", MenuSelection, (caddr_t) 5, 0},
	{"Show Status", MenuSelection, (caddr_t) 6, 0},
	{"Search Forward", MenuSelection, (caddr_t) 7, 0},
	{"Search Backward", MenuSelection, (caddr_t) 8, 0},
	{"Change File", MenuSelection, (caddr_t) 9, 0},
	{"Change Command", MenuSelection, (caddr_t) 10, 0},
	{"Go To Page", MenuSelection, (caddr_t) 11, 0},
	{"Quit",       MenuSelection, (caddr_t) 99, 0},
	{NULL, NULL, NULL, NULL}
};

static Arg menu_args[] = {
	{XtNmenuItemsList, (XtArgVal) menu_list },
};

static int	CurrentPage = 1;/* Current Page Number Being Displayed */
char	FileName[BUFSIZ] = "";	/* File containing ditroff output */
char	TempFileName[BUFSIZ];	/* Temp file that can be deleted. */
char CommandString[BUFSIZ] = "";/* String pointer to ditroff command */
char	*ActualFileName;	/* File that buffers ditroff output */
int	PageRequest = 0;	/* Partially read page number request */
int	CommandMode = 0;	/* Taking input from file or command line */
/* not used in the X version - we don't print any messages. sigh! one day... */
int	ErrorsPending = 0;	/* Set if errors are pending and need to be
				 * displayed.  Used in case tool is iconic
				 * when error message is needed.  This boolean
				 * variable is checked at redisplay time.
				 * This was done at the suggestion of
				 * davy@ecn.purdue.edu.......11/28/86
				 */
int	isMapped = 0;
char 	*SearchItem;

main(argc, argv)
int argc;
char **argv;
{
	char *option;
	XGCValues   gcv;		/* Struct for creating GC */
	Pixmap cursorPixmap, cursorMask;
	void RepaintCanvas();
	static void RecordMapStatus();
	Widget topLevel;
	XtTranslations canvasTranslations;
	extern char *getenv();

	if ((homeDir = getenv("HOME")) == NULL)
		homeDir = "";
	/* make the top level using argc, argv */
	topLevel = XtInitialize("xtroff", "TroffPreviewer", NULL, 0, &argc,
	 argv);
	dpy = XtDisplay(topLevel);
	scn = XtScreen(topLevel);
	depth = DefaultDepthOfScreen(scn);
	/* just one option for ourselves - rest are Toolkit options */
	if (option = XGetDefault(dpy, "xtroff", "scrollbar")) {
		if (strcmp(option, "on") == 0)
			Scrollbars = 1;
		else
			Scrollbars = 0;
	}
	argv++;
	while (*argv && argv[0][0] == '-'){
		if (strncmp(argv[0],"-scrollbar",4) == NULL){
			Scrollbars = 0;
		} else if (strncmp(argv[0],"-command",3) == NULL){
			*CommandString = '\0';
			while (*++argv) {
				strcat(CommandString,*argv);
				strcat(CommandString, " ");
			}
			CommandMode = 1;
		} else {
			fprintf(stderr,"Unknown option %s\n",argv[0]);
		}
		if (*argv){
			argv++;
		}
	}
	if (argv[0] && argv[0][0]){
		CommandMode = 0;
		strcpy(FileName,argv[0]);
	}
#ifdef DEBUG
	if (CommandMode)
		printf("Command = \"%s\"\n", CommandString);
	else {
		if (FileName) printf("File = \"%s\"\n", FileName);
		else printf ("reading from stdin");
	}
#endif
	/* CreatePopUpPanel(); */
	XtAddActions(canvasActionTable, XtNumber(canvasActionTable));
	canvasTranslations = XtParseTranslationTable(canvasTransTbl);
	BaseFrame = XtCreateManagedWidget("form", formWidgetClass, topLevel,
	 form_args, XtNumber(form_args));
	canvas_args[3].value = (XtArgVal) canvasTranslations;
	CanvasWidget = XtCreateManagedWidget("canvas", windowWidgetClass, 
	 BaseFrame, canvas_args, XtNumber(canvas_args));
	XtGetValues(CanvasWidget, query_args, XtNumber(query_args));
	if (Scrollbars) {
		/* vertical scrollbar to the right of the canvas */
		XtSetArg(scroll_args[0], XtNlength, ViewHeight);
		XtSetArg(scroll_args[2], XtNfromHoriz, CanvasWidget);
		VertScroll = XtCreateManagedWidget("vscroll", 
		 scrollbarWidgetClass, BaseFrame, 
		 scroll_args, XtNumber(scroll_args));
		/* horizontal scrollbar below the canvas */
		XtSetArg(scroll_args[0], XtNlength, ViewWidth);
		XtSetArg(scroll_args[1], XtNorientation, XtorientHorizontal);
		XtSetArg(scroll_args[2], XtNfromVert, CanvasWidget);
		HorizScroll = XtCreateManagedWidget("hscroll", 
		 scrollbarWidgetClass, BaseFrame, 
		 scroll_args, XtNumber(scroll_args));
	}
	XtAddEventHandler(CanvasWidget, (Cardinal) ExposureMask, NULL, 
	 RepaintCanvas, "redraw_data");
	XtAddEventHandler(CanvasWidget, (Cardinal) StructureNotifyMask, NULL, 
	 RecordMapStatus, "map_data");
	/* 
	 *  make a menu or button box - ShowStatus, ReRasterize, Print,
	 *  Print Page, previous Page, Next Page, Quit
	 */
	PopupShell = XtCreatePopupShell ("popupShell",
					overrideShellWidgetClass,
					CanvasWidget,
					NULL, 0);
	MainMenu = XtCreateManagedWidget ("mainMenu",
					menuWidgetClass,
					PopupShell,
					(ArgList) menu_args,
					XtNumber (menu_args));
	minibuf_args[0].value = (XtArgVal) ViewWidth;
	if (Scrollbars)
		minibuf_args[2].value = (XtArgVal) HorizScroll;
	else
		minibuf_args[2].value = (XtArgVal) CanvasWidget;
	InputWidget = XtCreateManagedWidget("minibuf", minibufWidgetClass,
		BaseFrame, minibuf_args, XtNumber(minibuf_args));
	if (Scrollbars)
		SetScrollBar();
	XtRealizeWidget(topLevel);
	XFlush(dpy);
	DrawingCanvas = XtWindow(CanvasWidget);
	OuterFrame = XtWindow(topLevel);
	InputWin = XtWindow(InputWidget);

	fg.pixel = fgcolor;
	bg.pixel = bgcolor;
	XQueryColor(dpy, DefaultColormapOfScreen(scn), &fg);
	XQueryColor(dpy, DefaultColormapOfScreen(scn), &bg);
	cursorPixmap = XCreateBitmapFromData(dpy, DrawingCanvas, 
	 hand_bits, hand_width, hand_height);
	cursorMask = XCreateBitmapFromData(dpy, DrawingCanvas, 
	 hand_mask_bits, hand_width, hand_height);
	HandCursor = XCreatePixmapCursor(dpy, cursorPixmap, cursorMask, 
	 &fg, &bg, hand_x_hot, hand_y_hot);
	XFreePixmap(dpy, cursorPixmap);
	XFreePixmap(dpy, cursorMask);

	xwmh.icon_pixmap = XCreatePixmapFromBitmapData(dpy, XtWindow(topLevel),
	 ditroff_bits, ditroff_width, ditroff_height, fgcolor, bgcolor, depth);
	xwmh.flags = IconPixmapHint;
	XSetWMHints(dpy, XtWindow(topLevel), &xwmh);
	WorkingCursor = XCreateFontCursor(dpy, XC_diamond_cross);
	WaitCursor = XCreateFontCursor(dpy, XC_watch);
	XDefineCursor(dpy, DrawingCanvas, WorkingCursor);
	gcv.font = XLoadFont(dpy, "variable");
	gcv.foreground = fgcolor;
	gcv.background = bgcolor;
	gcv.function = GXcopy;
	gc = XCreateGC(dpy, DrawingCanvas, 
	 (GCForeground | GCBackground | GCFunction | GCFont), &gcv);
	gcv.foreground = bgcolor;
	gcv.background = fgcolor;
	cleargc = XCreateGC(dpy, DrawingCanvas, 
	 (GCForeground | GCBackground | GCFunction), &gcv);
	/* Alloc a 1 bit deep pixmap if PAGE_PIXEL_WIDTH X PAGE_PIXEL_HEIGHT */
	PagePixRect = XCreatePixmap(dpy, DrawingCanvas, PAGE_PIXEL_WIDTH, 
	 PAGE_PIXEL_HEIGHT, depth);
	ResizeScrollBar();
	XFlush(dpy);
	/*
	 *  We'll keep changing fonts - simpler, but is it fast enough?
	 *  Should we try setting the font path
	 */
#ifdef DEBUG
	{
		int nfonts;
		int i;
		char **fonts =	XGetFontPath(dpy, &nfonts);
		for (i = 0; i < nfonts; i++) {
			printf("\"%s\"\n", fonts[i]);
		}
		XFreeFontPath(fonts);
	}
#endif
	Rerasterize(BaseFrame, NULL, NULL, NULL);
	XtMainLoop();
	if (*TempFileName)
		unlink(TempFileName);
	exit(0);
}

void RepaintCanvas(w, data, ev)
Widget w;
caddr_t data;
XEvent *ev;
{
	if (!isMapped)
		return;

	/*
	Put the pixmap on the screen at the appropriate
		ViewLeft, ViewTop;
	*/
	if (ev && ev->xexpose.count == 0) {
		XEvent event;
		/* Skip all excess redraws */
		while (XCheckTypedEvent(dpy, Expose, &event))
			;
	}

		
#ifdef WINDOWDEBUG
	printf("repaint - ViewLeft = %d, Top = %d, Width = %d, Height = %d\n", 
	 ViewLeft, ViewTop, ViewWidth, ViewHeight);
#endif
	XCopyArea(dpy, PagePixRect, DrawingCanvas, gc, ViewLeft, ViewTop,
	 ViewWidth, ViewHeight, 0, 0);
	SetScrollBar();
	XFlush(dpy);
}

static void RecordMapStatus(w, data, ev)
Widget w;
caddr_t data;
XEvent *ev;
{
	if (ev->type == MapNotify) {
#ifdef WINDOWDEBUG
		printf("window mapped\n");
#endif
		isMapped = TRUE;
		RepaintCanvas(DrawingCanvas, (caddr_t) NULL, (XEvent *) NULL);
	} else if (ev->type = ConfigureNotify) {
		XConfigureEvent *cev = (XConfigureEvent *) ev;
#ifdef WINDOWDEBUG
		printf("window resized\n");
#endif
		if (cev->width != ViewWidth || cev->height != ViewHeight) {
			ViewWidth = cev->width;
			ViewHeight = cev->height;
			ResizeScrollBar();
		}
	}
}



static void StartPan(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XMotionEvent	*event;
{
	OriginalX = event->x;
	OriginalY = event->y;
#ifdef DEBUG
	printf("starting pan from %d, %d\n", OriginalX, OriginalY);
#endif
	XDefineCursor(dpy, DrawingCanvas, HandCursor);
	PageRequest = 0;
}

static void EndPan(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XMotionEvent	*event;
{
	if (OriginalX != -1 && OriginalY != -1){
		OriginalX = OriginalY = -1;
#ifdef DEBUG
		printf("ending pan\n");
#endif
		XDefineCursor(dpy, DrawingCanvas, WorkingCursor);
	}
	PageRequest = 0;
}

static void PagePan(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XMotionEvent	*event;
{
	ViewLeft -= event->x - OriginalX;
	if (ViewLeft + ViewWidth > PAGE_PIXEL_WIDTH)
	        ViewLeft = PAGE_PIXEL_WIDTH - ViewWidth;
	if (ViewLeft < 0)
		ViewLeft = 0;

	ViewTop -= event->y - OriginalY;
	if (ViewTop + ViewHeight > PAGE_PIXEL_HEIGHT)
	        ViewTop = PAGE_PIXEL_HEIGHT - ViewHeight;
	if (ViewTop < 0)
		ViewTop = 0;
#ifdef DEBUG
	printf("panning - ViewLeft, Top = %d, %d\n", ViewLeft, ViewTop);
#endif
	if ((OriginalX != event->x) || (OriginalY != event->y)){
		XCopyArea(dpy, PagePixRect, DrawingCanvas, gc, ViewLeft,
		 ViewTop, ViewWidth, ViewHeight, 0, 0);
#ifdef DEBUG
		printf("panned\n");
#endif
		OriginalX = event->x;
		OriginalY = event->y;
		SetScrollBar();
	}
	PageRequest = 0;
}


static void Number(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	char ch;
	
	XLookupString(&event->xkey, &ch, 1, NULL, NULL);
	PageRequest = PageRequest*10 + ch - '0';
#ifdef WINDOWDEBUG
	printf("ch = %c, arg = %d\n", ch, PageRequest);
#endif
	
}

static void EscapeNumber(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	PageRequest = 0;
#ifdef WINDOWDEBUG
	printf("arg = 0\n");
#endif
}


static void GoToPage(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
#ifdef WINDOWDEBUG
	printf("goto page %d\n", PageRequest);
#endif
	ViewTop = 0;
	CurrentPage = ShowPage(PageRequest);
	PageRequest = 0;
}

static void BackPage(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	int curpage = CurrentPage;
	
	if (!PageRequest)
		PageRequest++;
	CurrentPage -= PageRequest;
	if (CurrentPage <= 0)
		CurrentPage = 1;
	if (CurrentPage != curpage) {
		ViewTop = 0;
		CurrentPage = ShowPage(CurrentPage);
	}
	PageRequest = 0;
}

static void ForwardPage(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	int curpage = CurrentPage;
	
	if (!PageRequest)
		PageRequest++;
	CurrentPage += PageRequest;
	ViewTop = 0;
	CurrentPage = ShowPage(CurrentPage);
	PageRequest = 0;
}

static void PrevSection(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	int curpage = CurrentPage;

	/* 
	 *  Back up to the previous section to be viewed. If
	 *  the screen is large enough to show the whole
	 *  page, then back up to the previous page. Else
	 *  back up to the previous half of the page. Only
	 *  change ViewTop - leave ViewLeft alone as
	 *  part of the philosophy - in general, the
	 *  width of the page fits nicely on the screen
	 */
	do {
		ViewTop -= ViewHeight;
		if (ViewTop <= -ViewHeight) {
			if (CurrentPage > 1) {
				ViewTop = PAGE_PIXEL_HEIGHT - ViewHeight;
				CurrentPage--;
			} else {
				CurrentPage = 1;
				ViewTop = 0;
				break;
			}
		} else if (ViewTop < 0) {
			ViewTop = 0;
		}
	} while (--PageRequest > 0);
	if (curpage != CurrentPage)
		CurrentPage = ShowPage(CurrentPage);
	else
		RefreshPage();
	PageRequest = 0;
}


static void NextSection(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	int curpage = CurrentPage;

	/* 
	 *  Advance to the next section to be viewed. If
	 *  the screen is large enough to show the whole
	 *  page, then advance to the next page. Else
	 *  advance to the next half of the page. Only
	 *  change ViewTop - leave ViewLeft alone as
	 *  part of the philosophy - in general, the
	 *  width of the page fits nicely on the screen
	 */
	do {
		ViewTop += ViewHeight;
		if (ViewTop >= PAGE_PIXEL_HEIGHT) {
			ViewTop = 0;
			CurrentPage++;
		} else if (ViewTop > PAGE_PIXEL_HEIGHT - ViewHeight) {
			ViewTop = PAGE_PIXEL_HEIGHT - ViewHeight;
		}
	} while (--PageRequest > 0);
	if (curpage != CurrentPage)
		CurrentPage = ShowPage(CurrentPage);
	else
		RefreshPage();
	PageRequest = 0;
}


static void Quit(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;
{
	if (*TempFileName)
		unlink(TempFileName);
	exit(0);
}


/* These are the scrolling and thumbing callbacks */
static void Scrolled(w, closure, call_data)
Widget w;
caddr_t closure;
int call_data;
{
#ifdef WINDOWDEBUG
	printf( "scrolled by %d pixels.\n", call_data );
#endif
	if (w == VertScroll) {
		ViewTop += call_data * PAGE_PIXEL_HEIGHT / ViewHeight;
		if (ViewTop < 0)
			ViewTop = 0;
		else if (ViewTop > PAGE_PIXEL_HEIGHT - ViewHeight)
			ViewTop = PAGE_PIXEL_HEIGHT - ViewHeight;
	} else if (w == HorizScroll) {
		ViewLeft += call_data * PAGE_PIXEL_WIDTH / ViewWidth;
		if (ViewLeft < 0)
			ViewLeft = 0;
		else if (ViewLeft > PAGE_PIXEL_WIDTH - ViewWidth)
			ViewLeft = PAGE_PIXEL_WIDTH - ViewWidth;
	}
	
	XCopyArea(dpy, PagePixRect, DrawingCanvas, gc, ViewLeft, ViewTop,
	 ViewWidth, ViewHeight, 0, 0);
	SetScrollBar();
}


static void Thumbed(w, closure, top)
Widget w;
caddr_t closure;
float top;
{
#ifdef WINDOWDEBUG
	printf( "thumbed to %f%%\n", top );
#endif
	if (w == VertScroll) {
		ViewTop = top * PAGE_PIXEL_HEIGHT;
		if (ViewTop > PAGE_PIXEL_HEIGHT - ViewHeight)
			ViewTop = PAGE_PIXEL_HEIGHT - ViewHeight;
	} else if (w == HorizScroll) {
		ViewLeft = top * PAGE_PIXEL_WIDTH;
		if (ViewLeft > PAGE_PIXEL_WIDTH - ViewWidth)
			ViewLeft = PAGE_PIXEL_WIDTH - ViewWidth;
	}
	XCopyArea(dpy, PagePixRect, DrawingCanvas, gc, ViewLeft, ViewTop,
	 ViewWidth, ViewHeight, 0, 0);
	SetScrollBar();
}


SetScrollBar()
{
	if (!Scrollbars)
		return;
	XtScrollBarSetThumb(VertScroll, 
	 (float) ((float) ViewTop / (float) PAGE_PIXEL_HEIGHT),
	 (float) ((float) ViewHeight / (float) PAGE_PIXEL_HEIGHT));
	XtScrollBarSetThumb(HorizScroll, 
	 (float) ((float) ViewLeft / (float) PAGE_PIXEL_WIDTH),
	 (float) ((float) ViewWidth / (float) PAGE_PIXEL_WIDTH));
}

ResizeScrollBar()
{
	if (!Scrollbars)
		return;
	XtSetArg(scroll_args[0], XtNlength, ViewHeight);
	XtSetValues(VertScroll, scroll_args, 1);
	XtSetArg(scroll_args[0], XtNlength, ViewWidth);
	XtSetValues(HorizScroll, scroll_args, 1);
	SetScrollBar();
}


SearchForward(){
	int	i;
	
	i = SearchFile(SearchItem,CurrentPage,1);
	if (i){
		CurrentPage = i;
		ShowPage(i);
	} else {
		SetTitleBar("Displaying",CurrentPage);
	}
	return(i);
}

SearchBackward(){
	int	i;
	
	i = SearchFile(SearchItem,CurrentPage,-1);
	if (i){
		CurrentPage = i;
		ShowPage(i);
	} else {
		SetTitleBar("Displaying",CurrentPage);
	}
	return(i);
}

		
static void Rerasterize(w, event, params, nparams)
Widget w;
String *params;
Cardinal *nparams;
XEvent *event;

{
	static	FILE	*FilePointer = 0;
	static	FILE	*PipePointer = 0;
	static	int	ProcessPid = 0;

	if (FilePointer && FilePointer != stdin){
	        fclose(FilePointer);
	}
	if (PipePointer){
		fclose(PipePointer);
		signal(SIGKILL, ProcessPid);
	}
	ProcessPid = 0;
	PipePointer = FilePointer = 0;
			
	if (!CommandMode){
		if (!FileName || !FileName[0]){
			FilePointer = stdin;
			/* Strange things will happen if we try to print */
		} else {
			FilePointer = fopen(FileName,"r");
		}
		if (!FilePointer){
			warning("Can't open %s for reading input.\n",
				FileName);
		} else {
			ActualFileName = FileName;
			InitializeFile(FilePointer, FilePointer);
		}
	} else {
		char	Buffer[BUFSIZ];
		static char FileName[BUFSIZ], *p;
		int	i, PipeFds[2];

		if (!CommandString){
			warning("Rasterize called with out a command.\nUse status panel to set command.");
			return;
		}
		p = CommandString;
		while (isspace(*p))
			p++;
		if (!*p){
			warning("Rasterize called without a command.\nUse the status panel to set a command.");
			return;
		}

		pipe(PipeFds);			/* Get two halves of pipe */
		
		ProcessPid = fork();		/* And then Fork */
		if (!ProcessPid){		/* First the Child */
			int	y;
			
			close(1);
			dup2(PipeFds[1], 1);
			for( y = 3; y < 32; y++)
				close(y);
			system(p);
			exit(0);
		}
	
		PipePointer = fdopen(PipeFds[0], "r");
		close(PipeFds[1]);
		
		if (*TempFileName) {
		    strcpy(FileName, TempFileName);
		} else {
		    strcpy(FileName,"/tmp/suntroff.XXXXXX");
		    mktemp(FileName);
		    strcpy(TempFileName, FileName);
		}
		
		FilePointer = fdopen(open(FileName,
					  O_RDWR|O_CREAT|O_TRUNC,0644), "r+");
		
		if (!FilePointer){
			fprintf(stderr,
			    "Can't open buffer file for the command:\n");
			fprintf(stderr,"\t%s\n", CommandString);
			exit(1);
		}
		ActualFileName = FileName;
		InitializeFile(PipePointer, FilePointer);
	}

	ShowPage(CurrentPage);
}

/*
 *  For those without a window manager that puts titlebars, maybe we
 *  should put a Label widget
 */
SetTitleBar(status,PageNumber)
char	*status;
int	PageNumber;
{
	extern char	*DefaultTitle;
	char	Buffer[BUFSIZ];
	char	TempStatus[BUFSIZ];
	int	FrameWidth, Width, i;
	static	char PageNumberValue[20];

	/* No way of getting this from the window manager, is there? */
	FrameWidth = 80; 

	if (PageNumber >= 0)
		sprintf(TempStatus,"%s Page %d",status,PageNumber);
	else
		sprintf(TempStatus, "%s", status);

	strncpy(Buffer,DefaultTitle,BUFSIZ);
	i = strlen(DefaultTitle);
	
	Width = strlen(TempStatus);

	while (i + Width < FrameWidth){
		Buffer[i++] = ' ';
	}
	if (FrameWidth - i > 0){
		strncpy(&Buffer[i],TempStatus,FrameWidth-i);
	}
	XStoreName(dpy, OuterFrame, Buffer);
#if 0
	if (PageNumber >= 0){
		sprintf(PageNumberValue,"%d",PageNumber);
		panel_set_value(PageItem,PageNumberValue);
	}
#endif
	if (strcmp(status, "Displaying") == 0)
		XDefineCursor(dpy, DrawingCanvas, WorkingCursor);
	else
		XDefineCursor(dpy, DrawingCanvas, WaitCursor);
	XFlush(dpy);
}

static char *SavedTitleBar = NULL;

SaveTitleBar(){
	XFetchName(dpy, OuterFrame, &SavedTitleBar);
	XFlush(dpy);
}

RestoreTitleBar(){
	if (SavedTitleBar) {
		XStoreName(dpy, OuterFrame, SavedTitleBar);
		XFlush(dpy);
	}
}

/*VARARGS1*/
fatal(String, a1, a2, a3, a4, a5, a6, a7, a8)
char	*String;
int	a1, a2, a3, a4, a5, a6, a7, a8;
{
	fprintf(stderr,"Fatal Error: ");
	fprintf(stderr,String,a1,a2,a3,a4,a5,a6,a7,a8);
	if (*TempFileName)
		unlink(TempFileName);
	exit(1);
}

/*VARARGS1*/
warning(String,a1,a2,a3,a4,a5,a6,a7,a8)
char	*String;
int	a1, a2,a3,a4,a5,a6,a7,a8;
{
	char	Message[BUFSIZ];

	sprintf(Message,String,a1,a2,a3,a4,a5,a6,a7,a8);
	message(Message);
}


/*
 *  We move the menu to the current mouse location before popping it up
 *  with MenuPopup. Pity MenuPopup doesn't do this!
 */
static void SetMenuPos (w, clientdata, calldata)
Widget w;
caddr_t clientdata;
caddr_t calldata;
{
	static Arg popup_args [] = {
		{XtNx, 0},
		{XtNy, 0},
	};
	Window root, child;
	int *rootx, rooty, winx, winy;
	unsigned int mask;
	
	XQueryPointer(XtDisplay(w), XtWindow(w), &root, &child, 
	 &rootx, &rooty, &winx, &winy, &mask);
	/*
	 *  The -OFFSET,-OFFSET displacement just makes sure mouse is in
	 *  the menu
	 */
#define OFFSET 10
	XtMoveWidget(PopupShell, rootx - OFFSET, rooty - OFFSET);
}


static void MenuSelection (widget, closure, call_data)
Widget	widget;
caddr_t	closure, call_data;
{
	char *get_input();
	char *tmpstr;
	char *statusbuf[128];
	
	XtPopdown(PopupShell);
	XFlush(dpy);
	switch (closure)
	{
		case 1:
			Rerasterize(BaseFrame, NULL, NULL, NULL);
			break;
		case 2:
			ForwardPage(BaseFrame, NULL, NULL, NULL);
			break;
		case 3:
			BackPage(BaseFrame, NULL, NULL, NULL);
			break;
		case 4:
			NextSection(BaseFrame, NULL, NULL, NULL);
			break;
		case 5:
			PrevSection(BaseFrame, NULL, NULL, NULL);
			break;
		case 6:
			if (CommandMode) {
				sprintf(statusbuf, "Command is \"%s\"", 
				 CommandString);
			} else {
				sprintf(statusbuf, "File is \"%s\"",
				 FileName);
			}
			message(statusbuf);
			break;
		case 7:
			tmpstr = get_input(": search-forward ? ",
			 SearchItem, FALSE);
			if (tmpstr) {
				if (SearchItem)
					free(SearchItem);
				SearchItem = tmpstr;
				if (SearchForward()) {
					message("Found!");
				} else {
					message("Not found!");
				}
			}
			break;
		case 8:
			tmpstr = get_input(": search-reverse ? ",
			 SearchItem, FALSE);
			if (tmpstr) {
				if (SearchItem)
					free(SearchItem);
				SearchItem = tmpstr;
				if (SearchBackward()) {
					message("Found!");
				} else {
					message("Not found!");
				}
			}
			break;
		case 9:
			/* Change File */
			tmpstr = get_input(": file-name ? ", FileName, TRUE);
			if (tmpstr) {
				CommandMode = 0;
				strcpy(FileName, tmpstr);
				free(tmpstr);
				Rerasterize(BaseFrame, NULL, NULL, NULL);
			}
			break;
		case 10:
			/* Change Command */
			tmpstr = get_input(": formatting-command ? ",
			 CommandString, FALSE);
			if (tmpstr) {
				CommandMode = 1;
				strcpy(CommandString, tmpstr);
				free(tmpstr);
				Rerasterize(BaseFrame, NULL, NULL, NULL);
			}
			break;
		case 11:
			/* Go to page */
			tmpstr = get_input(": go-to-page ? ", NULL, FALSE);
			if (tmpstr) {
				PageRequest = atoi(tmpstr);
				GoToPage(BaseFrame, NULL, NULL, NULL);
			}
			break;
		case 99:
			Quit(BaseFrame, NULL, NULL, NULL);
			break;
	}
}


static char *input;
static int  inputdone;

/*
 *  This routine focuses all input on the InputWindow, and starts up a
 *  loop which forms a secondary dispatcher, ignoring all events except
 *  ExposeWindow events on windows other than the InputWindow. This
 *  effectively forces the user to use the InputWindow. The loop
 *  terminates when input is completed, either by inputting a string, in
 *  which case finished_input will be invoked, or by aborting.  Both set
 *  the completion flag and the loop quits, focussing input back to the
 *  previous holder. No harm is done to this application if focus is not
 *  given to the minibuffer, or removed from it - it's just more
 *  convenient for the user who doesn't have to move a mouse around too
 *  much.  The routine returns the input string, or a NULL if the input
 *  was aborted.
 */
char *get_input(prompt, default_string, complete)
char *prompt, *default_string;
{
	XEvent ev;
	Window focus_return;
	int revert_to_return;
	
	MinibufGetInput(InputWidget, prompt, default_string, complete);
#ifndef GRAB
	/*
	 *  Should be able to use keyboard grabs here, but does InputWidget
	 *  need to be a spring-loaded shell or such-like?
	 */
	XGetInputFocus(dpy, &focus_return, &revert_to_return);
	XSetInputFocus(dpy, InputWin, RevertToPointerRoot);
	XFlush(dpy);
#endif
	inputdone = FALSE;
	while (!inputdone) {
		XtNextEvent(&ev);
#ifndef GRAB
		/* Ignore all events except exposes unless meant for InputWidget */
		if (ev.xany.window == InputWin || ev.xany.type == Expose ||
		 ev.xany.type == ConfigureNotify)
#endif
			(void) XtDispatchEvent(&ev);
	}
#ifndef GRAB
	XSetInputFocus(dpy, focus_return, revert_to_return);
#endif
	return(input);
}


/*
 *  Callback, invoked when user hits RETURN in the InputWidget (or whatever
 *  the user has bound 'newline' to) in which case inp_string points to
 *  an alloc'ed string. If the user aborts input (^G, ^C) then
 *  inp_string is NULL
 */
/*ARGSUSED*/
static void finished_input(w, tag, inp_string)
Window w;
caddr_t tag;
char *inp_string;
{
	input = inp_string;
	inputdone = TRUE;
}


/* 
 *  Asks to confirm something - If they reply "y", returns YES, if they
 *  reply "n", returns NO, if they abort, returns ABORT. You are given
 *  IMPATIENCE tries to answer
 */
confirm(query, default_answer)
char *default_answer;
char *query;
{
	char *answer;
	char c;
	char *mesg = "Answer yes or no, please (y/n)";
	int count = 0;
#define IMPATIENCE	5

	do {
		if ((answer = get_input(query, default_answer, FALSE)) == NULL)
			return (ABORT);
		c = (isupper(answer[0])) ? tolower(answer[0]) : answer[0];
		if (c == 'y')
			return(YES);
		else if (c == 'n')
			return(NO);
		message(mesg);
		/* Let's get really explicit next time */
		mesg = "Type 'y' and RETURN if you want to answer YES, 'n' for NO, CTRL-G to abort";
	} while (count++ < IMPATIENCE);
	message("Forget it - Aborting");
	return(ABORT);
}


/*
 *  Message is printed on the communication line if the windows are
 *  mapped, otherwise fprintf'ed to stderr
 */
message(s)
char *s;
{
	if (InputWidget != 0)
		MinibufDisplayMessage(InputWidget, s, TRUE);
	else
		fprintf(stderr, "%s\n", s);
}


SetPrinter(s)
char *s;
{
}

#ifdef	STANDALONE
ShowPage(){
	printf("Show Page called.\n");
}

char	*DefaultTitle = "Standalone Window Code";

SearchFile(){
	printf("Search file called.\n");
}

#endif STANDALONE
#endif SUNTOOLS
/* Don't put anything after this line */
