/* 
 * PColor.c - Important stuff.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#define EXTERN
#include "pexDICE.h"

#include "Xutil.h"/*need XVisualInfo*/


/*cpj's own synchronizer*/
int _CPJSync(dpy)
    register Display *dpy;
{
    XFlush(dpy);
    XSync(dpy,0);
}    
    int lynxcolor; /*global*/
    int colorclass; /*golbal*/
/*If TrueColor we should send rgb color rather than indexes*/
static myXAllocNamedColor(dpy, colormap, colorname,
			  color, exactcolor)
    int dpy;
    int colormap;
    char *colorname;
    XColor *color,*exactcolor;
    
{
    int error;
    if (lynxcolor==0)
	return(XAllocNamedColor(dpy,
				colormap,
				colorname,
				color,
				exactcolor));
    error=XParseColor(dpy,
		      colormap,
		      colorname,
		      exactcolor);
    if (error==0){
	fprintf(stderr,"XparseColor -- Unknown color %s\n",colorname);
	return(error);
    }
    exactcolor->pixel= (((exactcolor->blue+255)/256)
			+256*(((exactcolor->green+255)/256)+256*
			      ((exactcolor->red+255)/256)));
    *color= *exactcolor;
    return(error);
}


/*
 * Globals for surface flags.  Defaults to servers default mode.
 *
 *
 *  smoothflag	sets SurfaceInterpMethod to SurfaceInterpColor
 *  wireflag	sets SurfaceInteriorStyle to Hollow
 *  zbufferflag sets HlhsrMode to HlhsrZBuffer
 *  cullflag	sets FacetCullingMode to BackFaces
 *  paintflag	sets HlhsrMode to HlhsrPainters
 */


void
SetPexSurfaceFlags(pexi)
    pexC * pexi;
{
    if (wireflag)
	PexInteriorStyle(pexi, InteriorStyleHollow);

    if (solidflag)
	PexInteriorStyle(pexi, InteriorStyleSolid);

    if (cullflag)
	PexCullMode(pexi, BackFaces);
    else
	PexCullMode(pexi, None);

    if (zbufferflag)
	PexHlhsrMode(pexi,HlhsrZBuffer);

    if (paintflag)
	PexHlhsrMode(pexi,HlhsrPainters);

    if (smoothflag)
	PexSurfaceInterp(pexi,SurfaceInterpColor);
};

/*
 ******************************************************************************
 *
 *	Function:	popenphigs(dpy, window, argc, argv)
 *
 *	On Entry:	
 *
 *	On Exit:	
 *
 *	Notes:
 *		ARGUMENTS NOT PHIGS COMPATIBLE!!!
 *		
 *
 ******************************************************************************
 */

pexC *
popenphigs(dpy, window, argc, argv)
    Display *dpy;
    Window window;
    int argc;
    char *argv[];
{ 
    pexC *popenphigsextra();

    register pexC *pexi;

    /* This is just a stubx to allow things that were working before to 
       keep working the same. */
    pexi = popenphigsextra(dpy, window, 0, 0, 0, 0, argc, argv);

    return (pexi);
}

/*
 ******************************************************************************
 *
 *	Function:   popenphigsextra(dpy, window, winx, winy, winw, winh, argc, argv)
 *
 *	On Entry:	
 *
 *	On Exit:	
 *
 *	Notes:
 *		ARGUMENTS NOT PHIGS COMPATIBLE!!!
 *		
 *
 ******************************************************************************
 */
pexC *
popenphigsextra(dpy, window, winx, winy, winw, winh, argc, argv)
    Display *dpy;
    Window window;
    int winx, winy, winw, winh;
    int argc;
    char *argv[];
{
    register pexC *pexi;
    int event, error;
    int i;
    Visual visual;
    XVisualInfo visual_info;
    char *display;
    Colormap cm;
    XSetWindowAttributes xswa;
    int backstore = NotUseful;
    char *geom=NULL, *pexfgnm="", *pexbgnm="";
    XColor fg, bg, huecares;
    int Debugger;
    Window XCreateWindow();
    int screen;
    int depth;
    int attributes;
    int coloralloc;

    pexi = (pexC *) malloc(sizeof (pexC));

    /* Save phigs system state */
    pexi->sysstate = PPHOP;
    
    /* Set default X window size if they haven't given us any values. */
    if ( (winx == 0) && (winy == 0) )
    {
	pexi->winx = 0;
	pexi->winy = 0;
    }
    else 
    {
	pexi->winx = winx;
	pexi->winy = winy;
    }

    if ( (winw == 0) && (winh == 0) )
    {
	pexi->winw = 200;
	pexi->winh = 200;
    }
    else
    {
	pexi->winw = winw;
	pexi->winh = winh;
    }

    pexi->buf_len=512*256;/* 128K bytes*/	
    pexi->buf_begin=malloc(pexi->buf_len);
    pexi->buf_current=pexi->buf_begin;
    pexi->buf_maximum=pexi->buf_begin + pexi->buf_len;

    display = (char *) getenv("DISPLAY");
    Debugger = False;
    visual.visualid = CopyFromParent;
    attributes=CWEventMask | CWBackingStore | CWBorderPixel | CWBackPixel;
    colorclass= -1;
    depth= -1;	
    lynxcolor=0;
    coloralloc=AllocNone;
    
    
    for (i=1; i < argc; i++)
    {
        if (argv [i] [0] == '=') 
	    geom = argv[i];
	else if ( index(argv[i], ':') != NULL )
	    display = argv[i];
	else if (strcmp(argv[i], "-pexfg") == 0)
	    pexfgnm = argv[++i];
	else if (strcmp(argv[i], "-pexbg") == 0)
	    pexbgnm = argv[++i];

	/*
	 * For tests connenting to servers of different types.
	 * Not normally used.  
	 */
	else if (strcmp(argv[i], "-truecolor") == 0)
	{
	    colorclass=TrueColor;
	    depth= 24;
	}
	else if (strcmp(argv[i], "-directcolor") == 0)
	{
	    colorclass=DirectColor;
	    depth= 24;
	}
	else if (strcmp(argv[i], "-staticcolor") == 0)
	{
	    colorclass=StaticColor;
	    depth= 8;
	}
	else if (strcmp(argv[i], "-pexdepth") == 0)
	    sscanf(argv[++i],"%d",&depth);
	else if (strcmp(argv[i], "-AllocAll") == 0)
	    coloralloc=AllocAll;
	else if (strcmp(argv[i], "-AllocNone") == 0)
	    coloralloc=AllocNone;
	else if (strcmp(argv[i], "-pexcolorclass") == 0)
	    sscanf(argv[++i],"%d",&colorclass);

        else if (strcmp(argv[i], "-backingstore") == 0)
            backstore = Always;
        else if (strcmp(argv[i], "-debug") == 0)
            Debugger = True;


	/*
	 * flags for different surface attributes.
	 * actually used.
	 */
	 
	else if (strcmp(argv[i], "-wire") == 0)
	    wireflag++, solidflag = 0;

	else if (strcmp(argv[i], "-solid") == 0)
	    solidflag++, wireflag = 0;

	else if (strcmp(argv[i], "-cull") == 0)
	    cullflag++;

	else if (strcmp(argv[i], "-smooth") == 0)
	    smoothflag++;

	else if (strcmp(argv[i], "-zbuffer") == 0)
	    zbufferflag++, paintflag = 0;

	else if (strcmp(argv[i], "-paint") == 0)
	    paintflag++, zbufferflag = 0;

	else if (strcmp(argv[i], "-nowire") == 0)
	    wireflag = 0, solidflag++;

	else if (strcmp(argv[i], "-nosolid") == 0)
	    solidflag = 0, wireflag++;

	else if (strcmp(argv[i], "-nocull") == 0)
	    cullflag = 0;

	else if (strcmp(argv[i], "-nosmooth") == 0)
	    smoothflag = 0;

	else if (strcmp(argv[i], "-nozbuffer") == 0)
	    zbufferflag = 0;

	else if (strcmp(argv[i], "-nopaint") == 0)
	    paintflag = 0;

	
	else fprintf(stderr,"Unknown %d'th parameter %s\n", i,argv[i]);
    }
	
    if ( dpy == 0 )
    {
	/* They want us to open things up. */
	if ( !(dpy = XOpenDisplay(display)) )
	{
	    perror("Cannot open display\n");
	    exit(-1);
	}
    }

    if (Debugger){
	fprintf(stderr,"Gonna rock\n");
        /*XSynchronize(dpy,1); /*doesnt work*/
	dpy->synchandler=_CPJSync; /*Hungarian sucks*/
    }
    pexi->phigsDisplay = dpy;
    screen = DefaultScreen(dpy);
    error = XMatchVisualInfo(dpy, screen, 24, TrueColor, &visual_info);
	if (error!=0){
		if( lynxcolor==0) lynxcolor=1;
		if (colorclass == -1) 	    colorclass=TrueColor;
	        if (depth == -1)depth= 24;
		    if (pexbgnm[0]==0)pexbgnm="black";
		    if (pexfgnm[0]==0)pexfgnm="cyan";
	}
	else{
		    if (pexbgnm[0]==0)pexbgnm="black";
		    if (pexfgnm[0]==0)pexfgnm="white";
		    if (depth == -1) depth = DefaultDepth(dpy, DefaultScreen(dpy));
	}
    
    /* GET A VISUAL FOR A 24 PLANE GAMMA CORRECTED PIXEL */
    
    if(colorclass>=0)
    {
	error = XMatchVisualInfo(dpy, screen, depth, colorclass, &visual_info);
	
	if(error == 0)
	{
	    fprintf(stderr, "XMatchVisualInfo blew up.\n");
	    xswa.colormap = DefaultColormap(dpy,screen);
	}
	else
	{
	    cm = XCreateColormap(dpy,RootWindow(dpy,screen),visual_info.visual,
				 coloralloc);
	    attributes |= CWColormap;
	    visual= *visual_info.visual;
	    xswa.colormap = cm;
	}
    } 
    else
    {
        xswa.colormap = DefaultColormap(dpy,screen);
    }
    if (geom) 
    {
        if (!XParseGeometry(geom, 
			    &(pexi->winx), 
			    &(pexi->winy), 
			    &(pexi->winw), 
			    &(pexi->winh)))
        {
            fprintf(stderr, "Geometry specified incorrectly.  Using default\n");
        }
    }
    if ( myXAllocNamedColor(dpy, xswa.colormap, pexfgnm,
			    &fg, &huecares) == 0 )
    {
	fg.pixel = BlackPixel( dpy, screen );
    }

    pexi->lineColorIndex = fg.pixel;
    if ( myXAllocNamedColor(dpy, xswa.colormap, pexbgnm,
			    &bg, &huecares) == 0 )
    {
	bg.pixel = WhitePixel( dpy, screen );
    }
    
    
    if ( window == 0 )
    {
	/* They want us to do the window. */
	xswa.backing_store = backstore;
	xswa.event_mask = ExposureMask | StructureNotifyMask;
	xswa.background_pixel = bg.pixel;
	xswa.border_pixel = fg.pixel;

	xswa.bit_gravity=NorthWestGravity;
	attributes |= CWBitGravity;

	pexi->phigsWindow =
	    XCreateWindow(dpy, RootWindow(dpy, DefaultScreen(dpy)), pexi->winx, 
			  pexi->winy, pexi->winw, pexi->winh, 1, depth,
			  InputOutput, &visual, attributes, &xswa);
    
	XChangeProperty(dpy, pexi->phigsWindow, XA_WM_NAME, XA_STRING, 8,
			PropModeReplace, "PEX", 3);
	XMapWindow(dpy, pexi->phigsWindow);
    }
    else
    {
	/* They have already done the window stuff. */
	pexi->phigsWindow = window;
    }
    
    /* get the PEXReqCode, the major opcode for X packets */
    XQueryExtension(dpy, PEXNAME, &(pexi->PEXReqCode), &event, &error );
    if (!pexi->PEXReqCode)
    {
	fprintf(stderr, "PEX is not present in the server %s\n");
	exit(1);
    }
    
    /* not building any output command buffers now */
    pexi->curRenderOut = 0;

    return (pexi);
}

/*
 ******************************************************************************
 *
 *	Function:	pclosephigs()
 *
 *	On Entry:	
 *
 *	On Exit:	
 *
 *	Notes:
 *		
 *
 ******************************************************************************
 */
int
pclosephigs(pexi)
    register pexC *pexi;
{
    	/* Save new system state */
	pexi->sysstate = PPHCL;

	/* ### Should this do an XFree(pexi) ? */
}


/*
 ******************************************************************************
 *
 *	Function:	popenws(ws_id, conn_id, ws_type)
 *
 *	On Entry:	
 *
 *	On Exit:	
 *
 *	Notes:
 *		
 *
 ******************************************************************************
 */
int
popenws(pexi, ws_id, conn_id, ws_type)
    register pexC *pexi;
    Pint ws_id;		/* workstation identifier	*/
    Pconnid	conn_id;	/* connection identifier	*/
    Pwstype	ws_type;	/* workstation type	*/
{
	pexCreateRendererReq *req;
	Display *dpy = pexi->phigsDisplay;

	LockDisplay(dpy);

	GetPexFltReq(CreateRenderer, req);

	req->rdr = pexi->renderer = XAllocID (dpy);
	req->drawable = pexi->phigsWindow;
	req->itemMask = 0;
	req->numItems = 0;

	UnlockDisplay(dpy);
	SyncHandle();

}

/*
 ******************************************************************************
 *
 *	Function:	pclosews(ws_id)
 *
 *	On Entry:	
 *
 *	On Exit:	
 *
 *	Notes:
 *		
 *
 ******************************************************************************
 */
int
pclosews(pexi, ws_id)
    register pexC *pexi;
    Pint ws_id;		/* workstation identifier	*/
{
    register pexResourceReq *req;
    register Display *dpy;

    dpy = pexi->phigsDisplay;

    LockDisplay( dpy );

    GetPexResReq(FreeRenderer, pexi->renderer, req);

    UnlockDisplay( dpy );
    SyncHandle();
}

/*
 ******************************************************************************
 *
 *	Function:	punpostallstruct(ws_id)
 *
 *	On Entry:	
 *
 *	On Exit:	
 *
 *	Notes: Unposts all structures from workstation, clears display.
 *		
 *
 ******************************************************************************
 */
int
punpostallstruct(pexi, ws_id)
    register pexC *pexi;
    Pint ws_id;		/* workstation identifier	*/
{
    XClearArea(pexi->phigsDisplay, pexi->phigsWindow, 
	       0, 0, 0, 0, 0);
}
