/* 
 * fillarea.h - Header file for fill areas.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR\ ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef PEX_FILL_AREA_H
#define PEX_FILL_AREA_H

#include "pexarray.h"		/* define data accessor macros */

/*
 * Fill Area 2D not implemented.
 */

/*
 * Fill Area 3D not implemented.
 */

/*
 * Fill Area 3D with data
 */
typedef struct _pexFillArea3DwithData
{
    pexElementInfo	head;
    pexSwitch           shapeHint;
    CARD16              ignoreEdges;
    pexBitmaskShort     facetAttributes;
    pexBitmaskShort     vertexAttributes;
    pexColorType        colorType;

    CARD32              vertexNormStride;
    CARD32              vertexNormOffset;
    CARD32              vertexColorStride;
    CARD32              vertexColorOffset;

    CARD32              numVertices;
    CARD32              vertexStride;
    CARD32              vertexOffset;
    pexVector3D		facetNormal;
    pexColorSpecifier   facetColor; /* punting this issue totally */
    /* Variable Sized Portion is appended here */
} *pexFillAreaWithDataPtr, pexFillAreaWithDataRec;


/*****************************************************************
 * TAG( PEX3DfillAreaVertexColor PEX3DfillAreaFacetNorm )
 * TAG( PEX3DfillAreaVertexNorm PEX3DfillAreaVertex PEX3DfillAreaFacetColor )
 * 
 * Data access macros for the Fill Area 3D.
 * This macro is used VERY frequently, so it is not expected to
 * check for input error.
 * 
 * Inputs:
 * 	pFA - pointer to a pexFillAreaWithDataRec
 *      n - Index into the array
 * 	     
 * Outputs:
 * 	pointer to the data field desired.
 * 	
 * Assumptions:
 * 	Assumptions are that N is bounded correctly,
 * 	and that the data field is present in the object
 * 	(the bitmasks determine this).
 * 	
 * Algorithm:
 * 	simple pointer arithmetic.
 */

#define PexFillAreaVertex(o, n)\
    (pexCoord3D *)	 Pex1DData(o, n, vertex)
#define PexFillAreaVertexNorm(o, n)\
    (pexVector3D *)	 Pex1DData(o, n, vertexNorm)
#define PexFillAreaFacetNorm(o)\
    (pexVector3D *)	 &o->facetNormal

/*#define PEX3DFillAreaVertexColor(o, n)\
    (pexRgbFloatColor *) Pex1DData(o, vertexColor)*//* wrong cast */
/*#define PEX3DFillAreaFacetColor(o)\
    (pexColorSpecifier *) &o->facetColor*//* wrong cast */


#if defined(__STDC__)

extern pexFillAreaWithDataPtr UnpackPexFillAreaWithData(pexFillAreaWithData *);
extern pexFillAreaWithDataPtr sUnpackPexFillAreaWithData(pexFillAreaWithData *);
extern pexFillAreaWithDataPtr fUnpackPexFillAreaWithData(pexFillAreaWithData *);
extern pexFillAreaWithDataPtr sfUnpackPexFillAreaWithData(pexFillAreaWithData *);

extern pexFillAreaWithDataPtr	NewPexFillAreaWithData(CARD32, CARD16, CARD16);
/*extern pexFillAreaWithDataPtr	PEXcopyFillArea3DWD(pexFillAreaWithDataPtr);*/
extern void			FreePexFillAreaWithData(pexFillAreaWithDataPtr);
/*extern bool			PEXerrorCheckFillArea3DWD(pexFillAreaWithDataPtr);*/
#else
extern pexFillAreaWithDataPtr UnpackPexFillAreaWithData(); 
extern pexFillAreaWithDataPtr sUnpackPexFillAreaWithData();   /* s means swap */
extern pexFillAreaWithDataPtr fUnpackPexFillAreaWithData();    /* f means float */
extern pexFillAreaWithDataPtr sfUnpackPexFillAreaWithData();   /* convert       */

extern pexFillAreaWithDataPtr	NewPexFillAreaWithData();
/*extern pexFillAreaWithDataPtr	PEXcopyFillArea3DWD();*/
extern void			FreePexFillAreaWithData();
/* extern Bool			PEXerrorCheckFillArea3DWD();  */

#endif /* if defined... */

#endif PEX_FILL_AREA_H
