/* 
 * quadmesh.h - Header file for quadrilateral meshes.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#ifndef PEX_QUAD_MESH_H
#define PEX_QUAD_MESH_H

#include "pexmisc.h"
#include "pexarray.h"

typedef struct _pexQuadMesh
{
    pexElementInfo	head;
    pexBitmaskShort     vertexAttributes;
    pexBitmaskShort     facetAttributes;
    pexColorType        colorType;
    pexCoordType	pointType;
    CARD32              mPoints;
    CARD32              nPoints;
    CARD32              vertexMStride;
    CARD32              vertexNStride;
    CARD32              vertexOffset;

    CARD32              facetNormMStride;
    CARD32              facetNormNStride;
    CARD32              facetNormOffset;
    CARD32              facetColorMStride;
    CARD32              facetColorNStride;
    CARD32              facetColorOffset;

    CARD32              vertexNormMStride;
    CARD32              vertexNormNStride;
    CARD32              vertexNormOffset;
    CARD32              vertexColorMStride;
    CARD32              vertexColorNStride;
    CARD32              vertexColorOffset;
    /* Variable Sized Portion is appended here */
} *pexQuadMeshPtr, pexQuadMeshRec;

/*****************************************************************
 * TAG( PexQuadMeshVertex PexQuadMeshVertexNorm PexQuadMeshVertexColor )
 * TAG( PexQuadMeshFacetNorm PexQuadMeshFacetColor )
 * 
 * Data access macros for the Quadrilateral Mesh.
 * These macro is used VERY frequently, so it is not expected to
 * check for input error.
 * 
 * Inputs:
 * 	pQM - pointer to a QuadMeshRec
 * 	m & n - Indices into the 2d array
 * Outputs:
 * 	pointer to the data field desired.
 * 	
 * Assumptions:
 * 	Assumptions are that M & N are bounded correctly,
 * 	and that the data field is present in the object
 * 	(the bitmasks determine this.)
 * 	
 * Algorithm:
 * 	simple pointer arithmetic.
 */

#define PexQuadMeshVertex(o, m, n)\
    (pexCoord3D *)	Pex2DData(o, m, n, vertex)
#define PexQuadMeshVertexNorm(o, m, n)\
    (pexVector3D *)	Pex2DData(o, m, n, vertexNorm)
#define PexQuadMeshVertexColor(o, m, n)\
    (pexRgbFloatColor *)Pex2DData(o, m, n, vertexColor)
#define PexQuadMeshFacetNorm(o, m, n)\
    (pexVector3D *) 	Pex2DData(o, m, n, facetNorm)
#define PexQuadMeshFacetColor(o, m, n)\
    (pexRgbFloatColor *)Pex2DData(o, m, n, facetColor)

#if defined(__STDC__)
extern pexQuadMeshPtr	UnpackPexQuadMesh(pexQuadrilateralMesh *);
extern pexQuadMeshPtr	sUnpackPexQuadMesh(pexQuadrilateralMesh *); 
extern pexQuadMeshPtr	fUnpackPexQuadMesh(pexQuadrilateralMesh *); 
extern pexQuadMeshPtr	sfUnpackPexQuadMesh(pexQuadrilateralMesh *);

extern pexQuadMeshPtr	NewPexQuadMesh(CARD32 nPoints, CARD32 mPoints,
				       pexBitmaskShort vertexAttributes,
				       pexBitmaskShort facetAttributes);
extern pexQuadMeshPtr	CopyPexQuadMesh(pexQuadMeshPtr);
extern void		FreePexQuadMesh(pexQuadMeshPtr);
extern Bool		ErrorCheckPexQuadMesh(pexQuadMeshPtr);
#else
extern pexQuadMeshPtr	UnpackPexQuadMesh();
extern pexQuadMeshPtr	sUnpackPexQuadMesh();  /* s means swap */
extern pexQuadMeshPtr	fUnpackPexQuadMesh();  /* f means float convert */
extern pexQuadMeshPtr	sfUnpackPexQuadMesh();

extern pexQuadMeshPtr	NewPexQuadMesh();
extern pexQuadMeshPtr	CopyPexQuadMesh();
extern void		FreePexQuadMesh();
extern Bool		ErrorCheckPexQuadMesh();
#endif /* if defined... */

#endif PEX_QUAD_MESH_H
