/* 
 * render.c - Routines for device independent Begin & EndRendering stuff.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X.h"
#include "windowstr.h"
#include "pixmapstr.h"

#include "pubstr.h"
#include "renderer.h"
#include "colortable.h"
#include "pexextensn.h"

int 
DDPEXBeginRendering(pRend)
pexRendererPtr pRend;
{

    if (pRend->deviceDep != NULL)
    {
	fprintf(stderr, "Renderer has non-NULL device ptr in DDPEXBeginRendering\n");
	pRend->deviceDep = NULL;
    };

    if (PexInitGraphicsHowever)
    {
	PexInitColormap();
	PexInitGraphicsHowever = 0;
    };

    if ( pRend->pDraw->type == DRAWABLE_WINDOW )
	(*((WindowPtr)pRend->pDraw)->ClearToBackground)
	    (pRend->pDraw, 0, 0, 0, 0, 0);
    return Success;
};


int 
DDPEXEndRendering(pRend)
pexRendererPtr pRend;
{
    miPexFlushQMList(pRend);

    return Success;
};

int 
DDPEXFreeRenderer(pRend)
pexRendererPtr pRend;
{
    miPexKillQMList(pRend);
    return Success;
};
