/* 
 * miscReq.c - miscellaneous requests
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*****************************************************************
 * TAG( BadPEXImplementation )
 * 
 * To handle requests not yet implemented.
 * 
 * Inputs:
 * 	a pex request which hasn't been implemented yet.
 * Outputs:
 * 	always returns BadImplementation (from X.h).
 * Assumptions:
 * 	stuff is of type pexReq or compatible.
 * Algorithm:
 * 	print message and get out.
 */

#include "X.h"
#include "PEXproto.h"
#include <stdio.h>

int
BadPEXImplementation(stuff)
    pexElementInfo *stuff;
{
/*    fprintf (stderr,"BadPEXImplementation: OC %d\n", stuff->elementType);
    fprintf (stderr,"                      length %d\n", stuff->length);
*/
    return (BadImplementation);
}

int
BadPEXImplementationReq(stuff)
    pexReq *stuff;
{
/*   fprintf (stderr,"BadPEXImplementationReq: Major OP %d\n", stuff->reqType);
    fprintf (stderr,"                         Minor OP %d\n", stuff->opcode);
*/
    return (BadImplementation);
}
