/* 
 * tables.c - Definition of the dispatchers procedure vectors.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include"Xmd.h"
#include"PEX.h"
#include"pexmisc.h"

#define WhoCares FALSE     /* who cares for the demo version */

void NotNeeded(){};
extern int BadPEXImplementation();
extern int BadPEXImplementationReq();

Bool PEXDoesReqHaveFloats[MaxPEXCommand] = {
    FALSE,			/* 0 Not Defined		*/
    WhoCares,			/* 1 PEX_GetExtensionInfo	*/
    WhoCares,			/* 2 PEX_GetEnumeratedTypeInfo	*/
    WhoCares,			/* 3 PEX_CreateLookupTable	*/
    WhoCares,			/* 4 PEX_CopyLookupTable	*/
    WhoCares,			/* 5 PEX_FreeLookupTable	*/
    WhoCares,			/* 6 PEX_GetTableInfo		*/
    WhoCares,			/* 7 PEX_GetPredefinedEntries	*/
    WhoCares,			/* 8 PEX_GetDefinedIndices	*/
    WhoCares,			/* 9 PEX_GetTableEntry		*/
    WhoCares,			/* 10 PEX_GetTableEntries	*/
    WhoCares,			/* 11 PEX_SetTableEntries	*/
    WhoCares,			/* 12 PEX_DeleteTableEntries	*/
    WhoCares,			/* 13 PEX_CreatePipelineContext	*/
    WhoCares,			/* 14 PEX_CopyPipelineContext	*/
    WhoCares,			/* 15 PEX_FreePipelineContext	*/
    WhoCares,			/* 16 PEX_GetPipelineContext	*/
    WhoCares,			/* 17 PEX_ChangePipelineContext	*/
    TRUE,			/* 18 PEX_CreateRenderer	*/
    FALSE,			/* 19 PEX_FreeRenderer		*/
    TRUE,			/* 20 PEX_ChangeRenderer	*/
    FALSE,			/* 21 PEX_GetRendererAttributes	*/
    FALSE,			/* 22 PEX_BeginRendering	*/
    FALSE,			/* 23 PEX_EndRendering		*/
    FALSE,			/* 24 PEX_BeginStructure	*/
    FALSE,			/* 25 PEX_EndStructure		*/
    TRUE,  			/* 26 PEX_RenderOutputCommands	*/
    WhoCares,			/* 27 PEX_RenderNetwork		*/
    WhoCares,			/* 28 PEX_CreateStructure	*/
    WhoCares,			/* 29 PEX_CopyStructure		*/
    WhoCares,			/* 30 PEX_FreeStructure		*/
    WhoCares,			/* 31 PEX_DeleteStructures	*/
    WhoCares,			/* 32 PEX_GetStructureInfo	*/
    WhoCares,			/* 33 PEX_GetElementInfo	*/
    WhoCares,			/* 34 PEX_GetStructuresInNetwork*/
    WhoCares,			/* 35 PEX_GetAncestors		*/
    WhoCares,			/* 36 PEX_GetDescendants	*/
    WhoCares,			/* 37 PEX_FetchElements		*/
    WhoCares,			/* 38 PEX_SetEditingMode	*/
    WhoCares,			/* 39 PEX_SetElementPointer	*/
    WhoCares,			/* 40 PEX_SetElementPointerAtLabel*/
    WhoCares,			/* 41 PEX_ElementSearch		*/
    WhoCares,			/* 42 PEX_StoreElements		*/
    WhoCares,			/* 43 PEX_DeleteElements	*/
    WhoCares,			/* 44 PEX_DeleteElementsToLabel	*/
    WhoCares,			/* 45 PEX_DeleteBetweenLabels	*/
    WhoCares,			/* 46 PEX_CopyElements		*/
    WhoCares,			/* 47 PEX_ChangeStructureRefs	*/
    WhoCares,			/* 48 PEX_CreateNameSet		*/
    WhoCares,			/* 49 PEX_CopyNameSet		*/
    WhoCares,			/* 50 PEX_FreeNameSet		*/
    WhoCares,			/* 51 PEX_GetNameSet		*/
    WhoCares,			/* 52 PEX_ChangeNameSet		*/
    WhoCares,			/* 53 PEX_CreateSearchContext	*/
    WhoCares,			/* 54 PEX_CopySearchContext	*/
    WhoCares,			/* 55 PEX_FreeSearchContext	*/
    WhoCares,			/* 56 PEX_GetSearchContext	*/
    WhoCares,			/* 57 PEX_ChangeSearchContext	*/
    WhoCares,			/* 58 PEX_SearchNetwork		*/
    WhoCares,			/* 59 PEX_CreatepexPhigsWks	*/
    WhoCares,			/* 60 PEX_FreepexPhigsWks	*/
    WhoCares,			/* 61 PEX_GetWksInfo		*/
    WhoCares,			/* 62 PEX_GetDynamics		*/
    WhoCares,			/* 63 PEX_GetViewRep		*/
    WhoCares,			/* 64 PEX_RedrawAllStructures	*/
    WhoCares,			/* 65 PEX_UpdateWorkstation	*/
    WhoCares,			/* 66 PEX_ExecuteDeferredActions*/
    WhoCares,			/* 67 PEX_SetViewPriority	*/
    WhoCares,			/* 68 PEX_SetDisplayUpdateMode	*/
    WhoCares,			/* 69 PEX_MapPoints		*/
    TRUE,			/* 70 PEX_SetViewRep		*/
    WhoCares,			/* 71 PEX_SetWksWindow		*/
    WhoCares,			/* 72 PEX_SetWksViewport	*/
    WhoCares,			/* 73 PEX_SetHLHSRMode		*/
    WhoCares,			/* 74 PEX_PostStructure		*/
    WhoCares,			/* 75 PEX_UnpostStructure	*/
    WhoCares,			/* 76 PEXUnpostAllStructures	*/ 
    WhoCares,			/* 77 PEX_GetWksPostings	*/
    WhoCares,			/* 78 PEX_GetPickDevice		*/
    WhoCares,			/* 79 PEX_ChangePickDevice	*/
    WhoCares,			/* 80 PEX_CreatePickMeasure	*/
    WhoCares,			/* 81 PEX_FreePickMeasure	*/
    WhoCares,			/* 82 PEX_GetPickMeasure	*/
    WhoCares,			/* 83 PEX_UpdatePickMeasure	*/
    WhoCares,			/* 84 PEX_OpenFont		*/
    WhoCares,			/* 85 PEX_CloseFont		*/
    WhoCares,			/* 86 PEX_QueryFont		*/
    WhoCares,			/* 87 PEX_ListFonts		*/
    WhoCares,			/* 88 PEX_ListFontsWithInfo	*/
    WhoCares,			/* 89 PEX_QueryTextExtents	*/
};

/* don't worry, I used search-replace on the above comments */

char *PEXRequestNames[MaxPEXCommand] = {
     "Zero Not Defined",
     "Get Extension Info",
     "Get Enumerated Type Info",
     "Create Lookup Table",
     "Copy Lookup Table",
     "Free Lookup Table",
     "Get Table Info",
     "Get Predefined Entries",
     "Get Defined Indices",
     "Get Table Entry",
     "Get Table Entries",
     "Set Table Entries",
     "Delete Table Entries",
     "Create Pipeline Context",
     "Copy Pipeline Context",
     "Free Pipeline Context",
     "Get Pipeline Context",
     "Change Pipeline Context",
     "Create renderer",
     "Free renderer",
     "Change renderer",
     "Get renderer Attributes",
     "Begin Rendering",
     "End Rendering",
     "Begin Structure",
     "End Structure",
     "Render Output Commands",
     "Render Network",
     "Create Structure",
     "Copy Structure",
     "Free Structure",
     "Delete Structures",
     "Get Structure Info",
     "Get Element Info",
     "Get Structures In Network",
     "Get Ancestors",
     "Get Descendants",
     "Fetch Elements",
     "Set Editing Mode",
     "Set Element Pointer",
     "Set Element Pointer At Label",
     "Element Search",
     "Store Elements",
     "Delete Elements",
     "Delete Elements To Label",
     "Delete Between Labels",
     "Copy Elements",
     "Change Structure Refs",
     "Create Name Set",
     "Copy Name Set",
     "Free Name Set",
     "Get Name Set",
     "Change Name Set",
     "Create Search Context",
     "Copy Search Context",
     "Free Search Context",
     "Get Search Context",
     "Change Search Context",
     "Search Network",
     "Create Pex Phigs Wks",
     "Free Pex Phigs Wks",
     "Get Wks Info",
     "Get Dynamics",
     "Get View Rep",
     "Redraw All Structures",
     "Update Workstation",
     "Execute Deferred Actions",
     "Set View Priority",
     "Set Display Update Mode",
     "Map Points",
     "Set View Rep",
     "Set Wks Window",
     "Set Wks Viewport",
     "Set HLHSR Mode",
     "Post Structure",
     "Unpost Structure",
     "Unpost All Structures",
     "Get Wks Postings",
     "Get Pick Device",
     "Change Pick Device",
     "Create Pick Measure",
     "Free Pick Measure",
     "Get Pick Measure",
     "Update Pick Measure",
     "Open Font",
     "Close Font",
     "Query Font",
     "List Fonts",
     "List Fonts With Info",
     "Query Text Extents"
};

extern int
    OCTextColorIndexHandler(), OCTextColorHandler(),
    OCLineColorIndexHandler(), OCLineColorHandler(),
    OCSurfaceColorIndexHandler(), OCSurfaceColorHandler(),
    OCReflectionAttrHandler(), OCInteriorStyleHandler(),
    OCSurfaceInterpHandler(), OCCullingModeHandler(),
    OCDistinguishHandler(), OCNormalFlipHandler(),
    OCLocalTransformHandler(), OCGlobalTransformHandler(),
    OCViewIndexHandler(), OCLightStateHandler(),
    OCAnnoTextHandler(), OCPolylineHandler(),
    OCNurbCurveHandler(), OCExtFillAreaHandler(),
    OCNurbSurfaceHandler(), OCQuadrilateralMeshHandler (),
    OCHlhsrIdentifierHandler(), OCSurfaceApproxHandler(),
    OCCurveApproxHandler();

extern int
    fOCTextColorHandler(), fOCLineColorHandler(),
    fOCSurfaceColorHandler(), fOCReflectionAttrHandler(),
    fOCLocalTransformHandler(), fOCGlobalTransformHandler(),
    fOCAnnoTextHandler(), fOCPolylineHandler(),
    fOCNurbCurveHandler(), fOCExtFillAreaHandler(),
    fOCNurbSurfaceHandler(), fOCQuadrilateralMeshHandler(),
    fOCSurfaceApproxHandler(), fOCCurveApproxHandler();

extern int
    sOCTextColorIndexHandler(), sOCTextColorHandler(),
    sOCLineColorIndexHandler(), sOCLineColorHandler(),
    sOCSurfaceColorIndexHandler(), sOCSurfaceColorHandler(),
    sOCReflectionAttrHandler(), sOCInteriorStyleHandler(),
    sOCSurfaceInterpHandler(), sOCCullingModeHandler(),
    sOCDistinguishHandler(), sOCNormalFlipHandler(),
    sOCLocalTransformHandler(), sOCGlobalTransformHandler(),
    sOCViewIndexHandler(), sOCLightStateHandler(),
    sOCAnnoTextHandler(), sOCPolylineHandler(),
    sOCNurbCurveHandler(), sOCExtFillAreaHandler(),
    sOCNurbSurfaceHandler(), sOCQuadrilateralMeshHandler (),
    sOCHlhsrIdentifierHandler(), sOCSurfaceApproxHandler(),
    sOCCurveApproxHandler();

extern int
    sfOCTextColorHandler(), sfOCLineColorHandler(),
    sfOCSurfaceColorHandler(), sfOCReflectionAttrHandler(),
    sfOCLocalTransformHandler(), sfOCGlobalTransformHandler(),
    sfOCAnnoTextHandler(), sfOCPolylineHandler(),
    sfOCNurbCurveHandler(), sfOCExtFillAreaHandler(),
    sfOCNurbSurfaceHandler(), sfOCQuadrilateralMeshHandler (),
    sfOCSurfaceApproxHandler(), sfOCCurveApproxHandler();

int (* OCVector[MaxPEXOC])() = {
    BadPEXImplementation,		/* 0  OCAll			 */
    BadPEXImplementation,		/* 1  OCMarkerType		 */
    BadPEXImplementation,		/* 2  OCMarkerScale		 */
    BadPEXImplementation,		/* 3  OCMarkerColorIndex	 */
    BadPEXImplementation,		/* 4  OCMarkerColor		 */
    BadPEXImplementation,		/* 5  OCMarkerBundleIndex	 */
    BadPEXImplementation,		/* 6  OCTextFontIndex		 */
    BadPEXImplementation,		/* 7  OCTextPrecision		 */
    BadPEXImplementation,		/* 8  OCCharExpansion		 */
    BadPEXImplementation,		/* 9  OCCharSpacing		 */
    OCTextColorIndexHandler,		/* 10  OCTextColorIndex		 */
    OCTextColorHandler,			/* 11  OCTextColor		 */
    BadPEXImplementation,		/* 12  OCCharHeight		 */
    BadPEXImplementation,		/* 13  OCCharUpVector		 */
    BadPEXImplementation,		/* 14  OCTextPath		 */
    BadPEXImplementation,		/* 15  OCTextAlignment		 */
    BadPEXImplementation,		/* 16  OCAtextHeight		 */
    BadPEXImplementation,		/* 17  OCAtextUpVector		 */
    BadPEXImplementation,		/* 18  OCAtextPath		 */
    BadPEXImplementation,		/* 19  OCAtextAlignment		 */
    BadPEXImplementation,		/* 20  OCAtextStyle		 */
    BadPEXImplementation,		/* 21  OCTextBundleIndex	 */
    BadPEXImplementation,		/* 22  OCLineType		 */
    BadPEXImplementation,		/* 23  OCLineWidth		 */
    OCLineColorIndexHandler,		/* 24  OCLineColorIndex		 */
    OCLineColorHandler,			/* 25  OCLineColor		 */
    OCCurveApproxHandler,		/* 26  OCCurveApprox		 */
    BadPEXImplementation,		/* 27  OCPolylineInterp		 */
    BadPEXImplementation,		/* 28  OCLineBundleIndex	 */
    OCInteriorStyleHandler,		/* 29  OCInteriorStyle		 */
    BadPEXImplementation,		/* 30  OCInteriorStyleIndex	 */
    OCSurfaceColorIndexHandler,		/* 31  OCSurfaceColorIndex	 */
    OCSurfaceColorHandler,		/* 32  OCSurfaceColor		 */
    OCReflectionAttrHandler,		/* 33  OCReflectionAttr		 */
    BadPEXImplementation,		/* 34  OCReflectionModel	 */
    OCSurfaceInterpHandler,		/* 35  OCSurfaceInterp		 */
    BadPEXImplementation,		/* 36  OCBfInteriorStyle	 */
    BadPEXImplementation,		/* 37  OCBfInteriorStyleIndex	 */
    BadPEXImplementation,		/* 38  OCBfSurfaceColorIndex	 */
    BadPEXImplementation,		/* 39  OCBfSurfaceColor		 */
    BadPEXImplementation,		/* 40  OCBfReflectionAttr	 */
    BadPEXImplementation,		/* 41  OCBfReflectionModel	 */
    BadPEXImplementation,		/* 42  OCBfSurfaceInterp	 */
    OCSurfaceApproxHandler,		/* 43  OCSurfaceApprox		 */
    BadPEXImplementation,		/* 44  OCTrimCurveApprox	 */
    OCCullingModeHandler,		/* 45  OCCullingMode		 */
    OCDistinguishHandler,		/* 46  OCDistinguish		 */
    OCNormalFlipHandler,		/* 47  OCNormalFlip		 */
    BadPEXImplementation,		/* 48  OCPatternSize		 */
    BadPEXImplementation,		/* 49  OCPatternRefPt		 */
    BadPEXImplementation,		/* 50  OCPatternAttr		 */
    BadPEXImplementation,		/* 51  OCInteriorBundleIndex	 */
    BadPEXImplementation,		/* 52  OCSurfaceEdgeFlag	 */
    BadPEXImplementation,		/* 53  OCSurfaceEdgeType	 */
    BadPEXImplementation,		/* 54  OCSurfaceEdgeWidth	 */
    BadPEXImplementation,		/* 55  OCSurfaceEdgeColorIndex	 */
    BadPEXImplementation,		/* 56  OCSurfaceEdgeColor	 */
    BadPEXImplementation,		/* 57  OCEdgeBundleIndex	 */
    BadPEXImplementation,		/* 58  OCAsfValues		 */
    OCLocalTransformHandler,		/* 59  OCLocalTransform		 */
    BadPEXImplementation,		/* 60  OCLocalTransform2D	 */
    OCGlobalTransformHandler,		/* 61  OCGlobalTransform	 */
    BadPEXImplementation,		/* 62  OCGlobalTransform2D	 */
    BadPEXImplementation,		/* 63  OCModelClip		 */
    BadPEXImplementation,		/* 64  OCModelClipVolume	 */
    BadPEXImplementation,		/* 65  OCModelClipVolume2D	 */
    BadPEXImplementation,		/* 66  OCRestoreModelClip	 */
    OCViewIndexHandler,			/* 67  OCViewIndex		 */
    OCLightStateHandler,		/* 68  OCLightState		 */
    BadPEXImplementation,		/* 69  OCDepthCueIndex		 */
    BadPEXImplementation,		/* 70  OCPickId			 */
    OCHlhsrIdentifierHandler,		/* 71  OCHLHSRIdentifier	 */
    BadPEXImplementation,		/* 72  OCAddToNameSet		 */
    BadPEXImplementation,		/* 73  OCRemoveFromNameSet	 */
    BadPEXImplementation,		/* 74  OCExecuteStructure	 */
    BadPEXImplementation,		/* 75  OCLabel			 */
    BadPEXImplementation,		/* 76  OCApplicationData	 */
    BadPEXImplementation,		/* 77  OCGse			 */
    BadPEXImplementation,		/* 78  OCMarkers		 */
    BadPEXImplementation,		/* 79  OCMarkers2D		 */
    BadPEXImplementation,		/* 80  OCText			 */
    BadPEXImplementation,		/* 81  OCText2D			 */
    OCAnnoTextHandler,			/* 82  OCAnnotationText		 */
    BadPEXImplementation,		/* 83  OCAnnotationText2D	 */
    OCPolylineHandler,			/* 84  OCPolyline		 */
    BadPEXImplementation,		/* 85  OCPolyline2D		 */
    BadPEXImplementation,		/* 86  OCPolylineSet		 */
    BadPEXImplementation,		/* 87  OCParametricCurve	 */
    OCNurbCurveHandler,			/* 88  OCNurbCurve		 */
    BadPEXImplementation,		/* 89  OCFillArea		 */
    BadPEXImplementation,		/* 90  OCFillArea2D		 */
    OCExtFillAreaHandler,		/* 91  OCExtFillArea		 */
    BadPEXImplementation,		/* 92  OCFillAreaSet		 */
    BadPEXImplementation,		/* 93  OCFillAreaSet2D		 */
    BadPEXImplementation,		/* 94  OCExtFillAreaSet		 */
    BadPEXImplementation,		/* 95  OCTriangleStrip		 */
    OCQuadrilateralMeshHandler,		/* 96  OCQuadrilateralMesh	 */
    BadPEXImplementation,		/* 97  OCIndexedPolygons	 */
    BadPEXImplementation,		/* 98  OCParametricSurface	 */
    OCNurbSurfaceHandler,		/* 99  OCNurbSurface		 */
    BadPEXImplementation,		/* 100  OCCellArray		 */
    BadPEXImplementation,		/* 101  OCCellArray2D		 */
    BadPEXImplementation,		/* 102  OCExtCellArray		 */
    BadPEXImplementation,		/* 103  OCGdp			 */
    BadPEXImplementation		/* 104  OCGdp2D			 */  
};

/*
 * Procedure Vector for Swapping and No FloatConverting
 */

int (* sOCVector[MaxPEXOC])() = {
    BadPEXImplementation,		/* 0  OCAll			 */
    BadPEXImplementation,		/* 1  OCMarkerType		 */
    BadPEXImplementation,		/* 2  OCMarkerScale		 */
    BadPEXImplementation,		/* 3  OCMarkerColorIndex	 */
    BadPEXImplementation,		/* 4  OCMarkerColor		 */
    BadPEXImplementation,		/* 5  OCMarkerBundleIndex	 */
    BadPEXImplementation,		/* 6  OCTextFontIndex		 */
    BadPEXImplementation,		/* 7  OCTextPrecision		 */
    BadPEXImplementation,		/* 8  OCCharExpansion		 */
    BadPEXImplementation,		/* 9  OCCharSpacing		 */
    OCTextColorIndexHandler,		/* 10  OCTextColorIndex		 */
    sOCTextColorHandler,		/* 11  OCTextColor		 */
    BadPEXImplementation,		/* 12  OCCharHeight		 */
    BadPEXImplementation,		/* 13  OCCharUpVector		 */
    BadPEXImplementation,		/* 14  OCTextPath		 */
    BadPEXImplementation,		/* 15  OCTextAlignment		 */
    BadPEXImplementation,		/* 16  OCAtextHeight		 */
    BadPEXImplementation,		/* 17  OCAtextUpVector		 */
    BadPEXImplementation,		/* 18  OCAtextPath		 */
    BadPEXImplementation,		/* 19  OCAtextAlignment		 */
    BadPEXImplementation,		/* 20  OCAtextStyle		 */
    BadPEXImplementation,		/* 21  OCTextBundleIndex	 */
    BadPEXImplementation,		/* 22  OCLineType		 */
    BadPEXImplementation,		/* 23  OCLineWidth		 */
    sOCLineColorIndexHandler,		/* 24  OCLineColorIndex		 */
    sOCLineColorHandler,		/* 25  OCLineColor		 */
    sOCCurveApproxHandler,		/* 26  OCCurveApprox		 */
    BadPEXImplementation,		/* 27  OCPolylineInterp		 */
    BadPEXImplementation,		/* 28  OCLineBundleIndex	 */
    sOCInteriorStyleHandler,		/* 29  OCInteriorStyle		 */
    BadPEXImplementation,		/* 30  OCInteriorStyleIndex	 */
    sOCSurfaceColorIndexHandler,	/* 31  OCSurfaceColorIndex	 */
    sOCSurfaceColorHandler,		/* 32  OCSurfaceColor		 */
    sOCReflectionAttrHandler, 		/* 33  OCReflectionAttr		 */
    BadPEXImplementation,		/* 34  OCReflectionModel	 */
    sOCSurfaceInterpHandler,		/* 35  OCSurfaceInterp		 */
    BadPEXImplementation,		/* 36  OCBfInteriorStyle	 */
    BadPEXImplementation,		/* 37  OCBfInteriorStyleIndex	 */
    BadPEXImplementation,		/* 38  OCBfSurfaceColorIndex	 */
    BadPEXImplementation,		/* 39  OCBfSurfaceColor		 */
    BadPEXImplementation,		/* 40  OCBfReflectionAttr	 */
    BadPEXImplementation,		/* 41  OCBfReflectionModel	 */
    BadPEXImplementation,		/* 42  OCBfSurfaceInterp	 */
    sOCSurfaceApproxHandler,		/* 43  OCSurfaceApprox		 */
    BadPEXImplementation,		/* 44  OCTrimCurveApprox	 */
    sOCCullingModeHandler,		/* 45  OCCullingMode		 */
    sOCDistinguishHandler,		/* 46  OCDistinguish		 */
    sOCNormalFlipHandler,		/* 47  OCNormalFlip		 */
    BadPEXImplementation,		/* 48  OCPatternSize		 */
    BadPEXImplementation,		/* 49  OCPatternRefPt		 */
    BadPEXImplementation,		/* 50  OCPatternAttr		 */
    BadPEXImplementation,		/* 51  OCInteriorBundleIndex	 */
    BadPEXImplementation,		/* 52  OCSurfaceEdgeFlag	 */
    BadPEXImplementation,		/* 53  OCSurfaceEdgeType	 */
    BadPEXImplementation,		/* 54  OCSurfaceEdgeWidth	 */
    BadPEXImplementation,		/* 55  OCSurfaceEdgeColorIndex	 */
    BadPEXImplementation,		/* 56  OCSurfaceEdgeColor	 */
    BadPEXImplementation,		/* 57  OCEdgeBundleIndex	 */
    BadPEXImplementation,		/* 58  OCAsfValues		 */
    sOCLocalTransformHandler,		/* 59  OCLocalTransform		 */
    BadPEXImplementation,		/* 60  OCLocalTransform2D	 */
    sOCGlobalTransformHandler,		/* 61  OCGlobalTransform	 */
    BadPEXImplementation,		/* 62  OCGlobalTransform2D	 */
    BadPEXImplementation,		/* 63  OCModelClip		 */
    BadPEXImplementation,		/* 64  OCModelClipVolume	 */
    BadPEXImplementation,		/* 65  OCModelClipVolume2D	 */
    BadPEXImplementation,		/* 66  OCRestoreModelClip	 */
    sOCViewIndexHandler,		/* 67  OCViewIndex		 */
    sOCLightStateHandler,		/* 68  OCLightState		 */
    BadPEXImplementation,		/* 69  OCDepthCueIndex		 */
    BadPEXImplementation,		/* 70  OCPickId			 */
    sOCHlhsrIdentifierHandler,		/* 71  OCHLHSRIdentifier	 */
    BadPEXImplementation,		/* 72  OCAddToNameSet		 */
    BadPEXImplementation,		/* 73  OCRemoveFromNameSet	 */
    BadPEXImplementation,		/* 74  OCExecuteStructure	 */
    BadPEXImplementation,		/* 75  OCLabel			 */
    BadPEXImplementation,		/* 76  OCApplicationData	 */
    BadPEXImplementation,		/* 77  OCGse			 */
    BadPEXImplementation,		/* 78  OCMarkers		 */
    BadPEXImplementation,		/* 79  OCMarkers2D		 */
    BadPEXImplementation,		/* 80  OCText			 */
    BadPEXImplementation,		/* 81  OCText2D			 */
    sOCAnnoTextHandler,			/* 82  OCAnnotationText		 */
    BadPEXImplementation,		/* 83  OCAnnotationText2D	 */
    sOCPolylineHandler,			/* 84  OCPolyline		 */
    BadPEXImplementation,		/* 85  OCPolyline2D		 */
    BadPEXImplementation,		/* 86  OCPolylineSet		 */
    BadPEXImplementation,		/* 87  OCParametricCurve	 */
    sOCNurbCurveHandler,		/* 88  OCNurbCurve		 */
    BadPEXImplementation,		/* 89  OCFillArea		 */
    BadPEXImplementation,		/* 90  OCFillArea2D		 */
    sOCExtFillAreaHandler,		/* 91  OCExtFillArea		 */
    BadPEXImplementation,		/* 92  OCFillAreaSet		 */
    BadPEXImplementation,		/* 93  OCFillAreaSet2D		 */
    BadPEXImplementation,		/* 94  OCExtFillAreaSet		 */
    BadPEXImplementation,		/* 95  OCTriangleStrip		 */
    sOCQuadrilateralMeshHandler,	/* 96  OCQuadrilateralMesh	 */
    BadPEXImplementation,		/* 97  OCIndexedPolygons	 */
    BadPEXImplementation,		/* 98  OCParametricSurface	 */
    sOCNurbSurfaceHandler,		/* 99  OCNurbSurface		 */
    BadPEXImplementation,		/* 100  OCCellArray		 */
    BadPEXImplementation,		/* 101  OCCellArray2D		 */
    BadPEXImplementation,		/* 102  OCExtCellArray		 */
    BadPEXImplementation,		/* 103  OCGdp			 */
    BadPEXImplementation		/* 104  OCGdp2D			 */  
};

/*
 * Procedure vector for OutputCommands (floatConverting and not Swapping)
 */

int (* fOCVector[MaxPEXOC])() = {
    BadPEXImplementation,		/* 0  OCAll			 */
    BadPEXImplementation,		/* 1  OCMarkerType		 */
    BadPEXImplementation,		/* 2  OCMarkerScale		 */
    BadPEXImplementation,		/* 3  OCMarkerColorIndex	 */
    BadPEXImplementation,		/* 4  OCMarkerColor		 */
    BadPEXImplementation,		/* 5  OCMarkerBundleIndex	 */
    BadPEXImplementation,		/* 6  OCTextFontIndex		 */
    BadPEXImplementation,		/* 7  OCTextPrecision		 */
    BadPEXImplementation,		/* 8  OCCharExpansion		 */
    BadPEXImplementation,		/* 9  OCCharSpacing		 */
    sOCTextColorIndexHandler,		/* 10  OCTextColorIndex		 */
    fOCTextColorHandler,		/* 11  OCTextColor		 */
    BadPEXImplementation,		/* 12  OCCharHeight		 */
    BadPEXImplementation,		/* 13  OCCharUpVector		 */
    BadPEXImplementation,		/* 14  OCTextPath		 */
    BadPEXImplementation,		/* 15  OCTextAlignment		 */
    BadPEXImplementation,		/* 16  OCAtextHeight		 */
    BadPEXImplementation,		/* 17  OCAtextUpVector		 */
    BadPEXImplementation,		/* 18  OCAtextPath		 */
    BadPEXImplementation,		/* 19  OCAtextAlignment		 */
    BadPEXImplementation,		/* 20  OCAtextStyle		 */
    BadPEXImplementation,		/* 21  OCTextBundleIndex	 */
    BadPEXImplementation,		/* 22  OCLineType		 */
    BadPEXImplementation,		/* 23  OCLineWidth		 */
    OCLineColorIndexHandler,		/* 24  OCLineColorIndex		 */
    fOCLineColorHandler,		/* 25  OCLineColor		 */
    fOCCurveApproxHandler,		/* 26  OCCurveApprox		 */
    BadPEXImplementation,		/* 27  OCPolylineInterp		 */
    BadPEXImplementation,		/* 28  OCLineBundleIndex	 */
    OCInteriorStyleHandler,		/* 29  OCInteriorStyle		 */
    BadPEXImplementation,		/* 30  OCInteriorStyleIndex	 */
    OCSurfaceColorIndexHandler,		/* 31  OCSurfaceColorIndex	 */
    fOCSurfaceColorHandler,		/* 32  OCSurfaceColor		 */
    fOCReflectionAttrHandler, 		/* 33  OCReflectionAttr		 */
    BadPEXImplementation,		/* 34  OCReflectionModel	 */
    OCSurfaceInterpHandler,		/* 35  OCSurfaceInterp		 */
    BadPEXImplementation,		/* 36  OCBfInteriorStyle	 */
    BadPEXImplementation,		/* 37  OCBfInteriorStyleIndex	 */
    BadPEXImplementation,		/* 38  OCBfSurfaceColorIndex	 */
    BadPEXImplementation,		/* 39  OCBfSurfaceColor		 */
    BadPEXImplementation,		/* 40  OCBfReflectionAttr	 */
    BadPEXImplementation,		/* 41  OCBfReflectionModel	 */
    BadPEXImplementation,		/* 42  OCBfSurfaceInterp	 */
    fOCSurfaceApproxHandler,		/* 43  OCSurfaceApprox		 */
    BadPEXImplementation,		/* 44  OCTrimCurveApprox	 */
    OCCullingModeHandler,		/* 45  OCCullingMode		 */
    OCDistinguishHandler,		/* 46  OCDistinguish		 */
    OCNormalFlipHandler,		/* 47  OCNormalFlip		 */
    BadPEXImplementation,		/* 48  OCPatternSize		 */
    BadPEXImplementation,		/* 49  OCPatternRefPt		 */
    BadPEXImplementation,		/* 50  OCPatternAttr		 */
    BadPEXImplementation,		/* 51  OCInteriorBundleIndex	 */
    BadPEXImplementation,		/* 52  OCSurfaceEdgeFlag	 */
    BadPEXImplementation,		/* 53  OCSurfaceEdgeType	 */
    BadPEXImplementation,		/* 54  OCSurfaceEdgeWidth	 */
    BadPEXImplementation,		/* 55  OCSurfaceEdgeColorIndex	 */
    BadPEXImplementation,		/* 56  OCSurfaceEdgeColor	 */
    BadPEXImplementation,		/* 57  OCEdgeBundleIndex	 */
    BadPEXImplementation,		/* 58  OCAsfValues		 */
    fOCLocalTransformHandler,		/* 59  OCLocalTransform		 */
    BadPEXImplementation,		/* 60  OCLocalTransform2D	 */
    fOCGlobalTransformHandler,		/* 61  OCGlobalTransform	 */
    BadPEXImplementation,		/* 62  OCGlobalTransform2D	 */
    BadPEXImplementation,		/* 63  OCModelClip		 */
    BadPEXImplementation,		/* 64  OCModelClipVolume	 */
    BadPEXImplementation,		/* 65  OCModelClipVolume2D	 */
    BadPEXImplementation,		/* 66  OCRestoreModelClip	 */
    OCViewIndexHandler,			/* 67  OCViewIndex		 */
    OCLightStateHandler,		/* 68  OCLightState		 */
    BadPEXImplementation,		/* 69  OCDepthCueIndex		 */
    BadPEXImplementation,		/* 70  OCPickId			 */
    OCHlhsrIdentifierHandler,		/* 71  OCHLHSRIdentifier	 */
    BadPEXImplementation,		/* 72  OCAddToNameSet		 */
    BadPEXImplementation,		/* 73  OCRemoveFromNameSet	 */
    BadPEXImplementation,		/* 74  OCExecuteStructure	 */
    BadPEXImplementation,		/* 75  OCLabel			 */
    BadPEXImplementation,		/* 76  OCApplicationData	 */
    BadPEXImplementation,		/* 77  OCGse			 */
    BadPEXImplementation,		/* 78  OCMarkers		 */
    BadPEXImplementation,		/* 79  OCMarkers2D		 */
    BadPEXImplementation,		/* 80  OCText			 */
    BadPEXImplementation,		/* 81  OCText2D			 */
    fOCAnnoTextHandler,			/* 82  OCAnnotationText		 */
    BadPEXImplementation,		/* 83  OCAnnotationText2D	 */
    fOCPolylineHandler,			/* 84  OCPolyline		 */
    BadPEXImplementation,		/* 85  OCPolyline2D		 */
    BadPEXImplementation,		/* 86  OCPolylineSet		 */
    BadPEXImplementation,		/* 87  OCParametricCurve	 */
    fOCNurbCurveHandler,		/* 88  OCNurbCurve		 */
    BadPEXImplementation,		/* 89  OCFillArea		 */
    BadPEXImplementation,		/* 90  OCFillArea2D		 */
    fOCExtFillAreaHandler,		/* 91  OCExtFillArea		 */
    BadPEXImplementation,		/* 92  OCFillAreaSet		 */
    BadPEXImplementation,		/* 93  OCFillAreaSet2D		 */
    BadPEXImplementation,		/* 94  OCExtFillAreaSet		 */
    BadPEXImplementation,		/* 95  OCTriangleStrip		 */
    fOCQuadrilateralMeshHandler,	/* 96  OCQuadrilateralMesh	 */
    BadPEXImplementation,		/* 97  OCIndexedPolygons	 */
    BadPEXImplementation,		/* 98  OCParametricSurface	 */
    fOCNurbSurfaceHandler,		/* 99  OCNurbSurface		 */
    BadPEXImplementation,		/* 100  OCCellArray		 */
    BadPEXImplementation,		/* 101  OCCellArray2D		 */
    BadPEXImplementation,		/* 102  OCExtCellArray		 */
    BadPEXImplementation,		/* 103  OCGdp			 */
    BadPEXImplementation		/* 104  OCGdp2D			 */  
};

/*
 * Procedure vector for Swapping and FloatConverting OutputCommands
 */
 
int (* sfOCVector[MaxPEXOC])() = {
    BadPEXImplementation,		/* 0  OCAll			 */
    BadPEXImplementation,		/* 1  OCMarkerType		 */
    BadPEXImplementation,		/* 2  OCMarkerScale		 */
    BadPEXImplementation,		/* 3  OCMarkerColorIndex	 */
    BadPEXImplementation,		/* 4  OCMarkerColor		 */
    BadPEXImplementation,		/* 5  OCMarkerBundleIndex	 */
    BadPEXImplementation,		/* 6  OCTextFontIndex		 */
    BadPEXImplementation,		/* 7  OCTextPrecision		 */
    BadPEXImplementation,		/* 8  OCCharExpansion		 */
    BadPEXImplementation,		/* 9  OCCharSpacing		 */
    sOCTextColorIndexHandler,		/* 10  OCTextColorIndex		 */
    sfOCTextColorHandler,		/* 11  OCTextColor		 */
    BadPEXImplementation,		/* 12  OCCharHeight		 */
    BadPEXImplementation,		/* 13  OCCharUpVector		 */
    BadPEXImplementation,		/* 14  OCTextPath		 */
    BadPEXImplementation,		/* 15  OCTextAlignment		 */
    BadPEXImplementation,		/* 16  OCAtextHeight		 */
    BadPEXImplementation,		/* 17  OCAtextUpVector		 */
    BadPEXImplementation,		/* 18  OCAtextPath		 */
    BadPEXImplementation,		/* 19  OCAtextAlignment		 */
    BadPEXImplementation,		/* 20  OCAtextStyle		 */
    BadPEXImplementation,		/* 21  OCTextBundleIndex	 */
    BadPEXImplementation,		/* 22  OCLineType		 */
    BadPEXImplementation,		/* 23  OCLineWidth		 */
    sOCLineColorIndexHandler,		/* 24  OCLineColorIndex		 */
    sfOCLineColorHandler,		/* 25  OCLineColor		 */
    sfOCCurveApproxHandler,		/* 26  OCCurveApprox		 */
    BadPEXImplementation,		/* 27  OCPolylineInterp		 */
    BadPEXImplementation,		/* 28  OCLineBundleIndex	 */
    sOCInteriorStyleHandler,		/* 29  OCInteriorStyle		 */
    BadPEXImplementation,		/* 30  OCInteriorStyleIndex	 */
    sOCSurfaceColorIndexHandler,	/* 31  OCSurfaceColorIndex	 */
    sfOCSurfaceColorHandler,		/* 32  OCSurfaceColor		 */
    sfOCReflectionAttrHandler, 		/* 33  OCReflectionAttr		 */
    BadPEXImplementation,		/* 34  OCReflectionModel	 */
    sOCSurfaceInterpHandler,		/* 35  OCSurfaceInterp		 */
    BadPEXImplementation,		/* 36  OCBfInteriorStyle	 */
    BadPEXImplementation,		/* 37  OCBfInteriorStyleIndex	 */
    BadPEXImplementation,		/* 38  OCBfSurfaceColorIndex	 */
    BadPEXImplementation,		/* 39  OCBfSurfaceColor		 */
    BadPEXImplementation,		/* 40  OCBfReflectionAttr	 */
    BadPEXImplementation,		/* 41  OCBfReflectionModel	 */
    BadPEXImplementation,		/* 42  OCBfSurfaceInterp	 */
    sfOCSurfaceApproxHandler,		/* 43  OCSurfaceApprox		 */
    BadPEXImplementation,		/* 44  OCTrimCurveApprox	 */
    sOCCullingModeHandler,		/* 45  OCCullingMode		 */
    sOCDistinguishHandler,		/* 46  OCDistinguish		 */
    sOCNormalFlipHandler,		/* 47  OCNormalFlip		 */
    BadPEXImplementation,		/* 48  OCPatternSize		 */
    BadPEXImplementation,		/* 49  OCPatternRefPt		 */
    BadPEXImplementation,		/* 50  OCPatternAttr		 */
    BadPEXImplementation,		/* 51  OCInteriorBundleIndex	 */
    BadPEXImplementation,		/* 52  OCSurfaceEdgeFlag	 */
    BadPEXImplementation,		/* 53  OCSurfaceEdgeType	 */
    BadPEXImplementation,		/* 54  OCSurfaceEdgeWidth	 */
    BadPEXImplementation,		/* 55  OCSurfaceEdgeColorIndex	 */
    BadPEXImplementation,		/* 56  OCSurfaceEdgeColor	 */
    BadPEXImplementation,		/* 57  OCEdgeBundleIndex	 */
    BadPEXImplementation,		/* 58  OCAsfValues		 */
    sfOCLocalTransformHandler,		/* 59  OCLocalTransform		 */
    BadPEXImplementation,		/* 60  OCLocalTransform2D	 */
    sfOCGlobalTransformHandler,		/* 61  OCGlobalTransform	 */
    BadPEXImplementation,		/* 62  OCGlobalTransform2D	 */
    BadPEXImplementation,		/* 63  OCModelClip		 */
    BadPEXImplementation,		/* 64  OCModelClipVolume	 */
    BadPEXImplementation,		/* 65  OCModelClipVolume2D	 */
    BadPEXImplementation,		/* 66  OCRestoreModelClip	 */
    sOCViewIndexHandler,		/* 67  OCViewIndex		 */
    sOCLightStateHandler,		/* 68  OCLightState		 */
    BadPEXImplementation,		/* 69  OCDepthCueIndex		 */
    BadPEXImplementation,		/* 70  OCPickId			 */
    sOCHlhsrIdentifierHandler,		/* 71  OCHLHSRIdentifier	 */
    BadPEXImplementation,		/* 72  OCAddToNameSet		 */
    BadPEXImplementation,		/* 73  OCRemoveFromNameSet	 */
    BadPEXImplementation,		/* 74  OCExecuteStructure	 */
    BadPEXImplementation,		/* 75  OCLabel			 */
    BadPEXImplementation,		/* 76  OCApplicationData	 */
    BadPEXImplementation,		/* 77  OCGse			 */
    BadPEXImplementation,		/* 78  OCMarkers		 */
    BadPEXImplementation,		/* 79  OCMarkers2D		 */
    BadPEXImplementation,		/* 80  OCText			 */
    BadPEXImplementation,		/* 81  OCText2D			 */
    sfOCAnnoTextHandler,		/* 82  OCAnnotationText		 */
    BadPEXImplementation,		/* 83  OCAnnotationText2D	 */
    sfOCPolylineHandler,		/* 84  OCPolyline		 */
    BadPEXImplementation,		/* 85  OCPolyline2D		 */
    BadPEXImplementation,		/* 86  OCPolylineSet		 */
    BadPEXImplementation,		/* 87  OCParametricCurve	 */
    sfOCNurbCurveHandler,		/* 88  OCNurbCurve		 */
    BadPEXImplementation,		/* 89  OCFillArea		 */
    BadPEXImplementation,		/* 90  OCFillArea2D		 */
    sfOCExtFillAreaHandler,		/* 91  OCExtFillArea		 */
    BadPEXImplementation,		/* 92  OCFillAreaSet		 */
    BadPEXImplementation,		/* 93  OCFillAreaSet2D		 */
    BadPEXImplementation,		/* 94  OCExtFillAreaSet		 */
    BadPEXImplementation,		/* 95  OCTriangleStrip		 */
    sfOCQuadrilateralMeshHandler,	/* 96  OCQuadrilateralMesh	 */
    BadPEXImplementation,		/* 97  OCIndexedPolygons	 */
    BadPEXImplementation,		/* 98  OCParametricSurface	 */
    sfOCNurbSurfaceHandler,		/* 99  OCNurbSurface		 */
    BadPEXImplementation,		/* 100  OCCellArray		 */
    BadPEXImplementation,		/* 101  OCCellArray2D		 */
    BadPEXImplementation,		/* 102  OCExtCellArray		 */
    BadPEXImplementation,		/* 103  OCGdp			 */
    BadPEXImplementation		/* 104  OCGdp2D			 */  
};


extern int 
    PexBeginRenderingHandler(), PexEndRenderingHandler(), 
    PexFreeRendererHandler(), PexCreateRendererHandler(),
    PexBeginStructureHandler(), PexEndStructureHandler(),
    PexRenderOutputCommandsHandler(), PexSetViewRepHandler();

extern int 
    sPexBeginRenderingHandler(), sPexEndRenderingHandler(), 
    sPexFreeRendererHandler(), sPexCreateRendererHandler(),
    sPexBeginStructureHandler(), sPexEndStructureHandler(),
    sPexRenderOutputCommandsHandler(), sPexSetViewRepHandler();

extern int 
    fPexCreateRendererHandler(),
    fPexRenderOutputCommandsHandler(), fPexSetViewRepHandler();

extern int 
    sfPexCreateRendererHandler(),
    sfPexRenderOutputCommandsHandler(), sfPexSetViewRepHandler();



int (* PEXRequestVector[MaxPEXCommand])	() = {
    BadPEXImplementationReq,	/* 0 Not Defined		*/
    BadPEXImplementationReq,	/* 1 PEX_GetExtensionInfo XXX	*/
    BadPEXImplementationReq,	/* 2 PEX_GetEnumeratedTypeInfo	*/
    BadPEXImplementationReq,	/* 3 PEX_CreateLookupTable	*/
    BadPEXImplementationReq,	/* 4 PEX_CopyLookupTable	*/
    BadPEXImplementationReq,	/* 5 PEX_FreeLookupTable	*/
    BadPEXImplementationReq,	/* 6 PEX_GetTableInfo		*/
    BadPEXImplementationReq,	/* 7 PEX_GetPredefinedEntries	*/
    BadPEXImplementationReq,	/* 8 PEX_GetDefinedIndices	*/
    BadPEXImplementationReq,	/* 9 PEX_GetTableEntry		*/
    BadPEXImplementationReq,	/* 10 PEX_GetTableEntries	*/
    BadPEXImplementationReq,	/* 11 PEX_SetTableEntries	*/
    BadPEXImplementationReq,	/* 12 PEX_DeleteTableEntries	*/
    BadPEXImplementationReq,	/* 13 PEX_CreatePipelineContext	*/
    BadPEXImplementationReq,	/* 14 PEX_CopyPipelineContext	*/
    BadPEXImplementationReq,	/* 15 PEX_FreePipelineContext	*/
    BadPEXImplementationReq,	/* 16 PEX_GetPipelineContext	*/
    BadPEXImplementationReq,	/* 17 PEX_ChangePipelineContext	*/
    PexCreateRendererHandler,	/* 18 PEX_CreateRenderer	*/
    PexFreeRendererHandler,	/* 19 PEX_FreeRenderer		*/
    BadPEXImplementationReq,	/* 20 PEX_ChangeRenderer	*/
    BadPEXImplementationReq,	/* 21 PEX_GetRendererAttributes	*/
    PexBeginRenderingHandler,	/* 22 PEX_BeginRendering	*/
    PexEndRenderingHandler,	/* 23 PEX_EndRendering		*/
    PexBeginStructureHandler,	/* 24 PEX_BeginStructure	*/
    PexEndStructureHandler,	/* 25 PEX_EndStructure		*/
    PexRenderOutputCommandsHandler,	/* 26 PEX_RenderOutputCommands	*/
    BadPEXImplementationReq,	/* 27 PEX_RenderNetwork		*/
    BadPEXImplementationReq,	/* 28 PEX_CreateStructure	*/
    BadPEXImplementationReq,	/* 29 PEX_CopyStructure		*/
    BadPEXImplementationReq,	/* 30 PEX_FreeStructure		*/
    BadPEXImplementationReq,	/* 31 PEX_DeleteStructures	*/
    BadPEXImplementationReq,	/* 32 PEX_GetStructureInfo	*/
    BadPEXImplementationReq,	/* 33 PEX_GetElementInfo	*/
    BadPEXImplementationReq,	/* 34 PEX_GetStructuresInNetwork*/
    BadPEXImplementationReq,	/* 35 PEX_GetAncestors		*/
    BadPEXImplementationReq,	/* 36 PEX_GetDescendants	*/
    BadPEXImplementationReq,	/* 37 PEX_FetchElements		*/
    BadPEXImplementationReq,	/* 38 PEX_SetEditingMode	*/
    BadPEXImplementationReq,	/* 39 PEX_SetElementPointer	*/
    BadPEXImplementationReq,	/* 40 PEX_SetElementPointerAtLabel*/
    BadPEXImplementationReq,	/* 41 PEX_ElementSearch		*/
    BadPEXImplementationReq,	/* 42 PEX_StoreElements		*/
    BadPEXImplementationReq,	/* 43 PEX_DeleteElements	*/
    BadPEXImplementationReq,	/* 44 PEX_DeleteElementsToLabel	*/
    BadPEXImplementationReq,	/* 45 PEX_DeleteBetweenLabels	*/
    BadPEXImplementationReq,	/* 46 PEX_CopyElements		*/
    BadPEXImplementationReq,	/* 47 PEX_ChangeStructureRefs	*/
    BadPEXImplementationReq,	/* 48 PEX_CreateNameSet		*/
    BadPEXImplementationReq,	/* 49 PEX_CopyNameSet		*/
    BadPEXImplementationReq,	/* 50 PEX_FreeNameSet		*/
    BadPEXImplementationReq,	/* 51 PEX_GetNameSet		*/
    BadPEXImplementationReq,	/* 52 PEX_ChangeNameSet		*/
    BadPEXImplementationReq,	/* 53 PEX_CreateSearchContext	*/
    BadPEXImplementationReq,	/* 54 PEX_CopySearchContext	*/
    BadPEXImplementationReq,	/* 55 PEX_FreeSearchContext	*/
    BadPEXImplementationReq,	/* 56 PEX_GetSearchContext	*/
    BadPEXImplementationReq,	/* 57 PEX_ChangeSearchContext	*/
    BadPEXImplementationReq,	/* 58 PEX_SearchNetwork		*/
    BadPEXImplementationReq,	/* 59 PEX_CreatepexPhigsWks	*/
    BadPEXImplementationReq,	/* 60 PEX_FreepexPhigsWks	*/
    BadPEXImplementationReq,	/* 61 PEX_GetWksInfo		*/
    BadPEXImplementationReq,	/* 62 PEX_GetDynamics		*/
    BadPEXImplementationReq,	/* 63 PEX_GetViewRep		*/
    BadPEXImplementationReq,	/* 64 PEX_RedrawAllStructures	*/
    BadPEXImplementationReq,	/* 65 PEX_UpdateWorkstation	*/
    BadPEXImplementationReq,	/* 66 PEX_ExecuteDeferredActions*/
    BadPEXImplementationReq,	/* 67 PEX_SetViewPriority	*/
    BadPEXImplementationReq,	/* 68 PEX_SetDisplayUpdateMode	*/
    BadPEXImplementationReq,	/* 69 PEX_MapPoints		*/
    PexSetViewRepHandler,	/* 70 PEX_SetViewRep		*/
    BadPEXImplementationReq,	/* 71 PEX_SetWksWindow		*/
    BadPEXImplementationReq,	/* 72 PEX_SetWksViewport	*/
    BadPEXImplementationReq,	/* 73 PEX_SetHLHSRMode		*/
    BadPEXImplementationReq,	/* 74 PEX_PostStructure		*/
    BadPEXImplementationReq,	/* 75 PEX_UnpostStructure	*/
    BadPEXImplementationReq,	/* 76 PEXUnpostAllStructures	*/ 
    BadPEXImplementationReq,	/* 77 PEX_GetWksPostings	*/
    BadPEXImplementationReq,	/* 78 PEX_GetPickDevice		*/
    BadPEXImplementationReq,	/* 79 PEX_ChangePickDevice	*/
    BadPEXImplementationReq,	/* 80 PEX_CreatePickMeasure	*/
    BadPEXImplementationReq,	/* 81 PEX_FreePickMeasure	*/
    BadPEXImplementationReq,	/* 82 PEX_GetPickMeasure	*/
    BadPEXImplementationReq,	/* 83 PEX_UpdatePickMeasure	*/
    BadPEXImplementationReq,	/* 84 PEX_OpenFont		*/
    BadPEXImplementationReq,	/* 85 PEX_CloseFont		*/
    BadPEXImplementationReq,	/* 86 PEX_QueryFont		*/
    BadPEXImplementationReq,	/* 87 PEX_ListFonts		*/
    BadPEXImplementationReq,	/* 88 PEX_ListFontsWithInfo	*/
    BadPEXImplementationReq, 	/* 89 PEX_QueryTextExtents	*/
};

int (* sPEXRequestVector[MaxPEXCommand])() = {
    BadPEXImplementationReq,	/* 0 Not Defined		*/
    BadPEXImplementationReq,	/* 1 PEX_GetExtensionInfo XXX	*/
    BadPEXImplementationReq,	/* 2 PEX_GetEnumeratedTypeInfo	*/
    BadPEXImplementationReq,	/* 3 PEX_CreateLookupTable	*/
    BadPEXImplementationReq,	/* 4 PEX_CopyLookupTable	*/
    BadPEXImplementationReq,	/* 5 PEX_FreeLookupTable	*/
    BadPEXImplementationReq,	/* 6 PEX_GetTableInfo		*/
    BadPEXImplementationReq,	/* 7 PEX_GetPredefinedEntries	*/
    BadPEXImplementationReq,	/* 8 PEX_GetDefinedIndices	*/
    BadPEXImplementationReq,	/* 9 PEX_GetTableEntry		*/
    BadPEXImplementationReq,	/* 10 PEX_GetTableEntries	*/
    BadPEXImplementationReq,	/* 11 PEX_SetTableEntries	*/
    BadPEXImplementationReq,	/* 12 PEX_DeleteTableEntries	*/
    BadPEXImplementationReq,	/* 13 PEX_CreatePipelineContext	*/
    BadPEXImplementationReq,	/* 14 PEX_CopyPipelineContext	*/
    BadPEXImplementationReq,	/* 15 PEX_FreePipelineContext	*/
    BadPEXImplementationReq,	/* 16 PEX_GetPipelineContext	*/
    BadPEXImplementationReq,	/* 17 PEX_ChangePipelineContext	*/
    sPexCreateRendererHandler,	/* 18 PEX_CreateRenderer	*/
    sPexFreeRendererHandler,	/* 19 PEX_FreeRenderer		*/
    BadPEXImplementationReq,	/* 20 PEX_ChangeRenderer	*/
    BadPEXImplementationReq,	/* 21 PEX_GetRendererAttributes	*/
    sPexBeginRenderingHandler,	/* 22 PEX_BeginRendering	*/
    sPexEndRenderingHandler,	/* 23 PEX_EndRendering		*/
    sPexBeginStructureHandler,	/* 24 PEX_BeginStructure	*/
    sPexEndStructureHandler,	/* 25 PEX_EndStructure		*/
    sPexRenderOutputCommandsHandler,	/* 26 PEX_RenderOutputCommands	*/
    BadPEXImplementationReq,	/* 27 PEX_RenderNetwork		*/
    BadPEXImplementationReq,	/* 28 PEX_CreateStructure	*/
    BadPEXImplementationReq,	/* 29 PEX_CopyStructure		*/
    BadPEXImplementationReq,	/* 30 PEX_FreeStructure		*/
    BadPEXImplementationReq,	/* 31 PEX_DeleteStructures	*/
    BadPEXImplementationReq,	/* 32 PEX_GetStructureInfo	*/
    BadPEXImplementationReq,	/* 33 PEX_GetElementInfo	*/
    BadPEXImplementationReq,	/* 34 PEX_GetStructuresInNetwork*/
    BadPEXImplementationReq,	/* 35 PEX_GetAncestors		*/
    BadPEXImplementationReq,	/* 36 PEX_GetDescendants	*/
    BadPEXImplementationReq,	/* 37 PEX_FetchElements		*/
    BadPEXImplementationReq,	/* 38 PEX_SetEditingMode	*/
    BadPEXImplementationReq,	/* 39 PEX_SetElementPointer	*/
    BadPEXImplementationReq,	/* 40 PEX_SetElementPointerAtLabel*/
    BadPEXImplementationReq,	/* 41 PEX_ElementSearch		*/
    BadPEXImplementationReq,	/* 42 PEX_StoreElements		*/
    BadPEXImplementationReq,	/* 43 PEX_DeleteElements	*/
    BadPEXImplementationReq,	/* 44 PEX_DeleteElementsToLabel	*/
    BadPEXImplementationReq,	/* 45 PEX_DeleteBetweenLabels	*/
    BadPEXImplementationReq,	/* 46 PEX_CopyElements		*/
    BadPEXImplementationReq,	/* 47 PEX_ChangeStructureRefs	*/
    BadPEXImplementationReq,	/* 48 PEX_CreateNameSet		*/
    BadPEXImplementationReq,	/* 49 PEX_CopyNameSet		*/
    BadPEXImplementationReq,	/* 50 PEX_FreeNameSet		*/
    BadPEXImplementationReq,	/* 51 PEX_GetNameSet		*/
    BadPEXImplementationReq,	/* 52 PEX_ChangeNameSet		*/
    BadPEXImplementationReq,	/* 53 PEX_CreateSearchContext	*/
    BadPEXImplementationReq,	/* 54 PEX_CopySearchContext	*/
    BadPEXImplementationReq,	/* 55 PEX_FreeSearchContext	*/
    BadPEXImplementationReq,	/* 56 PEX_GetSearchContext	*/
    BadPEXImplementationReq,	/* 57 PEX_ChangeSearchContext	*/
    BadPEXImplementationReq,	/* 58 PEX_SearchNetwork		*/
    BadPEXImplementationReq,	/* 59 PEX_CreatepexPhigsWks	*/
    BadPEXImplementationReq,	/* 60 PEX_FreepexPhigsWks	*/
    BadPEXImplementationReq,	/* 61 PEX_GetWksInfo		*/
    BadPEXImplementationReq,	/* 62 PEX_GetDynamics		*/
    BadPEXImplementationReq,	/* 63 PEX_GetViewRep		*/
    BadPEXImplementationReq,	/* 64 PEX_RedrawAllStructures	*/
    BadPEXImplementationReq,	/* 65 PEX_UpdateWorkstation	*/
    BadPEXImplementationReq,	/* 66 PEX_ExecuteDeferredActions*/
    BadPEXImplementationReq,	/* 67 PEX_SetViewPriority	*/
    BadPEXImplementationReq,	/* 68 PEX_SetDisplayUpdateMode	*/
    BadPEXImplementationReq,	/* 69 PEX_MapPoints		*/
    sPexSetViewRepHandler,	/* 70 PEX_SetViewRep		*/
    BadPEXImplementationReq,	/* 71 PEX_SetWksWindow		*/
    BadPEXImplementationReq,	/* 72 PEX_SetWksViewport	*/
    BadPEXImplementationReq,	/* 73 PEX_SetHLHSRMode		*/
    BadPEXImplementationReq,	/* 74 PEX_PostStructure		*/
    BadPEXImplementationReq,	/* 75 PEX_UnpostStructure	*/
    BadPEXImplementationReq,	/* 76 PEXUnpostAllStructures	*/ 
    BadPEXImplementationReq,	/* 77 PEX_GetWksPostings	*/
    BadPEXImplementationReq,	/* 78 PEX_GetPickDevice		*/
    BadPEXImplementationReq,	/* 79 PEX_ChangePickDevice	*/
    BadPEXImplementationReq,	/* 80 PEX_CreatePickMeasure	*/
    BadPEXImplementationReq,	/* 81 PEX_FreePickMeasure	*/
    BadPEXImplementationReq,	/* 82 PEX_GetPickMeasure	*/
    BadPEXImplementationReq,	/* 83 PEX_UpdatePickMeasure	*/
    BadPEXImplementationReq,	/* 84 PEX_OpenFont		*/
    BadPEXImplementationReq,	/* 85 PEX_CloseFont		*/
    BadPEXImplementationReq,	/* 86 PEX_QueryFont		*/
    BadPEXImplementationReq,	/* 87 PEX_ListFonts		*/
    BadPEXImplementationReq,	/* 88 PEX_ListFontsWithInfo	*/
    BadPEXImplementationReq, 	/* 89 PEX_QueryTextExtents	*/
};

int (* fPEXRequestVector[MaxPEXCommand])() = {
    BadPEXImplementationReq,	/* 0 Not Defined		*/
    BadPEXImplementationReq,	/* 1 PEX_GetExtensionInfo XXX	*/
    BadPEXImplementationReq,	/* 2 PEX_GetEnumeratedTypeInfo	*/
    BadPEXImplementationReq,	/* 3 PEX_CreateLookupTable	*/
    BadPEXImplementationReq,	/* 4 PEX_CopyLookupTable	*/
    BadPEXImplementationReq,	/* 5 PEX_FreeLookupTable	*/
    BadPEXImplementationReq,	/* 6 PEX_GetTableInfo		*/
    BadPEXImplementationReq,	/* 7 PEX_GetPredefinedEntries	*/
    BadPEXImplementationReq,	/* 8 PEX_GetDefinedIndices	*/
    BadPEXImplementationReq,	/* 9 PEX_GetTableEntry		*/
    BadPEXImplementationReq,	/* 10 PEX_GetTableEntries	*/
    BadPEXImplementationReq,	/* 11 PEX_SetTableEntries	*/
    BadPEXImplementationReq,	/* 12 PEX_DeleteTableEntries	*/
    BadPEXImplementationReq,	/* 13 PEX_CreatePipelineContext	*/
    BadPEXImplementationReq,	/* 14 PEX_CopyPipelineContext	*/
    BadPEXImplementationReq,	/* 15 PEX_FreePipelineContext	*/
    BadPEXImplementationReq,	/* 16 PEX_GetPipelineContext	*/
    BadPEXImplementationReq,	/* 17 PEX_ChangePipelineContext	*/
    fPexCreateRendererHandler,	/* 18 PEX_CreateRenderer	*/
    PexFreeRendererHandler,	/* 19 PEX_FreeRenderer		*/
    BadPEXImplementationReq,	/* 20 PEX_ChangeRenderer	*/
    BadPEXImplementationReq,	/* 21 PEX_GetRendererAttributes	*/
    PexBeginRenderingHandler,	/* 22 PEX_BeginRendering	*/
    PexEndRenderingHandler,	/* 23 PEX_EndRendering		*/
    PexBeginStructureHandler,	/* 24 PEX_BeginStructure	*/
    PexEndStructureHandler,	/* 25 PEX_EndStructure		*/
    fPexRenderOutputCommandsHandler,	/* 26 PEX_RenderOutputCommands	*/
    BadPEXImplementationReq,	/* 27 PEX_RenderNetwork		*/
    BadPEXImplementationReq,	/* 28 PEX_CreateStructure	*/
    BadPEXImplementationReq,	/* 29 PEX_CopyStructure		*/
    BadPEXImplementationReq,	/* 30 PEX_FreeStructure		*/
    BadPEXImplementationReq,	/* 31 PEX_DeleteStructures	*/
    BadPEXImplementationReq,	/* 32 PEX_GetStructureInfo	*/
    BadPEXImplementationReq,	/* 33 PEX_GetElementInfo	*/
    BadPEXImplementationReq,	/* 34 PEX_GetStructuresInNetwork*/
    BadPEXImplementationReq,	/* 35 PEX_GetAncestors		*/
    BadPEXImplementationReq,	/* 36 PEX_GetDescendants	*/
    BadPEXImplementationReq,	/* 37 PEX_FetchElements		*/
    BadPEXImplementationReq,	/* 38 PEX_SetEditingMode	*/
    BadPEXImplementationReq,	/* 39 PEX_SetElementPointer	*/
    BadPEXImplementationReq,	/* 40 PEX_SetElementPointerAtLabel*/
    BadPEXImplementationReq,	/* 41 PEX_ElementSearch		*/
    BadPEXImplementationReq,	/* 42 PEX_StoreElements		*/
    BadPEXImplementationReq,	/* 43 PEX_DeleteElements	*/
    BadPEXImplementationReq,	/* 44 PEX_DeleteElementsToLabel	*/
    BadPEXImplementationReq,	/* 45 PEX_DeleteBetweenLabels	*/
    BadPEXImplementationReq,	/* 46 PEX_CopyElements		*/
    BadPEXImplementationReq,	/* 47 PEX_ChangeStructureRefs	*/
    BadPEXImplementationReq,	/* 48 PEX_CreateNameSet		*/
    BadPEXImplementationReq,	/* 49 PEX_CopyNameSet		*/
    BadPEXImplementationReq,	/* 50 PEX_FreeNameSet		*/
    BadPEXImplementationReq,	/* 51 PEX_GetNameSet		*/
    BadPEXImplementationReq,	/* 52 PEX_ChangeNameSet		*/
    BadPEXImplementationReq,	/* 53 PEX_CreateSearchContext	*/
    BadPEXImplementationReq,	/* 54 PEX_CopySearchContext	*/
    BadPEXImplementationReq,	/* 55 PEX_FreeSearchContext	*/
    BadPEXImplementationReq,	/* 56 PEX_GetSearchContext	*/
    BadPEXImplementationReq,	/* 57 PEX_ChangeSearchContext	*/
    BadPEXImplementationReq,	/* 58 PEX_SearchNetwork		*/
    BadPEXImplementationReq,	/* 59 PEX_CreatepexPhigsWks	*/
    BadPEXImplementationReq,	/* 60 PEX_FreepexPhigsWks	*/
    BadPEXImplementationReq,	/* 61 PEX_GetWksInfo		*/
    BadPEXImplementationReq,	/* 62 PEX_GetDynamics		*/
    BadPEXImplementationReq,	/* 63 PEX_GetViewRep		*/
    BadPEXImplementationReq,	/* 64 PEX_RedrawAllStructures	*/
    BadPEXImplementationReq,	/* 65 PEX_UpdateWorkstation	*/
    BadPEXImplementationReq,	/* 66 PEX_ExecuteDeferredActions*/
    BadPEXImplementationReq,	/* 67 PEX_SetViewPriority	*/
    BadPEXImplementationReq,	/* 68 PEX_SetDisplayUpdateMode	*/
    BadPEXImplementationReq,	/* 69 PEX_MapPoints		*/
    fPexSetViewRepHandler,	/* 70 PEX_SetViewRep		*/
    BadPEXImplementationReq,	/* 71 PEX_SetWksWindow		*/
    BadPEXImplementationReq,	/* 72 PEX_SetWksViewport	*/
    BadPEXImplementationReq,	/* 73 PEX_SetHLHSRMode		*/
    BadPEXImplementationReq,	/* 74 PEX_PostStructure		*/
    BadPEXImplementationReq,	/* 75 PEX_UnpostStructure	*/
    BadPEXImplementationReq,	/* 76 PEXUnpostAllStructures	*/ 
    BadPEXImplementationReq,	/* 77 PEX_GetWksPostings	*/
    BadPEXImplementationReq,	/* 78 PEX_GetPickDevice		*/
    BadPEXImplementationReq,	/* 79 PEX_ChangePickDevice	*/
    BadPEXImplementationReq,	/* 80 PEX_CreatePickMeasure	*/
    BadPEXImplementationReq,	/* 81 PEX_FreePickMeasure	*/
    BadPEXImplementationReq,	/* 82 PEX_GetPickMeasure	*/
    BadPEXImplementationReq,	/* 83 PEX_UpdatePickMeasure	*/
    BadPEXImplementationReq,	/* 84 PEX_OpenFont		*/
    BadPEXImplementationReq,	/* 85 PEX_CloseFont		*/
    BadPEXImplementationReq,	/* 86 PEX_QueryFont		*/
    BadPEXImplementationReq,	/* 87 PEX_ListFonts		*/
    BadPEXImplementationReq,	/* 88 PEX_ListFontsWithInfo	*/
    BadPEXImplementationReq, 	/* 89 PEX_QueryTextExtents	*/
};

int (* sfPEXRequestVector[MaxPEXCommand])() = {
    BadPEXImplementationReq,	/* 0 Not Defined		*/
    BadPEXImplementationReq,	/* 1 PEX_GetExtensionInfo XXX	*/
    BadPEXImplementationReq,	/* 2 PEX_GetEnumeratedTypeInfo	*/
    BadPEXImplementationReq,	/* 3 PEX_CreateLookupTable	*/
    BadPEXImplementationReq,	/* 4 PEX_CopyLookupTable	*/
    BadPEXImplementationReq,	/* 5 PEX_FreeLookupTable	*/
    BadPEXImplementationReq,	/* 6 PEX_GetTableInfo		*/
    BadPEXImplementationReq,	/* 7 PEX_GetPredefinedEntries	*/
    BadPEXImplementationReq,	/* 8 PEX_GetDefinedIndices	*/
    BadPEXImplementationReq,	/* 9 PEX_GetTableEntry		*/
    BadPEXImplementationReq,	/* 10 PEX_GetTableEntries	*/
    BadPEXImplementationReq,	/* 11 PEX_SetTableEntries	*/
    BadPEXImplementationReq,	/* 12 PEX_DeleteTableEntries	*/
    BadPEXImplementationReq,	/* 13 PEX_CreatePipelineContext	*/
    BadPEXImplementationReq,	/* 14 PEX_CopyPipelineContext	*/
    BadPEXImplementationReq,	/* 15 PEX_FreePipelineContext	*/
    BadPEXImplementationReq,	/* 16 PEX_GetPipelineContext	*/
    BadPEXImplementationReq,	/* 17 PEX_ChangePipelineContext	*/
    sfPexCreateRendererHandler,	/* 18 PEX_CreateRenderer	*/
    sPexFreeRendererHandler,	/* 19 PEX_FreeRenderer		*/
    BadPEXImplementationReq,	/* 20 PEX_ChangeRenderer	*/
    BadPEXImplementationReq,	/* 21 PEX_GetRendererAttributes	*/
    sPexBeginRenderingHandler,	/* 22 PEX_BeginRendering	*/
    sPexEndRenderingHandler,	/* 23 PEX_EndRendering		*/
    sPexBeginStructureHandler,	/* 24 PEX_BeginStructure	*/
    sPexEndStructureHandler,	/* 25 PEX_EndStructure		*/
    sfPexRenderOutputCommandsHandler,	/* 26 PEX_RenderOutputCommands	*/
    BadPEXImplementationReq,	/* 27 PEX_RenderNetwork		*/
    BadPEXImplementationReq,	/* 28 PEX_CreateStructure	*/
    BadPEXImplementationReq,	/* 29 PEX_CopyStructure		*/
    BadPEXImplementationReq,	/* 30 PEX_FreeStructure		*/
    BadPEXImplementationReq,	/* 31 PEX_DeleteStructures	*/
    BadPEXImplementationReq,	/* 32 PEX_GetStructureInfo	*/
    BadPEXImplementationReq,	/* 33 PEX_GetElementInfo	*/
    BadPEXImplementationReq,	/* 34 PEX_GetStructuresInNetwork*/
    BadPEXImplementationReq,	/* 35 PEX_GetAncestors		*/
    BadPEXImplementationReq,	/* 36 PEX_GetDescendants	*/
    BadPEXImplementationReq,	/* 37 PEX_FetchElements		*/
    BadPEXImplementationReq,	/* 38 PEX_SetEditingMode	*/
    BadPEXImplementationReq,	/* 39 PEX_SetElementPointer	*/
    BadPEXImplementationReq,	/* 40 PEX_SetElementPointerAtLabel*/
    BadPEXImplementationReq,	/* 41 PEX_ElementSearch		*/
    BadPEXImplementationReq,	/* 42 PEX_StoreElements		*/
    BadPEXImplementationReq,	/* 43 PEX_DeleteElements	*/
    BadPEXImplementationReq,	/* 44 PEX_DeleteElementsToLabel	*/
    BadPEXImplementationReq,	/* 45 PEX_DeleteBetweenLabels	*/
    BadPEXImplementationReq,	/* 46 PEX_CopyElements		*/
    BadPEXImplementationReq,	/* 47 PEX_ChangeStructureRefs	*/
    BadPEXImplementationReq,	/* 48 PEX_CreateNameSet		*/
    BadPEXImplementationReq,	/* 49 PEX_CopyNameSet		*/
    BadPEXImplementationReq,	/* 50 PEX_FreeNameSet		*/
    BadPEXImplementationReq,	/* 51 PEX_GetNameSet		*/
    BadPEXImplementationReq,	/* 52 PEX_ChangeNameSet		*/
    BadPEXImplementationReq,	/* 53 PEX_CreateSearchContext	*/
    BadPEXImplementationReq,	/* 54 PEX_CopySearchContext	*/
    BadPEXImplementationReq,	/* 55 PEX_FreeSearchContext	*/
    BadPEXImplementationReq,	/* 56 PEX_GetSearchContext	*/
    BadPEXImplementationReq,	/* 57 PEX_ChangeSearchContext	*/
    BadPEXImplementationReq,	/* 58 PEX_SearchNetwork		*/
    BadPEXImplementationReq,	/* 59 PEX_CreatepexPhigsWks	*/
    BadPEXImplementationReq,	/* 60 PEX_FreepexPhigsWks	*/
    BadPEXImplementationReq,	/* 61 PEX_GetWksInfo		*/
    BadPEXImplementationReq,	/* 62 PEX_GetDynamics		*/
    BadPEXImplementationReq,	/* 63 PEX_GetViewRep		*/
    BadPEXImplementationReq,	/* 64 PEX_RedrawAllStructures	*/
    BadPEXImplementationReq,	/* 65 PEX_UpdateWorkstation	*/
    BadPEXImplementationReq,	/* 66 PEX_ExecuteDeferredActions*/
    BadPEXImplementationReq,	/* 67 PEX_SetViewPriority	*/
    BadPEXImplementationReq,	/* 68 PEX_SetDisplayUpdateMode	*/
    BadPEXImplementationReq,	/* 69 PEX_MapPoints		*/
    sfPexSetViewRepHandler,	/* 70 PEX_SetViewRep		*/
    BadPEXImplementationReq,	/* 71 PEX_SetWksWindow		*/
    BadPEXImplementationReq,	/* 72 PEX_SetWksViewport	*/
    BadPEXImplementationReq,	/* 73 PEX_SetHLHSRMode		*/
    BadPEXImplementationReq,	/* 74 PEX_PostStructure		*/
    BadPEXImplementationReq,	/* 75 PEX_UnpostStructure	*/
    BadPEXImplementationReq,	/* 76 PEXUnpostAllStructures	*/ 
    BadPEXImplementationReq,	/* 77 PEX_GetWksPostings	*/
    BadPEXImplementationReq,	/* 78 PEX_GetPickDevice		*/
    BadPEXImplementationReq,	/* 79 PEX_ChangePickDevice	*/
    BadPEXImplementationReq,	/* 80 PEX_CreatePickMeasure	*/
    BadPEXImplementationReq,	/* 81 PEX_FreePickMeasure	*/
    BadPEXImplementationReq,	/* 82 PEX_GetPickMeasure	*/
    BadPEXImplementationReq,	/* 83 PEX_UpdatePickMeasure	*/
    BadPEXImplementationReq,	/* 84 PEX_OpenFont		*/
    BadPEXImplementationReq,	/* 85 PEX_CloseFont		*/
    BadPEXImplementationReq,	/* 86 PEX_QueryFont		*/
    BadPEXImplementationReq,	/* 87 PEX_ListFonts		*/
    BadPEXImplementationReq,	/* 88 PEX_ListFontsWithInfo	*/
    BadPEXImplementationReq, 	/* 89 PEX_QueryTextExtents	*/
};
