/* 
 * pcinit.c - make a default pipeline context
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "PEXproto.h"
#include "PEX.h"
#include "renderer.h"
#include "pubstr.h"

/*****************************************************************
 * TAG( GetDefaultPC )
 * 
 * Set up a default pipeline context.
 * 
 * Inputs:
 *	[None]
 * Outputs:
 * 	ptr to a default PC (pexPipelineContextPtr)
 * Assumptions:
 *	[None]
 * Algorithm:
 *	[None]
 */

pexPipelineContextPtr
GetDefaultPC ()
{
    pexPipelineContextPtr NewPC;

    NewPC = (pexPipelineContextPtr) Xalloc (sizeof (pexPipelineContextRec));

    NewPC -> textColor.colorType = Indexed;
    NewPC -> textColor.color.format.indexed.index = 1;
    
    NewPC -> lineColor.colorType = Indexed;
    NewPC -> lineColor.color.format.indexed.index = 1;

    NewPC->curveApprox.approxMethod = ApproxConstantBetweenKnots;
    NewPC->curveApprox.tolerance = 4.0;

    NewPC -> interiorStyle = InteriorStyleHollow;
    
    NewPC -> surfaceColor.colorType = Indexed;
    NewPC -> surfaceColor.color.format.indexed.index = 1;

    NewPC -> reflectionAttr.ambient = 0.2;
    NewPC -> reflectionAttr.diffuse = 0.4;
    NewPC -> reflectionAttr.specular = 0.4;
    NewPC -> reflectionAttr.specularConc = 0.3;
    NewPC -> reflectionAttr.transmission = 0.0;
    NewPC -> reflectionAttr.specularColor.colorType = Indexed;
    NewPC -> reflectionAttr.specularColor.color.format.indexed.index = 1;

    NewPC -> surfaceInterp = SurfaceInterpNone;

    NewPC->surfaceApprox.approxMethod = ApproxConstantBetweenKnots;
    NewPC->surfaceApprox.sTolerance = 4.0;
    NewPC->surfaceApprox.tTolerance = 4.0;

    NewPC -> cullMode = None;

    NewPC -> distinguish = FALSE;
    NewPC -> normalFlip = FALSE;

    identm44 (NewPC -> localTransform);
    identm44 (NewPC -> globalTransform);

    NewPC -> viewIndex = 0;
    NewPC -> lightState = 1;

    NewPC -> OldPC = NULL;
		    
    return (NewPC);
}



/*****************************************************************
 * TAG( CopyPexPC )
 * 
 * Return a copy of its dereferenced parameter.
 * 
 * Inputs:
 * 	a ptr to the original PC
 * Outputs:
 * 	a ptr to a copy of the original PC
 * Assumptions:
 * 	you pass in a null ptr, you get what you deserve: garbage.
 * Algorithm:
 *	[None]
 */

pexPipelineContextPtr
CopyPexPC (oldpc)
    pexPipelineContextPtr oldpc;
{
    pexPipelineContextPtr result;

    if ( result = (pexPipelineContextPtr)
	Xalloc (sizeof(pexPipelineContextRec)) )
	bcopy (oldpc, result, sizeof (pexPipelineContextRec));
    
    return (result);
};
