/*
 * $Header: CScrollP.h,v 1.10 88/02/26 10:04:12 swick Exp $
 */


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _CScrollP_h
#define _CScrollP_h

#include <CScroll.h>
#include <X11/CoreP.h>

typedef struct {
     /* public */
    Pixel	  foreground;	/* thumb foreground color */
    XtOrientation orientation;	/* horizontal or vertical */
    XtCallbackList scrollProc;	/* smooth scroll */
    XtCallbackList thumbProc;	/* jump scroll */
    Pixmap	  thumb;	/* thumb color */
    Cursor	  upCursor;	/* scroll up cursor */
    Cursor	  downCursor;	/* scroll down cursor */
    Cursor	  leftCursor;	/* scroll left cursor */
    Cursor	  rightCursor;	/* scroll right cursor */
    Cursor	  verCursor;	/* scroll vertical cursor */
    Cursor	  horCursor;	/* scroll horizontal cursor */
    XFontStruct	* font;		/* Label font */
    char	* label;	/* Label scrollbar */
    float	  top;		/* What percent is above the win's top */
    float	  shown;	/* What percent is shown in the win */
    int		  length;	/* either height or width */
    int		  thickness;	/* either width or height */
    Boolean	  recenter;	/* If true, recenter after each mouse pick */
    Boolean	  discrete;	/* If true, thumb value = pos at end of move */
    Boolean	  relative;	/* If true, thumb value = offset from start */
     /* private */
    Cursor	  inactiveCursor; /* The normal cursor for scrollbar */
    char	  direction;	/* a scroll has started; which direction */
    GC		  gc;		/* a (shared) gc */
    GC		  lgc;		/* a (shared) gc for label text */
    int		  centerLoc;	/* Pixel that corresponds to centerline */
    int		  topLoc;	/* Pixel that corresponds to top */
    int		  shownLength;	/* Num pixels corresponding to shown */
    float	  startLoc;	/* Starting position for relative motion */
    int		  label_len;	/* Number of chars in label */
} CScrollbarPart;


typedef struct _CScrollbarRec {
    CorePart		core;
    CScrollbarPart	c_scrollbar;
} CScrollbarRec;


typedef struct {int empty;} CScrollbarClassPart;


typedef struct _CScrollbarClassRec {
    CoreClassPart		core_class;
    CScrollbarClassPart		c_scrollbar_class;
} CScrollbarClassRec;

#endif _CScrollP_h
